/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.output;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import jxl.JXLException;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.read.biff.BiffException;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import net.thucydides.core.matchers.SimpleValueMatcher;
import net.thucydides.core.output.ResultsOutput;

public class SpreadsheetResultsOutput
implements ResultsOutput {
    List<String> titles;
    File outputFile;
    boolean recordingStarted;

    public SpreadsheetResultsOutput(File outputFile, List<String> titles) {
        this.titles = ImmutableList.copyOf(titles);
        this.outputFile = outputFile;
        this.recordingStarted = false;
    }

    @Override
    public synchronized void recordResult(List<? extends Object> columnValues, SimpleValueMatcher ... validityChecks) throws IOException {
        WritableWorkbook workbook = null;
        try {
            workbook = this.currentWorkbook();
            this.writeRow(columnValues, workbook.getSheet(0), validityChecks);
            workbook.write();
        }
        catch (JXLException e) {
            throw new IOException(e);
        }
        finally {
            this.close(workbook);
        }
    }

    private void close(WritableWorkbook workbook) throws IOException {
        try {
            if (workbook != null) {
                workbook.close();
            }
        }
        catch (WriteException writeException) {
            // empty catch block
        }
    }

    private void writeRow(List<? extends Object> columnValues, WritableSheet sheet, SimpleValueMatcher ... checks) throws WriteException {
        this.recordingStarted = true;
        boolean isAFailedTest = this.checkIfTestHasFailed(checks);
        WritableCellFormat font = this.getFontFor(isAFailedTest);
        int row = sheet.getRows();
        int column = 0;
        for (Object object : columnValues) {
            Label resultCell = new Label(column++, row, object.toString(), (CellFormat)font);
            sheet.addCell((WritableCell)resultCell);
        }
    }

    private boolean checkIfTestHasFailed(SimpleValueMatcher[] checks) {
        boolean isAFailedTest = false;
        for (SimpleValueMatcher check : checks) {
            if (check.matches()) continue;
            isAFailedTest = true;
        }
        return isAFailedTest;
    }

    private WritableCellFormat getFontFor(boolean aFailedTest) throws WriteException {
        WritableFont baseFont = new WritableFont(WritableFont.ARIAL, 10);
        if (aFailedTest) {
            baseFont.setBoldStyle(WritableFont.BOLD);
            baseFont.setColour(Colour.RED);
        }
        return new WritableCellFormat(baseFont);
    }

    private WritableWorkbook currentWorkbook() throws IOException, BiffException {
        WritableWorkbook workbook = !this.recordingStarted || !this.outputFile.exists() ? this.createNewSpreadSheet(this.outputFile) : this.openExistingSpreadsheet();
        return workbook;
    }

    private WritableWorkbook openExistingSpreadsheet() throws BiffException, IOException {
        return Workbook.createWorkbook((File)this.outputFile, (Workbook)Workbook.getWorkbook((File)this.outputFile));
    }

    private WritableWorkbook createNewSpreadSheet(File outputFile) throws IOException {
        try {
            WorkbookSettings wbSettings = new WorkbookSettings();
            wbSettings.setLocale(new Locale("en", "EN"));
            WritableWorkbook workbook = Workbook.createWorkbook((File)outputFile, (WorkbookSettings)wbSettings);
            workbook.createSheet("Test Results", 0);
            WritableSheet sheet = workbook.getSheet(0);
            int cellIndex = 0;
            for (String title : this.titles) {
                Label label = new Label(cellIndex++, 0, title);
                sheet.addCell((WritableCell)label);
            }
            return workbook;
        }
        catch (JXLException e) {
            throw new IOException(e);
        }
    }
}

