/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html.screenshots;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.model.Screenshot;

public class ScreenshotFormatter {
    private final Screenshot screenshot;
    private final File sourceDirectory;
    private final boolean shouldKeepOriginalScreenshots;

    private ScreenshotFormatter(Screenshot screenshot, File sourceDirectory, boolean shouldKeepOriginalScreenshots) {
        this.screenshot = screenshot;
        this.sourceDirectory = sourceDirectory;
        this.shouldKeepOriginalScreenshots = shouldKeepOriginalScreenshots;
    }

    public static ScreenshotFormatter forScreenshot(Screenshot screenshot) {
        return new ScreenshotFormatter(screenshot, null, false);
    }

    public ScreenshotFormatter inDirectory(File sourceDirectory) {
        return new ScreenshotFormatter(this.screenshot, sourceDirectory, this.shouldKeepOriginalScreenshots);
    }

    public ScreenshotFormatter keepOriginals(boolean shouldKeepOriginalScreenshots) {
        return new ScreenshotFormatter(this.screenshot, this.sourceDirectory, shouldKeepOriginalScreenshots);
    }

    public Screenshot expandToHeight(int targetHeight) throws IOException {
        File screenshotFile = new File(this.sourceDirectory, this.screenshot.getFilename());
        if (screenshotFile.exists()) {
            File resizedFile = this.resizedImage(screenshotFile, targetHeight);
            return new Screenshot(resizedFile.getName(), this.screenshot.getDescription(), this.screenshot.getWidth(), this.screenshot.getError());
        }
        return this.screenshot;
    }

    private File resizedImage(File screenshotFile, int maxHeight) throws IOException {
        String resizedScreenshotFilename = "scaled_" + screenshotFile.getName();
        ResizableImage scaledImage = ResizableImage.loadFrom(screenshotFile).rescaleCanvas(maxHeight);
        File scaledFile = new File(this.sourceDirectory, resizedScreenshotFilename);
        scaledImage.saveTo(scaledFile);
        if (this.shouldKeepOriginalScreenshots) {
            this.saveCopyOf(screenshotFile);
        }
        screenshotFile.delete();
        Files.move(scaledFile.toPath(), screenshotFile.toPath(), new CopyOption[0]);
        return screenshotFile;
    }

    private void saveCopyOf(File screenshotFile) throws IOException {
        String backupScreenshotFilename = "original_" + screenshotFile.getName();
        Files.copy(screenshotFile.toPath(), new File(this.sourceDirectory, backupScreenshotFilename).toPath(), new CopyOption[0]);
    }
}

