/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.FormatConfiguration;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.json.JSONTestOutcomeReporter;
import net.thucydides.core.reports.xml.XMLTestOutcomeReporter;
import net.thucydides.core.util.EnvironmentVariables;

public class TestOutcomeLoader {
    private final EnvironmentVariables environmentVariables;
    private final FormatConfiguration formatConfiguration;

    public TestOutcomeLoader() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    @Inject
    public TestOutcomeLoader(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.formatConfiguration = new FormatConfiguration(environmentVariables);
    }

    public TestOutcomeLoader(EnvironmentVariables environmentVariables, FormatConfiguration formatConfiguration) {
        this.environmentVariables = environmentVariables;
        this.formatConfiguration = formatConfiguration;
    }

    public TestOutcomeLoader forFormat(OutcomeFormat format) {
        return new TestOutcomeLoader(this.environmentVariables, new FormatConfiguration(format));
    }

    public List<TestOutcome> loadFrom(File reportDirectory) throws IOException {
        AcceptanceTestLoader testOutcomeReporter = this.getOutcomeReporter();
        List<File> reportFiles = this.getAllOutcomeFilesFrom(reportDirectory);
        List testOutcomes = Collections.synchronizedList(new ArrayList());
        for (File reportFile : reportFiles) {
            testOutcomes.addAll(testOutcomeReporter.loadReportFrom(reportFile).asSet());
        }
        Collections.sort(testOutcomes, this.byTitle());
        return ImmutableList.copyOf(testOutcomes);
    }

    private Comparator<? super TestOutcome> byTitle() {
        return new Comparator<TestOutcome>(){

            @Override
            public int compare(TestOutcome a, TestOutcome b) {
                return a.getTitle().compareTo(b.getTitle());
            }
        };
    }

    private List<File> getAllOutcomeFilesFrom(File reportsDirectory) throws IOException {
        Object[] matchingFiles = reportsDirectory.listFiles(new SerializedOutcomeFilenameFilter());
        if (matchingFiles == null) {
            throw new IOException("Could not find directory " + reportsDirectory);
        }
        return ImmutableList.copyOf((Object[])matchingFiles);
    }

    public static TestOutcomeLoaderBuilder loadTestOutcomes() {
        return new TestOutcomeLoaderBuilder();
    }

    public static TestOutcomes testOutcomesIn(File reportsDirectory) throws IOException {
        TestOutcomeLoader loader = new TestOutcomeLoader();
        return TestOutcomes.of(loader.loadFrom(reportsDirectory));
    }

    public AcceptanceTestLoader getOutcomeReporter() {
        switch (this.formatConfiguration.getPreferredFormat()) {
            case XML: {
                return new XMLTestOutcomeReporter();
            }
            case JSON: {
                return new JSONTestOutcomeReporter();
            }
        }
        throw new IllegalArgumentException("Unsupported report format: " + (Object)((Object)this.formatConfiguration.getPreferredFormat()));
    }

    private class SerializedOutcomeFilenameFilter
    implements FilenameFilter {
        private SerializedOutcomeFilenameFilter() {
        }

        @Override
        public boolean accept(File file, String filename) {
            return filename.toLowerCase(Locale.getDefault()).endsWith(TestOutcomeLoader.this.formatConfiguration.getPreferredFormat().getExtension()) && !filename.endsWith(".features.json");
        }
    }

    public static final class TestOutcomeLoaderBuilder {
        OutcomeFormat format;

        public TestOutcomeLoaderBuilder inFormat(OutcomeFormat format) {
            this.format = format;
            return this;
        }

        public TestOutcomes from(File reportsDirectory) throws IOException {
            TestOutcomeLoader loader = new TestOutcomeLoader().forFormat(this.format);
            return TestOutcomes.of(loader.loadFrom(reportsDirectory));
        }
    }
}

