/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import com.google.common.base.Splitter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.maven.plugins.MavenProjectHelper;
import net.serenitybdd.maven.plugins.UpdatedClassLoader;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.ExtendedReports;
import net.thucydides.core.reports.ResultChecker;
import net.thucydides.core.reports.UserStoryTestReporter;
import net.thucydides.core.reports.html.HtmlAggregateStoryReporter;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="aggregate", requiresProject=false, requiresDependencyResolution=ResolutionScope.RUNTIME, aggregator=true)
public class SerenityAggregatorMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerenityAggregatorMojo.class);
    @Parameter(property="serenity.outputDirectory")
    public File outputDirectory;
    @Parameter(property="serenity.sourceDirectory")
    public File sourceDirectory;
    @Parameter
    public String issueTrackerUrl;
    @Parameter
    public String jiraUrl;
    @Parameter
    public String jiraUsername;
    @Parameter
    public String jiraPassword;
    @Parameter
    public String jiraProject;
    @Parameter
    public String requirementsBaseDir;
    EnvironmentVariables environmentVariables;
    Configuration configuration;
    @Parameter(defaultValue="${session}")
    protected MavenSession session;
    @Parameter(property="thucydides.project.key", defaultValue="default")
    public String projectKey;
    @Parameter(property="tags")
    public String tags;
    @Parameter(defaultValue="${project}")
    public MavenProject project;
    @Parameter
    public boolean generateOutcomes;
    @Parameter(property="serenity.reports")
    public String reports;
    @Parameter
    public Map<String, String> systemPropertyVariables;
    private HtmlAggregateStoryReporter reporter;

    protected void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
        this.getConfiguration().setOutputDirectory(this.outputDirectory);
    }

    protected void setSourceDirectory(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public void prepareExecution() throws MojoExecutionException {
        this.configureEnvironmentVariables();
        MavenProjectHelper.propagateBuildDir(this.session);
        this.configureOutputDirectorySettings();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        UpdatedClassLoader.withProjectClassesFrom(this.project);
    }

    private void configureOutputDirectorySettings() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.getConfiguration().getOutputDirectory();
        }
        if (this.sourceDirectory == null) {
            this.sourceDirectory = this.getConfiguration().getOutputDirectory();
        }
        Path projectDir = this.session.getCurrentProject().getBasedir().toPath();
        if (!this.outputDirectory.isAbsolute()) {
            this.outputDirectory = projectDir.resolve(this.outputDirectory.toPath()).toFile();
        }
        if (!this.sourceDirectory.isAbsolute()) {
            this.sourceDirectory = projectDir.resolve(this.sourceDirectory.toPath()).toFile();
        }
    }

    private EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        }
        return this.environmentVariables;
    }

    private Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = (Configuration)Injectors.getInjector().getProvider(Configuration.class).get();
        }
        return this.configuration;
    }

    private void configureEnvironmentVariables() {
        Locale.setDefault(Locale.ENGLISH);
        if (this.systemPropertyVariables != null) {
            this.systemPropertyVariables.forEach(System::setProperty);
        }
        this.updateSystemProperty(ThucydidesSystemProperty.SERENITY_PROJECT_KEY.getPropertyName(), this.projectKey, Serenity.getDefaultProjectKey());
        this.updateSystemProperty(ThucydidesSystemProperty.SERENITY_TEST_REQUIREMENTS_BASEDIR.toString(), this.requirementsBaseDir);
    }

    private void updateSystemProperty(String key, String value, String defaultValue) {
        this.getEnvironmentVariables().setProperty(key, Optional.ofNullable(value).orElse(defaultValue));
    }

    private void updateSystemProperty(String key, String value) {
        Optional.ofNullable(value).ifPresent(propertyValue -> this.getEnvironmentVariables().setProperty(key, propertyValue));
    }

    protected void setReporter(HtmlAggregateStoryReporter reporter) {
        this.reporter = reporter;
    }

    public void execute() throws MojoExecutionException {
        this.prepareExecution();
        try {
            this.generateHtmlStoryReports();
            this.generateExtraReports();
            this.generateCustomReports();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error generating aggregate serenity reports", (Exception)e);
        }
    }

    private void generateCustomReports() throws IOException {
        Collection<UserStoryTestReporter> customReporters = this.getCustomReportsFor(this.environmentVariables);
        for (UserStoryTestReporter reporter : customReporters) {
            reporter.generateReportsForTestResultsFrom(this.sourceOfTestResult());
        }
    }

    private Collection<UserStoryTestReporter> getCustomReportsFor(EnvironmentVariables environmentVariables) {
        return environmentVariables.getKeys().stream().filter(key -> key.startsWith("serenity.custom.reporters.")).map(this::reportFrom).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<UserStoryTestReporter> reportFrom(String key) {
        String reportClass = this.environmentVariables.getProperty(key);
        try {
            return Optional.of((UserStoryTestReporter)Class.forName(reportClass).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    protected HtmlAggregateStoryReporter getReporter() {
        if (this.reporter == null) {
            this.reporter = new HtmlAggregateStoryReporter(this.projectKey);
        }
        return this.reporter;
    }

    private void generateHtmlStoryReports() throws IOException {
        this.getReporter().setSourceDirectory(this.sourceDirectory);
        this.getReporter().setOutputDirectory(this.outputDirectory);
        this.getReporter().setIssueTrackerUrl(this.issueTrackerUrl);
        this.getReporter().setJiraUrl(this.jiraUrl);
        this.getReporter().setJiraProject(this.jiraProject);
        this.getReporter().setJiraUsername(this.jiraUsername);
        this.getReporter().setJiraPassword(this.jiraPassword);
        this.getReporter().setTags(this.tags);
        if (this.generateOutcomes) {
            this.getReporter().setGenerateTestOutcomeReports();
        }
        this.getReporter().generateReportsForTestResultsFrom(this.sourceDirectory);
        new ResultChecker(this.outputDirectory).checkTestResults();
    }

    private void generateExtraReports() {
        if (StringUtils.isEmpty((CharSequence)this.reports)) {
            return;
        }
        List extendedReportTypes = Splitter.on((String)",").splitToList((CharSequence)this.reports);
        ExtendedReports.named((List)extendedReportTypes).forEach(report -> {
            report.setSourceDirectory(this.sourceDirectory.toPath());
            report.setOutputDirectory(this.outputDirectory.toPath());
            Path generatedReport = report.generateReport();
            LOGGER.info("  - {}: {}", (Object)report.getDescription(), (Object)generatedReport.toUri());
        });
    }

    private File sourceOfTestResult() {
        if (this.sourceDirectory != null && this.sourceDirectory.exists()) {
            return this.sourceDirectory;
        }
        return this.outputDirectory;
    }
}

