/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.maven.plugins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

class UpdatedClassLoader {
    private MavenProject project;

    private UpdatedClassLoader(MavenProject project) {
        this.project = project;
    }

    static void withProjectClassesFrom(MavenProject project) throws MojoExecutionException {
        new UpdatedClassLoader(project).updateClassLoader();
    }

    private void updateClassLoader() throws MojoExecutionException {
        ClassLoader classLoader = this.getCompleteClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private ClassLoader getCompleteClassLoader() throws MojoExecutionException {
        try {
            HashSet<String> classpathElements = new HashSet<String>();
            classpathElements.addAll(this.buildClasspathElementsFrom(this.project));
            classpathElements.addAll(this.currentResources());
            URL[] urls = classpathElements.stream().map(this::urlFrom).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()).toArray(new URL[0]);
            return new URLClassLoader(urls, this.getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }

    private Collection<String> buildClasspathElementsFrom(MavenProject project) throws DependencyResolutionRequiredException {
        HashSet<String> elements = new HashSet<String>();
        if (project != null) {
            if (project.getCompileClasspathElements() != null) {
                elements.addAll(project.getCompileClasspathElements());
            }
            if (project.getBuild() != null) {
                elements.add(project.getBuild().getOutputDirectory());
                elements.add(project.getBuild().getTestOutputDirectory());
            }
        }
        return elements;
    }

    private List<String> currentResources() {
        if (Thread.currentThread().getContextClassLoader() instanceof URLClassLoader) {
            return Arrays.stream(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()).map(URL::getPath).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private Optional<URL> urlFrom(String classpathElement) {
        try {
            return Optional.of(new File(classpathElement).toURI().toURL());
        }
        catch (MalformedURLException e) {
            return Optional.empty();
        }
    }
}

