/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.serenitybdd.core.photography.DarkroomFileSystem;
import net.serenitybdd.core.photography.DarkroomProcessingLine;
import net.serenitybdd.core.photography.PhotoFilter;
import net.serenitybdd.core.photography.ScreenshotNegative;
import net.serenitybdd.core.photography.ScreenshotReceipt;
import net.serenitybdd.core.photography.bluring.Blurer;
import net.serenitybdd.core.photography.resizing.Resizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Darkroom {
    private static final Logger LOGGER = LoggerFactory.getLogger(Darkroom.class);
    private List<? extends PhotoFilter> processors = ImmutableList.of((Object)new Resizer(), (Object)new Blurer());
    private DarkroomProcessingLine processingLine;
    private Thread screenshotThread;
    private static ThreadLocal<Darkroom> theDarkroom = new ThreadLocal();

    public static void isOpenForBusiness() {
        if (Darkroom.theDarkroomIsClosed()) {
            LOGGER.debug("Opening darkroom");
            theDarkroom.set(new Darkroom());
        }
    }

    public Darkroom() {
        this.start();
    }

    private static boolean theDarkroomIsClosed() {
        return theDarkroom.get() == null;
    }

    private static boolean theDarkroomIsOpen() {
        return theDarkroom.get() != null;
    }

    public static void waitUntilClose() {
        LOGGER.debug("Closing darkroom");
        if (Darkroom.theDarkroomIsOpen()) {
            theDarkroom.get().terminate();
            theDarkroom.remove();
        }
    }

    public void start() {
        this.processingLine = new DarkroomProcessingLine(this.processors);
        this.screenshotThread = new Thread((Runnable)this.processingLine, "Darkroom Processing Line");
        this.screenshotThread.setDaemon(true);
        this.screenshotThread.start();
    }

    public void terminate() {
        this.processingLine.terminate();
        try {
            this.screenshotThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.error("Screenshot processing interrupted", (Throwable)e);
        }
        DarkroomFileSystem.close();
    }

    public ScreenshotReceipt submitForProcessing(ScreenshotNegative negative) {
        return this.processingLine.addToProcessingQueue(negative);
    }

    public static ScreenshotReceipt sendNegative(ScreenshotNegative screenshotNegative) {
        LOGGER.debug("Send negative for processing for " + screenshotNegative.getScreenshotPath());
        return theDarkroom.get().submitForProcessing(screenshotNegative);
    }
}

