/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import net.serenitybdd.core.exceptions.SerenityWebDriverException;
import net.serenitybdd.core.time.SystemClock;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.DataTableRow;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Screenshot;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestDuration;
import net.thucydides.core.model.TestOutcomeAnnotationReader;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.TestType;
import net.thucydides.core.model.failures.FailureAnalysis;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.model.results.MergeStepResultStrategy;
import net.thucydides.core.model.results.StepResultMergeStragegy;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.model.stacktrace.RootCauseAnalyzer;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.json.JSONConverter;
import net.thucydides.core.reports.saucelabs.LinkGenerator;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.statistics.model.TestStatistics;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderService;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOutcome {
    private static final int RECENT_TEST_RUN_COUNT = 10;
    private static final String ISSUES = "issues";
    private static final String NEW_LINE = System.getProperty("line.separator");
    @NotNull
    private String name;
    private transient Class<?> testCase;
    private String testCaseName;
    private final List<TestStep> testSteps = new ArrayList<TestStep>();
    private Story userStory;
    private String title;
    private String description;
    private String backgroundTitle;
    private String backgroundDescription;
    private List<String> coreIssues;
    private List<String> additionalIssues;
    private List<String> coreVersions;
    private List<String> additionalVersions;
    private Set<TestTag> tags;
    private Long startTime;
    private long duration;
    private Date testRunTimestamp;
    private String project;
    private FailureCause testFailureCause;
    private String testFailureClassname;
    private String testFailureMessage;
    private TestResult annotatedResult = null;
    private String sessionId;
    private String driver;
    private transient Stack<TestStep> groupStack = new Stack();
    private transient IssueTracking issueTracking;
    private transient EnvironmentVariables environmentVariables;
    private transient LinkGenerator linkGenerator;
    private TestStatistics statistics;
    private transient TagProviderService tagProviderService;
    private Optional<String> qualifier;
    private DataTable dataTable;
    private boolean manual;
    TestResult result;
    List<String> issues;
    List<String> versions;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestOutcome.class);
    private static final List<String> NO_HEADERS = Lists.newArrayList();

    private TestOutcome() {
        this.groupStack = new Stack();
        this.additionalIssues = Lists.newArrayList();
        this.additionalVersions = Lists.newArrayList();
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.qualifier = Optional.absent();
        this.groupStack = new Stack();
    }

    public TestOutcome(String name) {
        this(name, null);
    }

    public TestOutcome(String name, Class<?> testCase) {
        this.startTime = this.now().toDate().getTime();
        this.name = name;
        this.testCase = testCase;
        this.testCaseName = this.nameOf(testCase);
        this.additionalIssues = Lists.newArrayList();
        this.additionalVersions = Lists.newArrayList();
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.qualifier = Optional.absent();
        if (testCase != null) {
            this.initializeStoryFrom(testCase);
        }
    }

    public void calculateDynamicFieldValues() {
        this.getTitle();
        this.result = this.getResult();
        this.issues = this.getIssues();
        this.versions = this.getVersions();
        this.tags = this.getTags();
    }

    private String nameOf(Class<?> testCase) {
        if (testCase != null) {
            return testCase.getCanonicalName();
        }
        return null;
    }

    private TagProviderService getTagProviderService() {
        if (this.tagProviderService == null) {
            this.tagProviderService = (TagProviderService)Injectors.getInjector().getInstance(TagProviderService.class);
        }
        return this.tagProviderService;
    }

    public TestOutcome usingIssueTracking(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
        return this;
    }

    public TestOutcome asManualTest() {
        this.manual = true;
        return this;
    }

    public void setEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        }
        return this.environmentVariables;
    }

    protected TestOutcome(String name, Class<?> testCase, Story userStory) {
        this.startTime = this.now().toDate().getTime();
        this.name = name;
        this.testCase = testCase;
        this.testCaseName = this.nameOf(testCase);
        this.additionalIssues = Lists.newArrayList();
        this.additionalVersions = Lists.newArrayList();
        this.userStory = userStory;
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
    }

    public TestOutcome copy() {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual);
    }

    protected TestOutcome(Long startTime, long duration, String title, String description, String name, Class<?> testCase, List<TestStep> testSteps, List<String> issues, List<String> additionalIssues, Set<TestTag> tags, Story userStory, FailureCause testFailureCause, String testFailureClassname, String testFailureMessage, TestResult annotatedResult, DataTable dataTable, Optional<String> qualifier, String driver, boolean manualTest) {
        this.startTime = startTime;
        this.duration = duration;
        this.title = title;
        this.description = description;
        this.name = name;
        this.testCase = testCase;
        this.testCaseName = this.nameOf(testCase);
        this.addSteps(testSteps);
        this.coreIssues = this.removeDuplicates(issues);
        this.additionalVersions = this.removeDuplicates(this.additionalVersions);
        this.additionalIssues = additionalIssues;
        this.tags = tags;
        this.userStory = userStory;
        this.testFailureCause = testFailureCause;
        this.testFailureClassname = testFailureClassname;
        this.testFailureMessage = testFailureMessage;
        this.qualifier = qualifier;
        this.annotatedResult = annotatedResult;
        this.dataTable = dataTable;
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.linkGenerator = (LinkGenerator)Injectors.getInjector().getInstance(LinkGenerator.class);
        this.driver = driver;
        this.manual = manualTest;
    }

    private List<String> removeDuplicates(List<String> issues) {
        ArrayList issuesWithNoDuplicates = Lists.newArrayList();
        if (issues != null) {
            for (String issue : issues) {
                if (issuesWithNoDuplicates.contains(issue)) continue;
                issuesWithNoDuplicates.add(issue);
            }
        }
        return issuesWithNoDuplicates;
    }

    public static TestOutcome forTest(String methodName, Class<?> testCase) {
        return new TestOutcome(methodName, testCase);
    }

    public TestOutcome withQualifier(String qualifier) {
        if (qualifier != null) {
            return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.annotatedResult, this.dataTable, (Optional<String>)Optional.fromNullable((Object)qualifier), this.driver, this.manual);
        }
        return this;
    }

    public TestOutcome withIssues(List<String> issues) {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.testCase, this.testSteps, (List<String>)(issues == null ? issues : ImmutableList.copyOf(issues)), this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual);
    }

    public TestOutcome withTags(Set<TestTag> tags) {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, (Set<TestTag>)(tags == null ? tags : ImmutableSet.copyOf(tags)), this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual);
    }

    public TestOutcome withMethodName(String methodName) {
        if (methodName != null) {
            return new TestOutcome(this.startTime, this.duration, this.title, this.description, methodName, this.testCase, this.getTestSteps(), this.coreIssues, this.additionalIssues, this.tags, this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual);
        }
        return this;
    }

    private void initializeStoryFrom(Class<?> testCase) {
        Story story = Story.testedInTestCase(testCase) != null ? Story.from(Story.testedInTestCase(testCase)) : Story.from(testCase);
        this.setUserStory(story);
    }

    public String getName() {
        return this.name;
    }

    public static TestOutcome forTestInStory(String testName, Story story) {
        return new TestOutcome(testName, null, story);
    }

    public static TestOutcome forTestInStory(String testName, Class<?> testCase, Story story) {
        return new TestOutcome(testName, testCase, story);
    }

    public String toString() {
        return this.getTitle() + ":" + Lambda.join((Object)Lambda.extract(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).toString()));
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.obtainQualifiedTitleFromAnnotationOrMethodName();
        }
        return this.title;
    }

    public String getTitle(boolean qualified) {
        return qualified ? this.getTitle() : this.getFormatter().stripQualifications(this.getTitle());
    }

    public TitleBuilder getUnqualified() {
        return new TitleBuilder(this, false);
    }

    public TitleBuilder getQualified() {
        return new TitleBuilder(this, true);
    }

    public void setAllStepsTo(TestResult result) {
        for (TestStep step : this.testSteps) {
            step.setResult(result);
        }
    }

    public void addDataFrom(DataTable newDataTable) {
        if (this.dataTable == null) {
            this.dataTable = DataTable.withHeaders(newDataTable.getHeaders()).build();
        }
        this.dataTable.addRows(newDataTable.getRows());
    }

    public void clearForcedResult() {
        this.annotatedResult = null;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public void resetFailingStepsCausedBy(Class<? extends Throwable> expected) {
        for (TestStep step : this.testSteps) {
            this.resetFailingStepsIn(step).causedBy(expected);
        }
        this.clearTestFailure();
    }

    private void clearTestFailure() {
        this.testFailureCause = null;
        this.testFailureClassname = null;
        this.testFailureMessage = null;
        this.annotatedResult = null;
    }

    private StepResetBuilder resetFailingStepsIn(TestStep step) {
        return new StepResetBuilder(step);
    }

    public StepReplacer replace(List<TestStep> stepsToMerge) {
        return new StepReplacer(stepsToMerge);
    }

    public void mergeMostRecentSteps(int maxStepsToMerge) {
        Preconditions.checkArgument((maxStepsToMerge > 0 ? 1 : 0) != 0);
        List<TestStep> stepsToMerge = this.getLast(maxStepsToMerge).steps();
        TestStep mergedStep = this.merge(stepsToMerge);
        this.replace(stepsToMerge).with(mergedStep);
    }

    private GetLastStepBuilder getLast(int maxCount) {
        return new GetLastStepBuilder(maxCount);
    }

    public void updateOverallResults() {
        this.updateOverallResultsFor(this.testSteps);
    }

    private void updateOverallResultsFor(List<TestStep> testSteps) {
        for (TestStep testStep : testSteps) {
            this.updateOverallResultsFor(testStep.getChildren());
            this.updateOverallResultsFor(testStep);
        }
    }

    private void updateOverallResultsFor(TestStep testStep) {
        testStep.updateOverallResult();
    }

    private TestStep merge(List<TestStep> stepsToMerge) {
        TestStep mergedStep = stepsToMerge.get(0);
        for (TestStep nextStep : stepsToMerge.subList(1, stepsToMerge.size())) {
            mergedStep = this.mergeStep(mergedStep).into(nextStep);
        }
        return mergedStep;
    }

    private StepMergeBuilder mergeStep(TestStep step) {
        return new StepMergeBuilder(step);
    }

    private boolean wasUnsuccessful(TestStep previousStep) {
        return previousStep.getResult() == TestResult.ERROR || previousStep.getResult() == TestResult.FAILURE || previousStep.getResult() == TestResult.COMPROMISED;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBackgroundDescription(String description) {
        this.backgroundDescription = description.trim();
    }

    public void setBackgroundTitle(String title) {
        this.backgroundTitle = title.trim();
    }

    public String getDescription() {
        return this.description;
    }

    public String getBackgroundDescription() {
        return this.backgroundDescription;
    }

    public String getBackgroundTitle() {
        return this.backgroundTitle;
    }

    public Optional<String> getDescriptionText() {
        if (this.getDescription() != null) {
            return Optional.of((Object)this.description);
        }
        if (this.title != null) {
            return this.getDescriptionFrom(this.title);
        }
        return Optional.absent();
    }

    private Optional<String> getDescriptionFrom(String storedTitle) {
        ArrayList multilineTitle = Lists.newArrayList((Iterable)Splitter.on((Pattern)Pattern.compile("\r?\n")).split((CharSequence)storedTitle));
        if (multilineTitle.size() > 1) {
            multilineTitle.remove(0);
            return Optional.of((Object)Joiner.on((String)NEW_LINE).join((Iterable)multilineTitle));
        }
        return Optional.absent();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toJson() {
        JSONConverter jsonConverter = (JSONConverter)Injectors.getInjector().getInstance(JSONConverter.class);
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            jsonConverter.toJson(this, (OutputStream)outputStream);
            String string = outputStream.toString();
            return string;
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getTitleWithLinks() {
        return this.getFormatter().addLinks(this.getTitle());
    }

    private Formatter getFormatter() {
        return new Formatter(this.issueTracking);
    }

    private String obtainQualifiedTitleFromAnnotationOrMethodName() {
        if (this.qualifier != null && this.qualifier.isPresent()) {
            return this.qualified(this.getBaseTitleFromAnnotationOrMethodName());
        }
        return this.getBaseTitleFromAnnotationOrMethodName();
    }

    private String obtainUnqualifiedTitleFromAnnotationOrMethodName() {
        return this.getBaseTitleFromAnnotationOrMethodName();
    }

    private String getBaseTitleFromAnnotationOrMethodName() {
        Optional<String> annotatedTitle = TestAnnotations.forClass(this.testCase).getAnnotatedTitleForMethod(this.name);
        return (String)annotatedTitle.or((Object)NameConverter.humanize(NameConverter.withNoArguments(this.name)));
    }

    private String qualified(String rootTitle) {
        return rootTitle + " [" + (String)this.qualifier.get() + "]";
    }

    public String getStoryTitle() {
        return this.userStory != null ? this.getTitleFrom(this.userStory) : "";
    }

    public String getPath() {
        if (this.userStory != null) {
            return this.userStory.getPath();
        }
        return null;
    }

    public String getPathId() {
        if (this.userStory != null) {
            return this.userStory.getId();
        }
        return this.getPath();
    }

    private String getTitleFrom(Story userStory) {
        return userStory.getName() == null ? "" : userStory.getName();
    }

    public String getReportName(ReportType type) {
        return ReportNamer.forReportType(type).getNormalizedTestNameFor(this);
    }

    public String getSimpleReportName(ReportType type) {
        ReportNamer reportNamer = ReportNamer.forReportType(type);
        return reportNamer.getSimpleTestNameFor(this);
    }

    public String getHtmlReport() {
        return this.getReportName(ReportType.HTML);
    }

    public String getReportName() {
        return this.getReportName(ReportType.ROOT);
    }

    public String getScreenshotReportName() {
        return this.getReportName(ReportType.ROOT) + "_screenshots";
    }

    public List<TestStep> getTestSteps() {
        return ImmutableList.copyOf(this.testSteps);
    }

    public boolean hasScreenshots() {
        return !this.getScreenshots().isEmpty();
    }

    public boolean hasRestQueries() {
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (!step.hasRestQuery()) continue;
            return true;
        }
        return false;
    }

    public List<ScreenshotAndHtmlSource> getScreenshotAndHtmlSources() {
        List testStepsWithScreenshots = Lambda.select(this.getFlattenedTestSteps(), (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).needsScreenshots()));
        return Lambda.flatten((Object)Lambda.extract((Object)testStepsWithScreenshots, ((TestStep)Lambda.on(TestStep.class)).getScreenshots()));
    }

    public List<Screenshot> getScreenshots() {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        List testStepsWithScreenshots = Lambda.select(this.getFlattenedTestSteps(), (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).needsScreenshots()));
        for (TestStep currentStep : testStepsWithScreenshots) {
            screenshots.addAll(this.screenshotsIn(currentStep));
        }
        return ImmutableList.copyOf(screenshots);
    }

    private List<Screenshot> screenshotsIn(TestStep currentStep) {
        return Lambda.convert(currentStep.getScreenshots(), this.toScreenshotsFor(currentStep));
    }

    private Converter<ScreenshotAndHtmlSource, Screenshot> toScreenshotsFor(final TestStep currentStep) {
        return new Converter<ScreenshotAndHtmlSource, Screenshot>(){

            public Screenshot convert(ScreenshotAndHtmlSource from) {
                return new Screenshot(from.getScreenshot().getName(), currentStep.getDescription(), TestOutcome.this.widthOf(from.getScreenshot()), currentStep.getException());
            }
        };
    }

    private int widthOf(File screenshot) {
        try {
            return new ResizableImage(screenshot).getWidth();
        }
        catch (IOException e) {
            return 960;
        }
    }

    public boolean hasNonStepFailure() {
        boolean stepsContainFailure = false;
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (step.getResult() != TestResult.FAILURE && step.getResult() != TestResult.ERROR && step.getResult() != TestResult.COMPROMISED) continue;
            stepsContainFailure = true;
        }
        return !stepsContainFailure && (this.getResult() == TestResult.ERROR || this.getResult() == TestResult.FAILURE || this.getResult() == TestResult.COMPROMISED);
    }

    public List<TestStep> getFlattenedTestSteps() {
        ArrayList<? extends TestStep> flattenedTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            flattenedTestSteps.add(step);
            if (!step.isAGroup()) continue;
            flattenedTestSteps.addAll(step.getFlattenedSteps());
        }
        return ImmutableList.copyOf(flattenedTestSteps);
    }

    public List<TestStep> getLeafTestSteps() {
        ArrayList<? extends TestStep> leafTestSteps = new ArrayList<TestStep>();
        for (TestStep step : this.getTestSteps()) {
            if (step.isAGroup()) {
                leafTestSteps.addAll(step.getLeafTestSteps());
                continue;
            }
            leafTestSteps.add(step);
        }
        return ImmutableList.copyOf(leafTestSteps);
    }

    public TestResult getResult() {
        if (this.annotatedResult != null) {
            return this.annotatedResult;
        }
        if (this.testFailureClassname != null) {
            try {
                return new FailureAnalysis().resultFor(Class.forName(this.testFailureClassname));
            }
            catch (ReflectiveOperationException e) {
                return TestResult.ERROR;
            }
        }
        TestResultList testResults = TestResultList.of(this.getCurrentTestResults());
        return testResults.getOverallResult();
    }

    public TestOutcome recordSteps(List<TestStep> steps) {
        for (TestStep step : steps) {
            this.recordStep(step);
        }
        return this;
    }

    public TestOutcome recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        if (this.inGroup()) {
            this.getCurrentStepGroup().addChildStep(step);
            this.renumberTestSteps();
        } else {
            this.addStep(step);
        }
        return this;
    }

    private void addStep(TestStep step) {
        this.testSteps.add(step);
        this.renumberTestSteps();
    }

    private void addSteps(List<TestStep> steps) {
        this.testSteps.addAll(steps);
        this.renumberTestSteps();
    }

    private void renumberTestSteps() {
        int count = 1;
        for (TestStep step : this.testSteps) {
            count = step.renumberFrom(count);
        }
    }

    private TestStep getCurrentStepGroup() {
        return this.groupStack.peek();
    }

    private boolean inGroup() {
        return !this.groupStack.empty();
    }

    public ApplicationFeature getFeature() {
        if (this.getUserStory() != null && this.getUserStory().getFeature() != null) {
            return this.getUserStory().getFeature();
        }
        return null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private List<TestResult> getCurrentTestResults() {
        return Lambda.convert(this.testSteps, (Converter)new ExtractTestResultsConverter());
    }

    @Deprecated
    public void startGroup(String groupName) {
        this.recordStep(new TestStep(groupName));
        this.startGroup();
    }

    public Optional<String> getQualifier() {
        return this.qualifier;
    }

    public void startGroup() {
        if (!this.testSteps.isEmpty()) {
            this.groupStack.push(this.currentStep());
        }
    }

    public void endGroup() {
        if (!this.groupStack.isEmpty()) {
            this.groupStack.pop();
        }
    }

    public TestStep currentStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    public TestStep lastStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    private TestStep lastStepIn(List<TestStep> testSteps) {
        return testSteps.get(testSteps.size() - 1);
    }

    private Optional<TestStep> lastUnfinishedStepIn(List<TestStep> testSteps) {
        TestStep lastStep = testSteps.get(testSteps.size() - 1);
        if (lastStep.getResult() == null) {
            return Optional.of((Object)lastStep);
        }
        return Optional.absent();
    }

    public TestStep currentGroup() {
        Preconditions.checkState((boolean)this.inGroup());
        return this.groupStack.peek();
    }

    public void setUserStory(Story story) {
        this.userStory = story;
    }

    public void determineTestFailureCause(Throwable cause) {
        if (cause != null) {
            RootCauseAnalyzer rootCauseAnalyser = new RootCauseAnalyzer(SerenityWebDriverException.detachedCopyOf(cause));
            FailureCause rootCause = rootCauseAnalyser.getRootCause();
            this.testFailureClassname = rootCauseAnalyser.getRootCause().getErrorType();
            this.testFailureMessage = rootCauseAnalyser.getMessage();
            this.setAnnotatedResult(new FailureAnalysis().resultFor(rootCause.exceptionClass()));
            this.testFailureCause = rootCause;
        } else {
            this.testFailureCause = null;
            this.testFailureClassname = "";
            this.testFailureMessage = "";
        }
    }

    public void setTestFailureCause(FailureCause testFailureCause) {
        this.testFailureCause = testFailureCause;
    }

    public void setTestFailureClassname(String testFailureClassname) {
        this.testFailureClassname = testFailureClassname;
    }

    public FailureCause getTestFailureCause() {
        return this.testFailureCause;
    }

    public FailureCause getNestedTestFailureCause() {
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (step.getException() == null) continue;
            return step.getException();
        }
        return this.getTestFailureCause();
    }

    private Optional<TestStep> firstStepWithErrorMessage() {
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (!StringUtils.isNotBlank((CharSequence)step.getErrorMessage())) continue;
            return Optional.of((Object)step);
        }
        return Optional.absent();
    }

    public Optional<String> testFailureMessage() {
        return Optional.fromNullable((Object)this.testFailureMessage);
    }

    public String getErrorMessage() {
        if (this.firstStepWithErrorMessage().isPresent()) {
            return ((TestStep)this.firstStepWithErrorMessage().get()).getErrorMessage();
        }
        return (String)this.testFailureMessage().or((Object)"");
    }

    public String getConciseErrorMessage() {
        if (this.firstStepWithErrorMessage().isPresent()) {
            return ((TestStep)this.firstStepWithErrorMessage().get()).getConciseErrorMessage();
        }
        return (String)this.testFailureMessage().or((Object)"");
    }

    public void setTestFailureMessage(String testFailureMessage) {
        this.testFailureMessage = testFailureMessage;
    }

    public String getTestFailureMessage() {
        return this.testFailureMessage;
    }

    public String getTestFailureClassname() {
        return this.testFailureClassname;
    }

    public void setAnnotatedResult(TestResult annotatedResult) {
        if (this.annotatedResult != TestResult.PENDING) {
            this.annotatedResult = annotatedResult;
        }
    }

    public TestResult getAnnotatedResult() {
        return this.annotatedResult;
    }

    public List<String> getAdditionalVersions() {
        return this.additionalVersions;
    }

    public List<String> getAdditionalIssues() {
        return this.additionalIssues;
    }

    private List<String> issues() {
        if (!this.thereAre(this.coreIssues)) {
            this.coreIssues = this.removeDuplicates(this.readIssues());
        }
        return this.coreIssues;
    }

    public List<String> getIssues() {
        ArrayList<String> allIssues = new ArrayList<String>(this.issues());
        if (this.thereAre(this.additionalIssues)) {
            allIssues.addAll(this.additionalIssues);
        }
        return ImmutableList.copyOf(allIssues);
    }

    private List<String> versions() {
        if (!this.thereAre(this.coreVersions)) {
            this.coreVersions = this.removeDuplicates(this.readVersions());
        }
        return this.coreVersions;
    }

    private List<String> readVersions() {
        return TestOutcomeAnnotationReader.forTestOutcome(this).readVersions();
    }

    public List<String> getVersions() {
        ArrayList<String> allVersions = new ArrayList<String>(this.versions());
        if (this.thereAre(this.additionalVersions)) {
            allVersions.addAll(this.additionalVersions);
        }
        this.addVersionsDefinedInTagsTo(allVersions);
        return ImmutableList.copyOf(allVersions);
    }

    private void addVersionsDefinedInTagsTo(List<String> allVersions) {
        for (TestTag tag : this.getTags()) {
            if (!tag.getType().equalsIgnoreCase("version") || allVersions.contains(tag.getName())) continue;
            allVersions.add(tag.getName());
        }
    }

    public Class<?> getTestCase() {
        if (this.testCase == null) {
            this.testCase = this.findTestCaseFromName(this.testCaseName);
        }
        return this.testCase;
    }

    private Class<?> findTestCaseFromName(String testCaseName) {
        try {
            return testCaseName != null ? Class.forName(testCaseName) : null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    private boolean thereAre(Collection<String> anyIssues) {
        return anyIssues != null && !anyIssues.isEmpty();
    }

    public TestOutcome addVersion(String version) {
        if (!this.getVersions().contains(version)) {
            this.additionalVersions.add(version);
        }
        return this;
    }

    public TestOutcome addVersions(List<String> versions) {
        for (String version : versions) {
            this.addVersion(version);
        }
        return this;
    }

    public TestOutcome forProject(String project) {
        this.project = project;
        return this;
    }

    public String getProject() {
        return this.project;
    }

    public TestOutcome inTestRunTimestamped(DateTime testRunTimestamp) {
        this.setTestRunTimestamp(testRunTimestamp);
        return this;
    }

    public void setTestRunTimestamp(DateTime testRunTimestamp) {
        this.testRunTimestamp = testRunTimestamp.toDate();
    }

    public void addIssues(List<String> issues) {
        this.additionalIssues.addAll(issues);
    }

    private List<String> readIssues() {
        return TestOutcomeAnnotationReader.forTestOutcome(this).readIssues();
    }

    public String getFormattedIssues() {
        HashSet issues = Sets.newHashSet(this.getIssues());
        if (!issues.isEmpty()) {
            List orderedIssues = Lambda.sort((Object)issues, (Object)Lambda.on(String.class));
            return "(" + this.getFormatter().addLinks(StringUtils.join((Iterable)orderedIssues, (String)", ")) + ")";
        }
        return "";
    }

    public void isRelatedToIssue(String issue) {
        if (!this.issues().contains(issue)) {
            this.issues().add(issue);
        }
    }

    public void addFailingExternalStep(Throwable testFailureCause) {
        this.addFailingStepAsSibling(this.testSteps, testFailureCause);
    }

    public void addFailingStepAsSibling(List<TestStep> testStepList, Throwable testFailureCause) {
        if (testStepList.isEmpty()) {
            this.addStep(this.failingStep(testFailureCause));
        } else {
            TestStep lastStep = this.lastStepIn(testStepList);
            if (lastStep.hasChildren()) {
                this.addFailingStepAsSibling(lastStep.children(), testFailureCause);
            } else {
                testStepList.add(this.failingStep(testFailureCause));
            }
        }
    }

    private TestStep failingStep(Throwable testFailureCause) {
        TestStep failingStep = new TestStep("Failure");
        failingStep.failedWith(testFailureCause);
        return failingStep;
    }

    public void lastStepFailedWith(StepFailure failure) {
        this.lastStepFailedWith(failure.getException());
    }

    public void lastStepFailedWith(Throwable testFailureCause) {
        this.determineTestFailureCause(testFailureCause);
        TestStep lastTestStep = this.testSteps.get(this.testSteps.size() - 1);
        lastTestStep.failedWith(new StepFailureException(testFailureCause.getMessage(), testFailureCause));
    }

    public Set<TestTag> getTags() {
        if (this.tags == null) {
            this.tags = this.getTagsUsingTagProviders(this.getTagProviderService().getTagProviders());
        }
        return ImmutableSet.copyOf(this.tags);
    }

    private Set<TestTag> getTagsUsingTagProviders(List<TagProvider> tagProviders) {
        Set<Object> tags = Sets.newHashSet();
        for (TagProvider tagProvider : tagProviders) {
            try {
                tags.addAll(tagProvider.getTagsFor(this));
            }
            catch (Throwable theTagProviderFailedButThereIsntMuchWeCanDoAboutIt) {
                LOGGER.error("Tag provider " + tagProvider + " failure", theTagProviderFailedButThereIsntMuchWeCanDoAboutIt);
            }
        }
        tags = this.removeRedundantTagsFrom((Set<TestTag>)tags);
        return tags;
    }

    private Set<TestTag> removeRedundantTagsFrom(Set<TestTag> tags) {
        HashSet optimizedTags = Sets.newHashSet();
        for (TestTag tag : tags) {
            if (this.aMoreSpecificTagExistsThan(tag).in(tags)) continue;
            optimizedTags.add(tag);
        }
        return optimizedTags;
    }

    private SpecificTagFinder aMoreSpecificTagExistsThan(TestTag tag) {
        return new SpecificTagFinder(tag);
    }

    public void setTags(Set<TestTag> tags) {
        this.tags = Sets.newHashSet(tags);
    }

    public void addTags(List<TestTag> tags) {
        HashSet updatedTags = Sets.newHashSet(this.getTags());
        updatedTags.addAll(tags);
        this.tags = ImmutableSet.copyOf((Collection)updatedTags);
    }

    public void addTag(TestTag tag) {
        HashSet updatedTags = Sets.newHashSet(this.getTags());
        updatedTags.add(tag);
        this.tags = ImmutableSet.copyOf((Collection)updatedTags);
    }

    public List<String> getIssueKeys() {
        return Lambda.convert(this.getIssues(), this.toIssueKeys());
    }

    private Converter<String, String> toIssueKeys() {
        return new Converter<String, String>(){

            public String convert(String issueNumber) {
                String issueKey = issueNumber;
                if (issueKey.startsWith("#")) {
                    issueKey = issueKey.substring(1);
                }
                if (StringUtils.isNumeric((CharSequence)issueKey) && TestOutcome.this.getProjectPrefix() != null) {
                    Joiner joiner = Joiner.on((String)"-");
                    issueKey = joiner.join((Object)TestOutcome.this.getProjectPrefix(), (Object)issueKey, new Object[0]);
                }
                return issueKey;
            }
        };
    }

    private String getProjectPrefix() {
        return ThucydidesSystemProperty.THUCYDIDES_PROJECT_KEY.from(this.getEnvironmentVariables());
    }

    public String getQualifiedMethodName() {
        if (this.qualifier != null && this.qualifier.isPresent()) {
            String qualifierWithoutSpaces = ((String)this.qualifier.get()).replaceAll(" ", "_");
            return this.getName() + "_" + qualifierWithoutSpaces;
        }
        return this.getName();
    }

    public String getCompleteName() {
        if (StringUtils.isNotEmpty((CharSequence)this.getStoryTitle())) {
            return this.getStoryTitle() + ":" + this.getName();
        }
        return this.getTestCase() + ":" + this.getName();
    }

    public void useExamplesFrom(DataTable table) {
        this.dataTable = table;
    }

    public void addNewExamplesFrom(DataTable table) {
        List<DataTableRow> updatedRows = table.getRows();
        if (table.getSize() > this.dataTable.getSize()) {
            for (int rowNumber = this.dataTable.getSize(); rowNumber < updatedRows.size(); ++rowNumber) {
                this.dataTable.appendRow(updatedRows.get(rowNumber));
            }
        }
    }

    public void moveToNextRow() {
        if (this.dataTable != null && !this.dataTable.atLastRow()) {
            this.dataTable.nextRow();
        }
    }

    public void updateCurrentRowResult(TestResult result) {
        this.dataTable.currentRow().hasResult(result);
    }

    public boolean dataIsPredefined() {
        return this.dataTable.hasPredefinedRows();
    }

    public void addRow(Map<String, ?> data) {
        this.dataTable.addRow(data);
    }

    public void addRow(DataTableRow dataTableRow) {
        this.dataTable.addRow(dataTableRow);
    }

    public int getTestCount() {
        return this.isDataDriven() ? this.getDataTable().getSize() : 1;
    }

    public int getImplementedTestCount() {
        return this.getStepCount() > 0 ? this.getTestCount() : 0;
    }

    public int countResults(TestResult expectedResult) {
        return this.countResults(expectedResult, TestType.ANY);
    }

    public int countResults(TestResult expectedResult, TestType expectedType) {
        if (this.annotatedResult != null) {
            return this.annotatedResultCount(expectedResult, expectedType);
        }
        if (this.isDataDriven()) {
            return this.countDataRowsWithResult(expectedResult);
        }
        return this.getResult() == expectedResult && this.typeCompatibleWith(expectedType) ? 1 : 0;
    }

    private int annotatedResultCount(TestResult expectedResult, TestType expectedType) {
        if (this.annotatedResult == expectedResult && this.typeCompatibleWith(expectedType)) {
            return this.isDataDriven() ? this.dataTable.getSize() : 1;
        }
        return 0;
    }

    public boolean typeCompatibleWith(TestType testType) {
        switch (testType) {
            case MANUAL: {
                return this.isManual();
            }
            case AUTOMATED: {
                return !this.isManual();
            }
        }
        return true;
    }

    private int countDataRowsWithResult(TestResult expectedResult) {
        List matchingRows = Lambda.filter((Matcher)Lambda.having((Object)((Object)((DataTableRow)Lambda.on(DataTableRow.class)).getResult()), (Matcher)Matchers.is((Object)((Object)expectedResult))), this.getDataTable().getRows());
        return matchingRows.size();
    }

    public int countNestedStepsWithResult(TestResult expectedResult, TestType testType) {
        if (this.isDataDriven()) {
            return this.countDataRowStepsWithResult(expectedResult);
        }
        return this.getResult() == expectedResult && this.typeCompatibleWith(testType) ? this.getNestedStepCount() : 0;
    }

    private int countDataRowStepsWithResult(TestResult expectedResult) {
        int rowsWithResult = this.countDataRowsWithResult(expectedResult);
        int totalRows = this.getDataTable().getSize();
        int totalSteps = this.getNestedStepCount();
        return totalSteps * rowsWithResult / totalRows;
    }

    public Optional<String> getTagValue(String tagType) {
        if (tagType.equalsIgnoreCase(ISSUES) && !this.getIssueKeys().isEmpty()) {
            return Optional.of((Object)Joiner.on((String)",").join(this.getIssueKeys()));
        }
        for (TestTag tag : this.getTags()) {
            if (!tag.getType().equalsIgnoreCase(tagType)) continue;
            return Optional.of((Object)tag.getName());
        }
        return Optional.absent();
    }

    public boolean hasIssue(String issue) {
        return this.getIssues().contains(issue);
    }

    public boolean hasTag(TestTag tag) {
        return this.getTags().contains(tag);
    }

    public void setStartTime(DateTime startTime) {
        this.startTime = startTime.toDate().getTime();
    }

    public void clearStartTime() {
        this.startTime = null;
    }

    public boolean isManual() {
        return this.manual;
    }

    public boolean isStartTimeNotDefined() {
        return this.startTime == null;
    }

    private SystemClock getSystemClock() {
        return (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
    }

    private DateTime now() {
        return this.getSystemClock().getCurrentTime();
    }

    public OptionalElements has() {
        return new OptionalElements(this);
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getNestedStepCount() {
        return this.getFlattenedTestSteps().size();
    }

    public Integer getSuccessCount() {
        return this.count(this.successfulSteps()).in(this.getLeafTestSteps());
    }

    public Integer getFailureCount() {
        return this.count(this.failingSteps()).in(this.getLeafTestSteps());
    }

    public Integer getErrorCount() {
        return this.count(this.errorSteps()).in(this.getLeafTestSteps());
    }

    public Integer getCompromisedCount() {
        return this.count(this.compromisedSteps()).in(this.getLeafTestSteps());
    }

    public Integer getIgnoredCount() {
        return this.count(this.ignoredSteps()).in(this.getLeafTestSteps());
    }

    public Integer getSkippedOrIgnoredCount() {
        return this.getIgnoredCount() + this.getSkippedCount();
    }

    public Integer getSkippedCount() {
        return this.count(this.skippedSteps()).in(this.getLeafTestSteps());
    }

    public Integer getPendingCount() {
        List<TestStep> allTestSteps = this.getLeafTestSteps();
        return Lambda.select(allTestSteps, (Matcher)Lambda.having((Boolean)((TestStep)Lambda.on(TestStep.class)).isPending())).size();
    }

    public Boolean isSuccess() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isCompromised() {
        return this.getResult() == TestResult.COMPROMISED;
    }

    public Boolean isError() {
        return this.getResult() == TestResult.ERROR;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED || this.getResult() == TestResult.IGNORED;
    }

    public Story getUserStory() {
        return this.userStory;
    }

    public void recordDuration() {
        this.setDuration(System.currentTimeMillis() - this.startTime);
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Long getDuration() {
        if (this.duration == 0L && this.testSteps.size() > 0) {
            return (Long)Lambda.sum(this.testSteps, (Object)((TestStep)Lambda.on(TestStep.class)).getDuration());
        }
        return this.duration;
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.duration).inSeconds();
    }

    public String getVideoLink() {
        return this.linkGenerator.linkFor(this);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    StepCountBuilder count(StepFilter filter) {
        return new StepCountBuilder(filter);
    }

    public Integer countTestSteps() {
        return this.countLeafStepsIn(this.testSteps);
    }

    private Integer countLeafStepsIn(List<TestStep> testSteps) {
        int leafCount = 0;
        for (TestStep step : testSteps) {
            if (step.isAGroup()) {
                leafCount += this.countLeafStepsIn(step.getChildren()).intValue();
                continue;
            }
            ++leafCount;
        }
        return leafCount;
    }

    StepFilter successfulSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isSuccessful();
            }
        };
    }

    StepFilter failingSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isFailure();
            }
        };
    }

    StepFilter errorSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isError();
            }
        };
    }

    StepFilter compromisedSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isCompromised();
            }
        };
    }

    StepFilter ignoredSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isIgnored();
            }
        };
    }

    StepFilter skippedSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isSkipped();
            }
        };
    }

    public void setStatistics(TestStatistics statistics) {
        this.statistics = statistics;
    }

    public TestStatistics getStatistics() {
        return this.statistics;
    }

    public double getOverallStability() {
        if (this.getStatistics() == null) {
            return 0.0;
        }
        return this.getStatistics().getOverallPassRate();
    }

    public double getRecentStability() {
        if (this.getStatistics() == null) {
            return 0.0;
        }
        return this.getStatistics().getPassRate().overTheLast(10).testRuns();
    }

    public Long getRecentTestRunCount() {
        if (this.getStatistics() == null) {
            return 0L;
        }
        return this.getStatistics().getTotalTestRuns() > 10L ? 10L : this.getStatistics().getTotalTestRuns();
    }

    public int getRecentPassCount() {
        if (this.getStatistics() == null) {
            return 0;
        }
        return this.getStatistics().countResults().overTheLast(10).whereTheOutcomeWas(TestResult.SUCCESS);
    }

    public int getRecentFailCount() {
        if (this.getStatistics() == null) {
            return 0;
        }
        return this.getStatistics().countResults().overTheLast(10).whereTheOutcomeWas(TestResult.FAILURE);
    }

    public int getRecentPendingCount() {
        if (this.getStatistics() == null) {
            return 0;
        }
        return this.getStatistics().countResults().overTheLast(10).whereTheOutcomeWas(TestResult.PENDING);
    }

    public DateTime getStartTime() {
        return new DateTime((Object)this.startTime);
    }

    public DateTime getTestRunTimestamp() {
        return new DateTime((Object)this.testRunTimestamp);
    }

    public boolean isDataDriven() {
        return this.dataTable != null;
    }

    public List<String> getExampleFields() {
        return this.isDataDriven() ? this.getDataTable().getHeaders() : NO_HEADERS;
    }

    public String getDataDrivenSampleScenario() {
        if (!this.isDataDriven() || this.getTestSteps().isEmpty() || !this.getTestSteps().get(0).hasChildren()) {
            return "";
        }
        TestStep firstExample = this.getTestSteps().get(0);
        StringBuilder sampleScenario = new StringBuilder();
        for (TestStep topLevelChildStep : firstExample.getChildren()) {
            sampleScenario.append(topLevelChildStep.getDescription());
            if (topLevelChildStep == this.lastOf(firstExample.getChildren())) continue;
            sampleScenario.append("\n");
        }
        return sampleScenario.toString();
    }

    private TestStep lastOf(List<TestStep> children) {
        return children.get(children.size() - 1);
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestOutcome that = (TestOutcome)o;
        if (this.manual != that.manual) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifier.equals(that.qualifier) : that.qualifier != null) {
            return false;
        }
        if (this.testCaseName != null ? !this.testCaseName.equals(that.testCaseName) : that.testCaseName != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return !(this.userStory != null ? !this.userStory.equals(that.userStory) : that.userStory != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.testCase != null ? this.testCase.hashCode() : 0);
        result = 31 * result + (this.userStory != null ? this.userStory.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        result = 31 * result + (this.manual ? 1 : 0);
        return result;
    }

    public Optional<TestTag> getFeatureTag() {
        if (this.getPath() != null) {
            if (this.getPath().endsWith(".feature")) {
                String featureName = NameConverter.humanize(new File(this.getPath()).getName().replace(".feature", ""));
                return Optional.of((Object)TestTag.withName(featureName).andType("feature"));
            }
            if (this.getPath().endsWith(".story")) {
                String featureName = NameConverter.humanize(new File(this.getPath()).getName().replace(".story", ""));
                return Optional.of((Object)TestTag.withName(featureName).andType("story"));
            }
        }
        return Optional.absent();
    }

    private void removeSteps(List<TestStep> stepsToReplace) {
        ImmutableList currentTestSteps = ImmutableList.copyOf(this.testSteps);
        for (TestStep testStep : currentTestSteps) {
            if (!stepsToReplace.contains(testStep)) continue;
            this.testSteps.remove(testStep);
        }
    }

    public class StepReplacer {
        List<TestStep> stepsToReplace;

        public StepReplacer(List<TestStep> stepsToReplace) {
            this.stepsToReplace = stepsToReplace;
        }

        public void with(TestStep mergedStep) {
            TestOutcome.this.removeSteps(this.stepsToReplace);
            TestOutcome.this.addStep(mergedStep);
            TestOutcome.this.renumberTestSteps();
        }
    }

    private class SpecificTagFinder {
        private final TestTag tag;

        public SpecificTagFinder(TestTag tag) {
            this.tag = tag;
        }

        public boolean in(Set<TestTag> tags) {
            for (TestTag otherTag : tags) {
                if (otherTag == this.tag || !otherTag.isAsOrMoreSpecificThan(this.tag)) continue;
                return true;
            }
            return false;
        }
    }

    private class StepResetBuilder {
        TestStep step;

        public StepResetBuilder(TestStep step) {
            this.step = step;
        }

        public void causedBy(Class<? extends Throwable> expected) {
            if (this.step.getException().getErrorType().equals(expected.getName())) {
                this.step.clearException();
                this.step.setResult(TestResult.SUCCESS);
            }
            for (TestStep childStep : this.step.getChildren()) {
                TestOutcome.this.resetFailingStepsIn(childStep).causedBy(expected);
            }
        }
    }

    abstract class StepFilter {
        StepFilter() {
        }

        abstract boolean apply(TestStep var1);
    }

    public static class StepCountBuilder {
        private final StepFilter filter;

        public StepCountBuilder(StepFilter filter) {
            this.filter = filter;
        }

        int in(List<TestStep> steps) {
            int count = 0;
            for (TestStep step : steps) {
                if (!this.filter.apply(step)) continue;
                ++count;
            }
            return count;
        }
    }

    private static class ExtractTestResultsConverter
    implements Converter<TestStep, TestResult> {
        private ExtractTestResultsConverter() {
        }

        public TestResult convert(TestStep step) {
            return step.getResult();
        }
    }

    public static class OptionalElements {
        private final TestOutcome testOutcome;

        public OptionalElements(TestOutcome testOutcome) {
            this.testOutcome = testOutcome;
        }

        public boolean testRunTimestamp() {
            return this.testOutcome.testRunTimestamp != null;
        }
    }

    public class TitleBuilder {
        private final boolean qualified;
        private final TestOutcome testOutcome;

        public TitleBuilder(TestOutcome testOutcome, boolean qualified) {
            this.testOutcome = testOutcome;
            this.qualified = qualified;
        }

        public String getTitleWithLinks() {
            return TestOutcome.this.getFormatter().addLinks(this.getTitle());
        }

        public String getTitle() {
            return this.testOutcome.getTitle(this.qualified);
        }
    }

    class StepMergeBuilder {
        private final TestStep previousStep;

        private StepMergeBuilder(TestStep step) {
            this.previousStep = step;
        }

        public TestStep into(TestStep nextStep) {
            TestStep mergedStep = nextStep.addChildStep(this.previousStep);
            if (nextStep.getResult() == TestResult.SKIPPED && TestOutcome.this.wasUnsuccessful(this.previousStep)) {
                nextStep.setResult(TestResult.UNDEFINED);
            }
            mergedStep.setResult(this.merge(nextStep.getResult()).with(this.previousStep.getResult()));
            return mergedStep;
        }

        private StepResultMergeStragegy merge(TestResult nextStepResult) {
            return MergeStepResultStrategy.whenNextStepResultIs(nextStepResult);
        }
    }

    private class GetLastStepBuilder {
        int maxCount;

        public GetLastStepBuilder(int maxCount) {
            this.maxCount = maxCount;
        }

        public List<TestStep> steps() {
            List testStepPartitions = Lists.partition((List)Lists.reverse(TestOutcome.this.getTestSteps()), (int)this.maxCount);
            return Lists.reverse((List)((List)testStepPartitions.get(0)));
        }
    }
}

