/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Optional;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.ReportNamer;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.NameConverter;

public class ReportNameProvider {
    private final Optional<String> context;
    private final ReportNamer reportNamer;
    private final RequirementsService requirementsService;
    private static final Optional<String> NO_CONTEXT = Optional.absent();

    public ReportNameProvider() {
        this(NO_CONTEXT, ReportType.HTML);
    }

    public ReportNameProvider(String context) {
        this((Optional<String>)Optional.fromNullable((Object)context), ReportType.HTML, (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    protected ReportNameProvider(Optional<String> context, ReportType type) {
        this(context, type, (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    protected ReportNameProvider(Optional<String> context, ReportType type, RequirementsService requirementsService) {
        this.context = context;
        this.reportNamer = ReportNamer.forReportType(type);
        this.requirementsService = requirementsService;
    }

    public String getContext() {
        if (this.context.isPresent()) {
            return (String)this.context.get();
        }
        return "";
    }

    public ReportNameProvider forCSVFiles() {
        return new ReportNameProvider(this.context, ReportType.CSV);
    }

    public String forTestResult(String result) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "result_" + result);
    }

    public String forTag(String tag) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "tag_" + tag.toLowerCase());
    }

    public String forTag(TestTag tag) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "tag_" + tag.getType().toLowerCase() + "_" + tag.getName().toLowerCase());
    }

    public String forTagType(String tagType) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "tagtype_" + tagType.toLowerCase());
    }

    public String forRequirementType(String tagType) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "requirement_type_" + tagType.toLowerCase());
    }

    public ReportNameProvider withPrefix(String prefix) {
        return new ReportNameProvider(prefix);
    }

    public ReportNameProvider withPrefix(TestTag tag) {
        if (tag.equals(TestTag.EMPTY_TAG)) {
            return new ReportNameProvider();
        }
        return new ReportNameProvider(tag.getType().toLowerCase() + ":" + tag.getName().toLowerCase());
    }

    private String prefixUsing(Optional<String> context) {
        if (context.isPresent()) {
            return "context_" + NameConverter.underscore((String)context.get()) + "_";
        }
        return "";
    }

    public String forRequirement(Requirement requirement) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "requirement_" + requirement.qualifiedName());
    }

    public String forRequirement(TestTag tag) {
        return this.forRequirement(tag.getName());
    }

    public String forRequirementOrTag(TestTag tag) {
        return this.requirementsService.isRequirementsTag(tag) ? this.forRequirement(tag.getName()) : this.forTag(tag);
    }

    public String forRequirement(String requirementName) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "requirement_" + requirementName);
    }

    public String forRelease(Release release) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "release_" + release.getName());
    }

    public String forRelease(String releaseName) {
        return this.reportNamer.getNormalizedTestNameFor(this.prefixUsing(this.context) + "release_" + releaseName);
    }
}

