/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderFilter;
import net.thucydides.core.statistics.service.TagProviderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathTagProviderService
implements TagProviderService {
    private final Logger logger = LoggerFactory.getLogger(ClasspathTagProviderService.class);
    private List<TagProvider> tagProviders;
    private TagProviderFilter<TagProvider> filter = new TagProviderFilter();

    @Override
    public List<TagProvider> getTagProviders() {
        if (this.tagProviders == null) {
            ArrayList newTagProviders = Lists.newArrayList();
            Iterable<TagProvider> tagProviderServiceLoader = this.loadTagProvidersFromPath();
            for (TagProvider tagProvider : tagProviderServiceLoader) {
                newTagProviders.add(tagProvider);
            }
            this.tagProviders = this.filter.removeOverriddenProviders(newTagProviders);
        }
        return this.tagProviders;
    }

    protected Iterable<TagProvider> loadTagProvidersFromPath() {
        return ServiceLoader.load(TagProvider.class);
    }
}

