/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.serenitybdd.core.IgnoredStepException;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.exceptions.SerenityWebDriverException;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.stacktrace.StackTraceSanitizer;
import net.thucydides.core.steps.AnnotatedStepDescription;
import net.thucydides.core.steps.DefaultValue;
import net.thucydides.core.steps.DryRunMethodRunner;
import net.thucydides.core.steps.ErrorConvertor;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.MethodErrorReporter;
import net.thucydides.core.steps.MethodRunner;
import net.thucydides.core.steps.NormalMethodRunner;
import net.thucydides.core.steps.StepArgumentWriter;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepName;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.junit.internal.AssumptionViolatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepInterceptor
implements MethodInterceptor,
MethodErrorReporter {
    private final Class<?> testStepClass;
    private Throwable error = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepInterceptor.class);
    private final EnvironmentVariables environmentVariables;
    private final List<String> OBJECT_METHODS = Arrays.asList("toString", "equals", "hashcode", "clone", "notify", "notifyAll", "wait", "finalize", "getMetaClass");

    public StepInterceptor(Class<?> testStepClass) {
        this.testStepClass = testStepClass;
        this.environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = this.baseClassMethod(method, obj.getClass()) ? this.runBaseObjectMethod(obj, method, args, proxy) : this.testStepResult(obj, method, args, proxy);
        return result;
    }

    private boolean baseClassMethod(Method method, Class callingClass) {
        boolean isACoreLanguageMethod = this.OBJECT_METHODS.contains(method.getName());
        boolean methodDoesNotComeFromThisClassOrARelatedParentClass = !this.declaredInSameDomain(method, callingClass);
        return isACoreLanguageMethod || methodDoesNotComeFromThisClassOrARelatedParentClass;
    }

    private boolean declaredInSameDomain(Method method, Class callingClass) {
        return this.domainPackageOf(this.getRoot(method)).equals(this.domainPackageOf(callingClass));
    }

    private String domainPackageOf(Class callingClass) {
        Package classPackage = callingClass.getPackage();
        String classPackageName = classPackage != null ? classPackage.getName() : "";
        return this.packageDomainName(classPackageName);
    }

    private String packageDomainName(String methodPackage) {
        ArrayList packages = Lists.newArrayList((Iterable)Splitter.on((String)".").omitEmptyStrings().split((CharSequence)methodPackage));
        if (packages.size() == 0) {
            return "";
        }
        if (packages.size() == 1) {
            return (String)packages.get(0);
        }
        return (String)packages.get(0) + "." + (String)packages.get(1);
    }

    private String domainPackageOf(Method method) {
        Package methodPackage = method.getDeclaringClass().getPackage();
        String methodPackageName = methodPackage != null ? methodPackage.getName() : "";
        return this.packageDomainName(methodPackageName);
    }

    private Method getRoot(Method method) {
        try {
            method.getClass().getDeclaredField("root").setAccessible(true);
            return (Method)method.getClass().getDeclaredField("root").get(method);
        }
        catch (IllegalAccessException e) {
            return method;
        }
        catch (NoSuchFieldException e) {
            return method;
        }
    }

    private Object testStepResult(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (!this.isATestStep(method)) {
            return this.runNormalMethod(obj, method, args, proxy);
        }
        if (this.shouldSkip(method)) {
            return this.skipStepMethod(obj, method, args, proxy);
        }
        this.notifyStepStarted(obj, method, args);
        return this.runTestStep(obj, method, args, proxy);
    }

    private Object skipStepMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Exception {
        if ((this.aPreviousStepHasFailed() || this.testAssumptionViolated()) && !this.shouldExecuteNestedStepsAfterFailures()) {
            this.notifySkippedStepStarted(obj, method, args);
            this.notifySkippedStepFinishedFor(method, args);
            return null;
        }
        this.notifySkippedStepStarted(obj, method, args);
        return this.skipTestStep(obj, method, args, proxy);
    }

    private boolean shouldExecuteNestedStepsAfterFailures() {
        return ThucydidesSystemProperty.DEEP_STEP_EXECUTION_AFTER_FAILURES.booleanFrom(this.environmentVariables, false);
    }

    private Object skipTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Exception {
        Object skippedReturnObject = this.runSkippedMethod(obj, method, args, proxy);
        this.notifyStepSkippedFor(method, args);
        LOGGER.info("SKIPPED STEP: {}", StepName.fromStepAnnotationIn(method).or((Object)method.getName()));
        return this.appropriateReturnObject(skippedReturnObject, obj, method);
    }

    private Object runSkippedMethod(Object obj, Method method, Object[] args, MethodProxy proxy) {
        LOGGER.trace("Running test step " + (String)StepName.fromStepAnnotationIn(method).or((Object)method.getName()));
        StepEventBus.getEventBus().temporarilySuspendWebdriverCalls();
        Object result = this.runIfNestedMethodsShouldBeRun(obj, method, args, proxy);
        StepEventBus.getEventBus().reenableWebdriverCalls();
        return result;
    }

    private Object runIfNestedMethodsShouldBeRun(Object obj, Method method, Object[] args, MethodProxy proxy) {
        Object result = null;
        try {
            if (!TestAnnotations.shouldSkipNested(method)) {
                result = this.invokeMethod(obj, args, proxy);
            }
        }
        catch (Throwable anyException) {
            LOGGER.trace("Ignoring exception thrown during a skipped test", anyException);
        }
        return result;
    }

    Object appropriateReturnObject(Object returnedValue, Object obj, Method method) {
        if (returnedValue != null) {
            return returnedValue;
        }
        return this.appropriateReturnObject(obj, method);
    }

    Object appropriateReturnObject(Object obj, Method method) {
        if (method.getReturnType().isAssignableFrom(obj.getClass())) {
            return obj;
        }
        return null;
    }

    private boolean shouldNotSkipMethod(Method methodOrStep, Class callingClass) {
        return !this.shouldSkipMethod(methodOrStep, callingClass);
    }

    private boolean shouldSkipMethod(Method methodOrStep, Class callingClass) {
        return (this.aPreviousStepHasFailed() || this.testIsPending() || this.isDryRun()) && this.declaredInSameDomain(methodOrStep, callingClass);
    }

    private boolean shouldSkip(Method methodOrStep) {
        return this.aPreviousStepHasFailed() || this.testIsPending() || this.isDryRun() || this.isPending(methodOrStep) || this.isIgnored(methodOrStep);
    }

    private boolean testIsPending() {
        return StepEventBus.getEventBus().currentTestIsSuspended();
    }

    private boolean testAssumptionViolated() {
        return StepEventBus.getEventBus().assumptionViolated();
    }

    private boolean aPreviousStepHasFailed() {
        boolean aPreviousStepHasFailed = false;
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed()) {
            aPreviousStepHasFailed = true;
        }
        return aPreviousStepHasFailed;
    }

    private boolean isDryRun() {
        return StepEventBus.getEventBus().isDryRun();
    }

    private Object runBaseObjectMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return this.invokeMethod(obj, args, proxy);
    }

    private Object runNormalMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = DefaultValue.defaultReturnValueFor(method, obj);
        return this.withNonStepMethodRunner(method, obj.getClass()).invokeMethodAndNotifyFailures(obj, method, args, proxy, result);
    }

    private MethodRunner withNonStepMethodRunner(Method methodOrStep, Class callingClass) {
        return (MethodRunner)((Object)(this.shouldRunInDryRunMode(methodOrStep, callingClass) ? new DryRunMethodRunner() : new NormalMethodRunner(this)));
    }

    private boolean shouldRunInDryRunMode(Method methodOrStep, Class callingClass) {
        return (this.aPreviousStepHasFailed() || this.testIsPending() || this.isDryRun()) && this.declaredInSameDomain(methodOrStep, callingClass);
    }

    @Override
    public void reportMethodError(Throwable generalException, Object obj, Method method, Object[] args) throws Throwable {
        this.error = SerenityWebDriverException.detachedCopyOf(generalException);
        Throwable assertionError = ErrorConvertor.forError(this.error).convertToAssertion();
        this.notifyStepStarted(obj, method, args);
        this.notifyOfStepFailure(obj, method, args, assertionError);
    }

    private Object invokeMethodAndNotifyFailures(Object obj, Method method, Object[] args, MethodProxy proxy, Object result) throws Throwable {
        try {
            result = this.invokeMethod(obj, args, proxy);
        }
        catch (Throwable generalException) {
            this.error = SerenityWebDriverException.detachedCopyOf(generalException);
            Throwable assertionError = ErrorConvertor.forError(this.error).convertToAssertion();
            this.notifyStepStarted(obj, method, args);
            this.notifyOfStepFailure(obj, method, args, assertionError);
        }
        return result;
    }

    private boolean isAnnotatedWithAValidStepAnnotation(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!this.isAThucydidesStep(annotation) && !AnnotatedStepDescription.isACompatibleStep(annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean isAThucydidesStep(Annotation annotation) {
        return annotation instanceof Step || annotation instanceof StepGroup;
    }

    private boolean isATestStep(Method method) {
        return this.isAnnotatedWithAValidStepAnnotation(method);
    }

    private boolean isIgnored(Method method) {
        return TestAnnotations.isIgnored(method);
    }

    private Object runTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String callingClass = this.testContext();
        LOGGER.info("STARTING STEP: {} - {}", (Object)callingClass, StepName.fromStepAnnotationIn(method).or((Object)method.getName()));
        Object result = null;
        try {
            result = this.executeTestStepMethod(obj, method, args, proxy, result);
            LOGGER.info("STEP DONE: {}", StepName.fromStepAnnotationIn(method).or((Object)method.getName()));
        }
        catch (AssertionError failedAssertion) {
            this.error = failedAssertion;
            this.logStepFailure(obj, method, args, (Throwable)((Object)failedAssertion));
            result = this.appropriateReturnObject(obj, method);
        }
        catch (AssumptionViolatedException assumptionFailed) {
            result = this.appropriateReturnObject(obj, method);
        }
        catch (Throwable testErrorException) {
            this.error = SerenityWebDriverException.detachedCopyOf(testErrorException);
            this.logStepFailure(obj, method, args, ErrorConvertor.forError(this.error).convertToAssertion());
            result = this.appropriateReturnObject(obj, method);
        }
        return result;
    }

    private void logStepFailure(Object object, Method method, Object[] args, Throwable assertionError) throws Throwable {
        this.notifyOfStepFailure(object, method, args, assertionError);
        LOGGER.info("STEP FAILED: {} - {}", StepName.fromStepAnnotationIn(method).or((Object)method.getName()), (Object)assertionError.getMessage());
    }

    private Object executeTestStepMethod(Object obj, Method method, Object[] args, MethodProxy proxy, Object result) throws Throwable {
        try {
            result = this.invokeMethod(obj, args, proxy);
            this.notifyStepFinishedFor(method, args);
        }
        catch (PendingStepException pendingStep) {
            this.notifyStepPending(pendingStep.getMessage());
        }
        catch (IgnoredStepException ignoredStep) {
            this.notifyStepIgnored(ignoredStep.getMessage());
        }
        catch (AssumptionViolatedException assumptionViolated) {
            this.notifyAssumptionViolated(assumptionViolated.getMessage());
        }
        Preconditions.checkArgument((boolean)true);
        return result;
    }

    private Object invokeMethod(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private boolean isPending(Method method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private void notifyStepFinishedFor(Method method, Object[] args) {
        StepEventBus.getEventBus().stepFinished();
    }

    private void notifySkippedStepFinishedFor(Method method, Object[] args) {
        StepEventBus.getEventBus().stepIgnored();
    }

    private void notifyStepPending(String message) {
        StepEventBus.getEventBus().stepPending(message);
    }

    private void notifyAssumptionViolated(String message) {
        StepEventBus.getEventBus().assumptionViolated(message);
    }

    private void notifyStepIgnored(String message) {
        StepEventBus.getEventBus().stepIgnored();
    }

    private String getTestNameFrom(Method method, Object[] args) {
        return this.getTestNameFrom(method, args, true);
    }

    private String getTestNameFrom(Method method, Object[] args, boolean addMarkup) {
        if (args == null || args.length == 0) {
            return method.getName();
        }
        return this.testNameWithArguments(method, args, addMarkup);
    }

    private String testNameWithArguments(Method method, Object[] args, boolean addMarkup) {
        StringBuilder testName = new StringBuilder(method.getName());
        testName.append(": ");
        if (addMarkup) {
            testName.append("<span class='step-parameter'>");
        }
        boolean isFirst = true;
        for (Object arg : args) {
            if (!isFirst) {
                testName.append(", ");
            }
            testName.append(StepArgumentWriter.readableFormOf(arg));
            isFirst = false;
        }
        if (addMarkup) {
            testName.append("</span>");
        }
        return testName.toString();
    }

    private void notifyStepSkippedFor(Method method, Object[] args) throws Exception {
        if (this.isPending(method)) {
            StepEventBus.getEventBus().stepPending();
        } else {
            StepEventBus.getEventBus().stepIgnored();
        }
    }

    private void notifyOfStepFailure(Object object, Method method, Object[] args, Throwable cause) throws Throwable {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args)).withDisplayedFields(this.fieldValuesIn(object));
        StepFailure failure = new StepFailure(description, cause);
        StepEventBus.getEventBus().stepFailed(failure);
        if (this.shouldThrowExceptionImmediately()) {
            throw cause;
        }
    }

    private boolean shouldThrowExceptionImmediately() {
        return Serenity.shouldThrowErrorsImmediately();
    }

    private void notifyStepStarted(Object object, Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args)).withDisplayedFields(this.fieldValuesIn(object));
        StepEventBus.getEventBus().stepStarted(description);
    }

    private Map<String, Object> fieldValuesIn(Object object) {
        return Fields.of(object).asMap();
    }

    private void notifySkippedStepStarted(Object object, Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args)).withDisplayedFields(this.fieldValuesIn(object));
        StepEventBus.getEventBus().skippedStepStarted(description);
    }

    public String testContext() {
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace(new RuntimeException().getStackTrace());
        StackTraceElement[] stackTrace = stackTraceSanitizer.getSanitizedStackTrace();
        return stackTrace.length > 0 ? this.getTestContextFrom(stackTraceSanitizer.getSanitizedStackTrace()[0]) : "";
    }

    private String getTestContextFrom(StackTraceElement stackTraceElement) {
        return this.shortenedClassName(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
    }

    private String shortenedClassName(String className) {
        String[] classNameElements = StringUtils.split((String)className, (String)".");
        return classNameElements[classNameElements.length - 1];
    }
}

