/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import com.google.inject.Inject;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.LocalPreferences;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileLocalPreferences
implements LocalPreferences {
    public static final String TYPESAFE_CONFIG_FILE = "serenity.conf";
    private File workingDirectory;
    private File homeDirectory;
    private final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileLocalPreferences.class);

    @Inject
    public PropertiesFileLocalPreferences(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.homeDirectory = new File(System.getProperty("user.home"));
        this.workingDirectory = new File(System.getProperty("user.dir"));
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(File homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    @Override
    public void loadPreferences() throws IOException {
        this.updatePreferencesFrom(this.typesafeConfigPreferences(), this.preferencesIn(this.preferencesFileInHomeDirectory()), this.preferencesIn(this.legacyPreferencesFileInHomeDirectory()), this.preferencesIn(this.preferencesFileInWorkingDirectory()), this.preferencesIn(this.legacyPreferencesFileInWorkingDirectory()), this.preferencesIn(this.preferencesFileWithAbsolutePath()), this.preferencesIn(this.legacyPreferencesFileWithAbsolutePath()), this.preferencesInClasspath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties preferencesInClasspath() throws IOException {
        try (InputStream propertiesOnClasspath = null;){
            propertiesOnClasspath = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.defaultPropertiesFileName());
            if (propertiesOnClasspath == null) {
                propertiesOnClasspath = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.legacyPropertiesFileName());
            }
            if (propertiesOnClasspath != null) {
                Properties localPreferences = new Properties();
                localPreferences.load(propertiesOnClasspath);
                Properties properties = localPreferences;
                return properties;
            }
        }
        return new Properties();
    }

    private Properties typesafeConfigPreferences() {
        Set preferences = ConfigFactory.load((String)TYPESAFE_CONFIG_FILE).entrySet();
        Properties properties = new Properties();
        for (Map.Entry preference : preferences) {
            properties.put(preference.getKey(), StringUtils.strip((String)((ConfigValue)preference.getValue()).render(), (String)"\""));
        }
        return properties;
    }

    private void updatePreferencesFrom(Properties ... propertySets) throws IOException {
        for (Properties localPreferences : propertySets) {
            this.setUndefinedSystemPropertiesFrom(localPreferences);
        }
    }

    private Properties preferencesIn(File preferencesFile) throws IOException {
        Properties preferenceProperties = new Properties();
        if (preferencesFile.exists()) {
            LOGGER.info("LOADING LOCAL PROPERTIES FROM {} ", (Object)preferencesFile.getAbsolutePath());
            preferenceProperties.load(new FileInputStream(preferencesFile));
        }
        return preferenceProperties;
    }

    private void setUndefinedSystemPropertiesFrom(Properties localPreferences) {
        Enumeration<?> propertyNames = localPreferences.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            String localPropertyValue = localPreferences.getProperty(propertyName);
            String currentPropertyValue = this.environmentVariables.getProperty(propertyName);
            if (currentPropertyValue != null || localPropertyValue == null) continue;
            LOGGER.info(propertyName + "=" + localPropertyValue);
            this.environmentVariables.setProperty(propertyName, localPropertyValue);
        }
    }

    private File preferencesFileInHomeDirectory() {
        return new File(this.homeDirectory, this.defaultPropertiesFileName());
    }

    private File legacyPreferencesFileInHomeDirectory() {
        return new File(this.homeDirectory, this.legacyPropertiesFileName());
    }

    private File preferencesFileInWorkingDirectory() {
        return new File(this.workingDirectory, this.defaultPropertiesFileName());
    }

    private File legacyPreferencesFileInWorkingDirectory() {
        return new File(this.workingDirectory, this.legacyPropertiesFileName());
    }

    private File preferencesFileWithAbsolutePath() {
        return new File(this.defaultPropertiesFileName());
    }

    private File legacyPreferencesFileWithAbsolutePath() {
        return new File(this.legacyPropertiesFileName());
    }

    private String defaultPropertiesFileName() {
        return ThucydidesSystemProperty.PROPERTIES.from(this.environmentVariables, "serenity.properties");
    }

    private String legacyPropertiesFileName() {
        return ThucydidesSystemProperty.PROPERTIES.from(this.environmentVariables, "thucydides.properties");
    }
}

