/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.selectors;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import net.serenitybdd.core.selectors.SelectorConverter;
import net.serenitybdd.core.selectors.SelectorType;
import org.openqa.selenium.By;

public class Selectors {
    private static Map<SelectorType, SelectorConverter> SELECTORS = Maps.newHashMap();

    public static boolean isXPath(String xpathExpression) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            xpath.compile(xpathExpression);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static By xpathOrCssSelector(String xpathOrCssSelector) {
        if (Selectors.hasPrefix(xpathOrCssSelector)) {
            return SELECTORS.get((Object)Selectors.prefixOf(xpathOrCssSelector)).apply(xpathOrCssSelector);
        }
        if (Selectors.isXPath(xpathOrCssSelector)) {
            return By.xpath((String)xpathOrCssSelector);
        }
        return By.cssSelector((String)xpathOrCssSelector);
    }

    private static boolean hasPrefix(String xpathOrCssSelector) {
        return Selectors.prefixOf(xpathOrCssSelector) != SelectorType.noSelectorType;
    }

    private static SelectorType prefixOf(String xpathOrCssSelector) {
        for (SelectorType type : SelectorType.values()) {
            if (!xpathOrCssSelector.startsWith(type.name() + ":")) continue;
            return type;
        }
        return SelectorType.noSelectorType;
    }

    private static String withoutPrefix(String xpathOrCssSelector) {
        int selectorStarts = xpathOrCssSelector.indexOf(":") + 1;
        return xpathOrCssSelector.substring(selectorStarts);
    }

    static {
        SELECTORS.put(SelectorType.css, new SelectorConverter(){

            @Override
            public By apply(String path) {
                return By.cssSelector((String)Selectors.withoutPrefix(path));
            }
        });
        SELECTORS.put(SelectorType.xpath, new SelectorConverter(){

            @Override
            public By apply(String path) {
                return By.xpath((String)Selectors.withoutPrefix(path));
            }
        });
        SELECTORS.put(SelectorType.linkText, new SelectorConverter(){

            @Override
            public By apply(String path) {
                return By.linkText((String)Selectors.withoutPrefix(path));
            }
        });
        SELECTORS.put(SelectorType.className, new SelectorConverter(){

            @Override
            public By apply(String path) {
                return By.className((String)Selectors.withoutPrefix(path));
            }
        });
        SELECTORS.put(SelectorType.id, new SelectorConverter(){

            @Override
            public By apply(String path) {
                return By.id((String)Selectors.withoutPrefix(path));
            }
        });
        SELECTORS.put(SelectorType.partialLinkText, new SelectorConverter(){

            @Override
            public By apply(String path) {
                return By.partialLinkText((String)Selectors.withoutPrefix(path));
            }
        });
        SELECTORS.put(SelectorType.name, new SelectorConverter(){

            @Override
            public By apply(String path) {
                return By.name((String)Selectors.withoutPrefix(path));
            }
        });
        SELECTORS.put(SelectorType.tagName, new SelectorConverter(){

            @Override
            public By apply(String path) {
                return By.tagName((String)Selectors.withoutPrefix(path));
            }
        });
    }
}

