/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.TestOutcomeLoader;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.TestOutcomesCompromised;
import net.thucydides.core.reports.TestOutcomesError;
import net.thucydides.core.reports.TestOutcomesFailures;

public class ResultChecker {
    private final File outputDirectory;

    public ResultChecker(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void checkTestResults() {
        Optional<TestOutcomes> outcomes = this.loadOutcomes();
        if (outcomes.isPresent()) {
            this.checkTestResultsIn((TestOutcomes)outcomes.get());
        } else {
            this.handleMissingTestResults();
        }
    }

    private void checkTestResultsIn(TestOutcomes testOutcomes) {
        switch (testOutcomes.getResult()) {
            case ERROR: {
                throw new TestOutcomesError(this.testOutcomeSummary(testOutcomes));
            }
            case FAILURE: {
                throw new TestOutcomesFailures(this.testOutcomeSummary(testOutcomes));
            }
            case COMPROMISED: {
                throw new TestOutcomesCompromised(this.testOutcomeSummary(testOutcomes));
            }
        }
    }

    private String testOutcomeSummary(TestOutcomes testOutcomes) {
        int errors = testOutcomes.count(TestType.ANY).withResult(TestResult.ERROR);
        int failures = testOutcomes.count(TestType.ANY).withResult(TestResult.FAILURE);
        int compromised = testOutcomes.count(TestType.ANY).withResult(TestResult.COMPROMISED);
        String errorText = errors > 0 ? "ERROR COUNT: " + errors : "";
        String failureText = failures > 0 ? "FAILURE COUNT: " + failures : "";
        String compromisedText = compromised > 0 ? "COMPROMISED COUNT: " + failures : "";
        return "THUCYDIDES TEST FAILURES: " + errorText + " " + failureText + " " + compromisedText;
    }

    private void handleMissingTestResults() {
    }

    private Optional<TestOutcomes> loadOutcomes() {
        TestOutcomes outcomes = null;
        try {
            outcomes = TestOutcomeLoader.loadTestOutcomes().inFormat(OutcomeFormat.JSON).from(this.outputDirectory);
            if (outcomes.getTotal() == 0) {
                outcomes = TestOutcomeLoader.loadTestOutcomes().inFormat(OutcomeFormat.XML).from(this.outputDirectory);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.of(outcomes);
    }
}

