/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import net.thucydides.core.annotations.TestCaseAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SerenityWebdriverManager;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;

public class ThucydidesWebDriverSupport {
    private static final ThreadLocal<WebdriverManager> webdriverManagerThreadLocal = new ThreadLocal();
    private static final ThreadLocal<Pages> pagesThreadLocal = new ThreadLocal();
    private static final ThreadLocal<StepFactory> stepFactoryThreadLocal = new ThreadLocal();

    public static void initialize() {
        ThucydidesWebDriverSupport.initialize(null);
    }

    public static void initialize(String requestedDriver) {
        ThucydidesWebDriverSupport.initialize((WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class), requestedDriver);
    }

    public static void initialize(WebdriverManager webdriverManager, String requestedDriver) {
        ThucydidesWebDriverSupport.setupWebdriverManager(webdriverManager, requestedDriver);
        ThucydidesWebDriverSupport.initPagesObjectUsing(ThucydidesWebDriverSupport.getDriver());
        ThucydidesWebDriverSupport.initStepFactoryUsing(ThucydidesWebDriverSupport.getPages());
    }

    public static void reset() {
        webdriverManagerThreadLocal.remove();
        pagesThreadLocal.remove();
        stepFactoryThreadLocal.remove();
    }

    public static boolean isInitialised() {
        return webdriverManagerThreadLocal.get() != null;
    }

    private static boolean webdriversInitialized() {
        return webdriverManagerThreadLocal.get() != null;
    }

    private static void lazyInitalize() {
        if (!ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.initialize();
        }
    }

    public static void initializeFieldsIn(Object testCase) {
        ThucydidesWebDriverSupport.injectDriverInto(testCase);
        ThucydidesWebDriverSupport.injectAnnotatedPagesObjectInto(testCase);
    }

    public static StepFactory getStepFactory() {
        ThucydidesWebDriverSupport.lazyInitalize();
        return stepFactoryThreadLocal.get();
    }

    public static void useDriver(WebDriver driver) {
        ThucydidesWebDriverSupport.getWebdriverManager().registerDriver(driver);
    }

    public static WebDriver getDriver() {
        return ThucydidesWebDriverSupport.getWebdriverManager().getWebdriver();
    }

    public static void closeCurrentDrivers() {
        if (ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.getWebdriverManager().closeAllCurrentDrivers();
        }
    }

    public static void closeAllDrivers() {
        if (ThucydidesWebDriverSupport.webdriversInitialized()) {
            ThucydidesWebDriverSupport.getWebdriverManager().closeAllDrivers();
        }
    }

    private static void setupWebdriverManager(WebdriverManager webdriverManager, String requestedDriver) {
        webdriverManager.overrideDefaultDriverType(requestedDriver);
        webdriverManagerThreadLocal.set(webdriverManager);
    }

    private static void initStepFactoryUsing(Pages pagesObject) {
        stepFactoryThreadLocal.set(new StepFactory(pagesObject));
    }

    public static WebdriverManager getWebdriverManager(WebDriverFactory webDriverFactory, Configuration configuration) {
        ThucydidesWebDriverSupport.initialize(new SerenityWebdriverManager(webDriverFactory, configuration), "");
        return webdriverManagerThreadLocal.get();
    }

    public static WebdriverManager getWebdriverManager() {
        ThucydidesWebDriverSupport.lazyInitalize();
        return webdriverManagerThreadLocal.get();
    }

    private static void initPagesObjectUsing(WebDriver driver) {
        pagesThreadLocal.set(new Pages(driver));
    }

    public static Pages getPages() {
        ThucydidesWebDriverSupport.lazyInitalize();
        return pagesThreadLocal.get();
    }

    protected static void injectDriverInto(Object testCase) {
        TestCaseAnnotations.forTestCase(testCase).injectDrivers(ThucydidesWebDriverSupport.getWebdriverManager());
    }

    protected static void injectAnnotatedPagesObjectInto(Object testCase) {
        StepAnnotations.injectOptionalAnnotatedPagesObjectInto(testCase, ThucydidesWebDriverSupport.getPages());
    }

    public static <T extends WebDriver> T getProxiedDriver() {
        return (T)((WebDriverFacade)ThucydidesWebDriverSupport.getDriver()).getProxiedDriver();
    }

    public static Class<? extends WebDriver> getDriverClass() {
        return ((WebDriverFacade)ThucydidesWebDriverSupport.getDriver()).getDriverClass();
    }

    public static SessionId getSessionId() {
        return ThucydidesWebDriverSupport.getWebdriverManager().getSessionId();
    }

    public static String getCurrentDriverName() {
        if (ThucydidesWebDriverSupport.getWebdriverManager() == null) {
            return "";
        }
        return ThucydidesWebDriverSupport.getWebdriverManager().getCurrentDriverType();
    }

    public static String getDriversUsed() {
        if (ThucydidesWebDriverSupport.getWebdriverManager() == null) {
            return "";
        }
        return ThucydidesWebDriverSupport.getWebdriverManager().getActiveDriverTypes().get(0);
    }

    public static boolean isDriverInstantiated() {
        return ThucydidesWebDriverSupport.getWebdriverManager().isDriverInstantiated();
    }
}

