/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverEventListener;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class WebdriverProxyFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static ThreadLocal<WebdriverProxyFactory> factory = new ThreadLocal();
    private static List<ThucydidesWebDriverEventListener> eventListeners = Collections.synchronizedList(new ArrayList());
    private WebDriverFactory webDriverFactory = new WebDriverFactory();
    private WebDriverFacade mockDriver;
    private final Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);

    private WebdriverProxyFactory() {
    }

    public static WebdriverProxyFactory getFactory() {
        if (factory.get() == null) {
            factory.set(new WebdriverProxyFactory());
        }
        return factory.get();
    }

    public static List<ThucydidesWebDriverEventListener> getEventListeners() {
        return ImmutableList.copyOf(eventListeners);
    }

    public WebDriverFacade proxyFor(Class<? extends WebDriver> driverClass) {
        return this.proxyFor(driverClass, new WebDriverFactory(), (Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public WebDriverFacade proxyFor(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory, Configuration configuration) {
        if (this.mockDriver != null) {
            return this.mockDriver;
        }
        return new WebDriverFacade(driverClass, webDriverFactory, configuration.getEnvironmentVariables());
    }

    public WebDriverFacade proxyFor(WebDriver driver) {
        return new WebDriverFacade(driver, this.webDriverFactory, this.configuration.getEnvironmentVariables());
    }

    public void registerListener(ThucydidesWebDriverEventListener eventListener) {
        eventListeners.add(eventListener);
    }

    public void notifyListenersOfWebdriverCreationIn(WebDriverFacade webDriverFacade) {
        for (ThucydidesWebDriverEventListener listener : WebdriverProxyFactory.getEventListeners()) {
            listener.driverCreatedIn(webDriverFacade);
        }
    }

    public WebDriver proxyDriver() {
        Class<? extends WebDriver> driverClass = this.webDriverFactory.getClassFor(this.configuration.getDriverType());
        return this.proxyFor(driverClass, this.webDriverFactory, (Configuration)Injectors.getInjector().getInstance(Configuration.class));
    }

    public static void resetDriver(WebDriver driver) {
        if (driver instanceof WebDriverFacade) {
            ((WebDriverFacade)driver).reset();
        }
    }

    public void useMockDriver(WebDriverFacade mockDriver) {
        this.mockDriver = mockDriver;
    }

    public void clearMockDriver() {
        this.mockDriver = null;
    }

    public static void clearBrowserSession(WebDriver driver) {
        if (((WebDriverFacade)driver).isInstantiated()) {
            driver.manage().deleteAllCookies();
            ((JavascriptExecutor)driver).executeScript(String.format("window.localStorage.clear();", new Object[0]), new Object[0]);
        }
    }
}

