/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations.locators;

import java.lang.reflect.Field;
import java.util.HashSet;
import net.serenitybdd.core.annotations.findby.How;
import net.thucydides.core.annotations.findby.FindBy;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.Annotations;

public class SmartAnnotations
extends Annotations {
    private Field field;

    public SmartAnnotations(Field field) {
        super(field);
        this.field = field;
    }

    protected void assertValidAnnotations() {
        FindBys findBys = this.field.getAnnotation(FindBys.class);
        FindBy myFindBy = this.field.getAnnotation(FindBy.class);
        if (findBys != null && myFindBy != null) {
            throw new IllegalArgumentException("If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
    }

    public By buildBy() {
        this.assertValidAnnotations();
        By ans = null;
        org.openqa.selenium.support.FindBy findBy = this.field.getAnnotation(org.openqa.selenium.support.FindBy.class);
        if (ans == null && findBy != null) {
            ans = super.buildByFromFindBy(findBy);
        }
        FindBy myFindBy = this.field.getAnnotation(FindBy.class);
        if (ans == null && myFindBy != null) {
            ans = this.buildByFromFindBy(myFindBy);
        }
        FindBys findBys = this.field.getAnnotation(FindBys.class);
        if (ans == null && findBys != null) {
            ans = this.buildByFromFindBys(findBys);
        }
        if (ans == null) {
            ans = this.buildByFromDefault();
        }
        if (ans == null) {
            throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
        }
        return ans;
    }

    protected By buildByFromFindBy(FindBy myFindBy) {
        this.assertValidFindBy(myFindBy);
        By ans = this.buildByFromShortFindBy(myFindBy);
        if (ans == null) {
            ans = this.buildByFromLongFindBy(myFindBy);
        }
        return ans;
    }

    protected By buildByFromLongFindBy(FindBy myFindBy) {
        How how = myFindBy.how();
        String using = myFindBy.using();
        switch (how) {
            case CLASS_NAME: {
                return By.className((String)using);
            }
            case CSS: {
                return By.cssSelector((String)using);
            }
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)using);
            }
            case TAG_NAME: {
                return By.tagName((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
            case JQUERY: {
                return net.thucydides.core.annotations.findby.By.jquery(using);
            }
            case SCLOCATOR: {
                return net.thucydides.core.annotations.findby.By.sclocator(using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
    }

    protected By buildByFromShortFindBy(FindBy myFindBy) {
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.className())) {
            return By.className((String)myFindBy.className());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.css())) {
            return By.cssSelector((String)myFindBy.css());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.id())) {
            return By.id((String)myFindBy.id());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.linkText())) {
            return By.linkText((String)myFindBy.linkText());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.name())) {
            return By.name((String)myFindBy.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.ngModel())) {
            return By.cssSelector((String)("*[ng-model='" + myFindBy.ngModel() + "']"));
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.partialLinkText())) {
            return By.partialLinkText((String)myFindBy.partialLinkText());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.tagName())) {
            return By.tagName((String)myFindBy.tagName());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.xpath())) {
            return By.xpath((String)myFindBy.xpath());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.sclocator())) {
            return net.thucydides.core.annotations.findby.By.sclocator(myFindBy.sclocator());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.jquery())) {
            return net.thucydides.core.annotations.findby.By.jquery(myFindBy.jquery());
        }
        return null;
    }

    private void assertValidFindBy(FindBy findBy) {
        if (findBy.how() != null && findBy.using() == null) {
            throw new IllegalArgumentException("If you set the 'how' property, you must also set 'using'");
        }
        HashSet<String> finders = new HashSet<String>();
        if (!"".equals(findBy.using())) {
            finders.add("how: " + findBy.using());
        }
        if (!"".equals(findBy.className())) {
            finders.add("class name:" + findBy.className());
        }
        if (!"".equals(findBy.css())) {
            finders.add("css:" + findBy.css());
        }
        if (!"".equals(findBy.id())) {
            finders.add("id: " + findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            finders.add("link text: " + findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            finders.add("name: " + findBy.name());
        }
        if (!"".equals(findBy.ngModel())) {
            finders.add("ngModel: " + findBy.ngModel());
        }
        if (!"".equals(findBy.partialLinkText())) {
            finders.add("partial link text: " + findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            finders.add("tag name: " + findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            finders.add("xpath: " + findBy.xpath());
        }
        if (!"".equals(findBy.sclocator())) {
            finders.add("scLocator: " + findBy.sclocator());
        }
        if (!"".equals(findBy.jquery())) {
            finders.add("jquery: " + findBy.jquery());
        }
        if (finders.size() > 1) {
            throw new IllegalArgumentException(String.format("You must specify at most one location strategy. Number found: %d (%s)", finders.size(), ((Object)finders).toString()));
        }
    }
}

