/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TestResult {
    COMPROMISED(5, true),
    ERROR(4, true),
    FAILURE(3, true),
    SKIPPED(2, false),
    IGNORED(2, false),
    PENDING(2, false),
    SUCCESS(1, true),
    UNDEFINED(0, false);

    private final int priority;
    private final boolean executedResultsCount;
    private static Logger logger;

    private TestResult(int priority, boolean executedResultsCount) {
        this.priority = priority;
        this.executedResultsCount = executedResultsCount;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean overrides(TestResult result) {
        return this.priority > result.priority;
    }

    public boolean isMoreSevereThan(TestResult otherResult) {
        return this.ordinal() > otherResult.ordinal();
    }

    public static boolean existsWithName(String expectedResult) {
        try {
            TestResult.valueOf(expectedResult);
        }
        catch (IllegalArgumentException noMatchingEnumValue) {
            logger.warn("No matching test result value found for {}", (Object)expectedResult);
            return false;
        }
        return true;
    }

    public boolean executedResultsCount() {
        return this.executedResultsCount;
    }

    static {
        logger = LoggerFactory.getLogger((String)"net.thucydides.core.model.TestResult");
    }
}

