/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.failures;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import cucumber.api.PendingException;
import java.util.Collection;
import java.util.List;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.exceptions.CausesAssertionFailure;
import net.serenitybdd.core.exceptions.CausesCompromisedTestFailure;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.failures.FailureAnalysisConfiguration;
import net.thucydides.core.model.failures.RootCause;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.util.EnvironmentVariables;

public class FailureAnalysis {
    private final FailureAnalysisConfiguration configured;
    private static final List<Class<?>> DEFAULT_FAILURE_TYPES = Lists.newArrayList();
    private static final List<Class<?>> DEFAULT_COMPROMISED_TYPES;
    private static final List<Class<?>> DEFAULT_PENDING_TYPES;
    private static final List<Class<?>> DEFAULT_ERROR;

    public FailureAnalysis() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public FailureAnalysis(EnvironmentVariables environmentVariables) {
        this.configured = new FailureAnalysisConfiguration(environmentVariables);
    }

    public TestResult resultFor(Class testFailureCause) {
        if (this.reportAsPending(testFailureCause)) {
            return TestResult.PENDING;
        }
        if (this.reportAsCompromised(testFailureCause)) {
            return TestResult.COMPROMISED;
        }
        if (this.reportAsFailure(testFailureCause)) {
            return TestResult.FAILURE;
        }
        return TestResult.ERROR;
    }

    public boolean reportAsFailure(Class<?> testFailureCause) {
        if (testFailureCause == null) {
            return false;
        }
        for (Class<?> validFailureType : this.configured.failureTypes()) {
            if (!this.isA(validFailureType, testFailureCause)) continue;
            return true;
        }
        return false;
    }

    public boolean reportAsCompromised(Class<?> testFailureCause) {
        if (testFailureCause == null) {
            return false;
        }
        for (Class<?> validCompromisedType : this.configured.compromisedTypes()) {
            if (!this.isA(validCompromisedType, testFailureCause)) continue;
            return true;
        }
        return false;
    }

    public boolean reportAsPending(Class<?> testFailureCause) {
        if (testFailureCause == null) {
            return false;
        }
        for (Class<?> validPendingType : this.configured.pendingTypes()) {
            if (!this.isA(validPendingType, testFailureCause)) continue;
            return true;
        }
        return false;
    }

    public boolean reportAsError(Class<?> testFailureCause) {
        if (testFailureCause == null) {
            return false;
        }
        for (Class<?> validErrorType : this.configured.errorTypes()) {
            if (!this.isA(validErrorType, testFailureCause)) continue;
            return true;
        }
        return false;
    }

    private boolean isA(Class<?> expectedClass, Class testFailureCause) {
        return expectedClass.isAssignableFrom(testFailureCause);
    }

    public TestResult resultFor(Throwable testFailureCause) {
        if (this.isPendingException(testFailureCause)) {
            return TestResult.PENDING;
        }
        if (this.isFailure(testFailureCause)) {
            return TestResult.FAILURE;
        }
        if (this.failingStepException(testFailureCause)) {
            return TestResult.FAILURE;
        }
        if (this.isCompromised(testFailureCause)) {
            return TestResult.COMPROMISED;
        }
        return TestResult.ERROR;
    }

    public TestResult resultFor(StepFailure stepFailure) {
        if (stepFailure.getExceptionClass() == null) {
            return TestResult.FAILURE;
        }
        return this.resultFor(stepFailure.getExceptionClass());
    }

    private boolean failingStepException(Throwable testFailureCause) {
        if (testFailureCause == null) {
            return false;
        }
        return StepFailureException.class.isAssignableFrom(testFailureCause.getClass()) && testFailureCause.getCause() != null && this.isFailure(testFailureCause.getCause());
    }

    private boolean isFailure(Throwable testFailureCause) {
        return this.reportAsFailure(RootCause.ofException(testFailureCause));
    }

    private boolean isCompromised(Throwable testFailureCause) {
        return this.reportAsCompromised(RootCause.ofException(testFailureCause));
    }

    private boolean isPendingException(Throwable testFailureCause) {
        return this.reportAsPending(RootCause.ofException(testFailureCause));
    }

    static {
        DEFAULT_FAILURE_TYPES.addAll((Collection<Class<?>>)ImmutableList.of(AssertionError.class, CausesAssertionFailure.class));
        DEFAULT_COMPROMISED_TYPES = Lists.newArrayList();
        DEFAULT_COMPROMISED_TYPES.addAll((Collection<Class<?>>)ImmutableList.of(CausesCompromisedTestFailure.class));
        DEFAULT_PENDING_TYPES = Lists.newArrayList();
        DEFAULT_PENDING_TYPES.addAll((Collection<Class<?>>)ImmutableList.of(PendingStepException.class, PendingException.class));
        DEFAULT_ERROR = Lists.newArrayList();
        DEFAULT_ERROR.addAll((Collection<Class<?>>)ImmutableList.of(Error.class));
    }
}

