/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.beust.jcommander.internal.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.thucydides.core.reports.FileCopier;
import net.thucydides.core.reports.NumberOfThreads;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFiles {
    private final File sourceDirectory;
    private static final Logger LOGGER = LoggerFactory.getLogger(CopyFiles.class);

    public CopyFiles(File sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
    }

    public static CopyFiles from(File sourceDirectory) {
        return new CopyFiles(sourceDirectory);
    }

    public void to(File outputDirectory) {
        if (this.sourceDirectoryIsTheSameAs(outputDirectory)) {
            return;
        }
        Path sourcePath = Paths.get(this.sourceDirectory.toURI());
        Path targetDirectory = Paths.get(outputDirectory.toURI());
        List<Path> filesToCopy = this.filesToCopyBetween(sourcePath, targetDirectory);
        int numberOfThreads = NumberOfThreads.forIOOperations();
        List partitions = Lists.newArrayList();
        for (Path fileToCopy : filesToCopy) {
            partitions.add(new FileCopier(fileToCopy, targetDirectory));
        }
        ExecutorService executorPool = Executors.newFixedThreadPool(numberOfThreads);
        try {
            List copiedFiles = executorPool.invokeAll(partitions);
            for (Future copiedFile : copiedFiles) {
                copiedFile.get();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error during copying files to the target directory", (Throwable)e);
        }
        executorPool.shutdown();
    }

    private boolean sourceDirectoryIsTheSameAs(File outputDirectory) {
        return outputDirectory == null || outputDirectory.equals(this.sourceDirectory);
    }

    private List<Path> filesToCopyBetween(Path sourcePath, Path targetPath) {
        List filesToCopy = Lists.newArrayList();
        try (DirectoryStream<Path> directoryContents = Files.newDirectoryStream(sourcePath);){
            for (Path sourceFile : directoryContents) {
                Path destinationFile = targetPath.resolve(sourceFile.getFileName());
                if (!Files.notExists(destinationFile, new LinkOption[0])) continue;
                filesToCopy.add(sourceFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error during copying files to the target directory", (Throwable)e);
        }
        return filesToCopy;
    }
}

