/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import net.thucydides.core.reports.json.gson.CollectionAdapter;
import net.thucydides.core.reports.json.gson.OptionalTypeAdapter;
import net.thucydides.core.requirements.RequirementsStore;
import net.thucydides.core.requirements.model.Requirement;

public class FileSystemRequirementsStore
implements RequirementsStore {
    private final File outputDirectory;
    private final String storeName;
    Gson gson;

    public FileSystemRequirementsStore(File outputDirectory, String storeName) {
        this.outputDirectory = outputDirectory;
        this.storeName = storeName;
        this.gson = new GsonBuilder().registerTypeAdapterFactory(OptionalTypeAdapter.FACTORY).registerTypeHierarchyAdapter(Collection.class, (Object)new CollectionAdapter()).create();
    }

    @Override
    public Optional<List<Requirement>> read() throws IOException {
        List requirements;
        File jsonFile = this.jsonRequirementsFile();
        if (!jsonFile.exists()) {
            return Optional.absent();
        }
        Type requirementsListType = new TypeToken<List<Requirement>>(){}.getType();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);){
            requirements = (List)this.gson.fromJson((Reader)reader, requirementsListType);
            if (requirements == null) {
                requirements = Lists.newArrayList();
            }
        }
        return Optional.of((Object)requirements);
    }

    private File jsonRequirementsFile() {
        return new File(this.outputDirectory, this.storeName);
    }

    @Override
    public void write(List<Requirement> requirements) throws IOException {
        if (requirements.isEmpty()) {
            return;
        }
        this.ensureThatTheOutputDirectoryExists();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.jsonRequirementsFile()), StandardCharsets.UTF_8);){
            this.gson.toJson(requirements, (Appendable)writer);
        }
    }

    private void ensureThatTheOutputDirectoryExists() throws IOException {
        if (!this.outputDirectory.exists()) {
            Files.createDirectory(this.outputDirectory.toPath(), new FileAttribute[0]);
        }
    }

    @Override
    public void clear() {
        try {
            if (this.jsonRequirementsFile().exists()) {
                Files.delete(this.jsonRequirementsFile().toPath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

