/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.gargoylesoftware.htmlunit.ScriptException;
import io.appium.java_client.android.AndroidDriver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.pages.DefaultTimeouts;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.ConfigurableTimeouts;
import net.thucydides.core.webdriver.OptionsFacade;
import net.thucydides.core.webdriver.ProvidedDriver;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import net.thucydides.core.webdriver.stubs.CapabilitiesStub;
import net.thucydides.core.webdriver.stubs.KeyboardStub;
import net.thucydides.core.webdriver.stubs.MouseStub;
import net.thucydides.core.webdriver.stubs.NavigationStub;
import net.thucydides.core.webdriver.stubs.OptionsStub;
import net.thucydides.core.webdriver.stubs.TargetLocatorStub;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import net.thucydides.core.webdriver.stubs.WebElementFacadeStub;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFacade
implements WebDriver,
TakesScreenshot,
HasInputDevices,
JavascriptExecutor,
HasCapabilities,
ConfigurableTimeouts {
    private final Class<? extends WebDriver> driverClass;
    private final WebDriverFactory webDriverFactory;
    protected WebDriver proxiedWebDriver;
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFacade.class);
    private EnvironmentVariables environmentVariables;
    protected Duration implicitTimeout;

    public WebDriverFacade(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory) {
        this(driverClass, webDriverFactory, ConfiguredEnvironment.getEnvironmentVariables());
    }

    public WebDriverFacade(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory, EnvironmentVariables environmentVariables) {
        this.driverClass = driverClass;
        this.webDriverFactory = webDriverFactory;
        this.environmentVariables = environmentVariables;
        this.implicitTimeout = this.defaultImplicitWait();
    }

    public WebDriverFacade(WebDriver driver, WebDriverFactory webDriverFactory, EnvironmentVariables environmentVariables) {
        this.driverClass = driver.getClass();
        this.proxiedWebDriver = driver;
        this.webDriverFactory = webDriverFactory;
        this.environmentVariables = environmentVariables;
        this.implicitTimeout = this.defaultImplicitWait();
    }

    private Duration defaultImplicitWait() {
        int configuredWaitForTimeoutInMilliseconds = ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.integerFrom(this.environmentVariables, (int)DefaultTimeouts.DEFAULT_IMPLICIT_WAIT_TIMEOUT.in(TimeUnit.MILLISECONDS));
        return new Duration((long)configuredWaitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS);
    }

    public WebDriverFacade(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory, WebDriver proxiedWebDriver, Duration implicitTimeout) {
        this.driverClass = driverClass;
        this.webDriverFactory = webDriverFactory;
        this.proxiedWebDriver = proxiedWebDriver;
        this.implicitTimeout = implicitTimeout;
    }

    public WebDriverFacade withTimeoutOf(Duration implicitTimeout) {
        return new WebDriverFacade(this.driverClass, this.webDriverFactory, this.proxiedWebDriver, implicitTimeout);
    }

    public Class<? extends WebDriver> getDriverClass() {
        if (this.driverClass.isAssignableFrom(SupportedWebDriver.PROVIDED.getWebdriverClass())) {
            return this.getProxiedDriver().getClass();
        }
        return this.driverClass;
    }

    public WebDriver getProxiedDriver() {
        if (this.proxiedWebDriver == null) {
            this.proxiedWebDriver = this.newProxyDriver();
            WebdriverProxyFactory.getFactory().notifyListenersOfWebdriverCreationIn(this);
        }
        ThucydidesWebDriverSupport.initialize();
        ThucydidesWebDriverSupport.getWebdriverManager().setCurrentDriver(this);
        return this.proxiedWebDriver;
    }

    public boolean isEnabled() {
        return !StepEventBus.getEventBus().webdriverCallsAreSuspended();
    }

    public void reset() {
        if (this.proxiedWebDriver != null) {
            this.forcedQuit();
        }
        this.proxiedWebDriver = null;
    }

    private void forcedQuit() {
        try {
            this.getDriverInstance().quit();
            this.proxiedWebDriver = null;
        }
        catch (WebDriverException e) {
            LOGGER.warn("Closing a driver that was already closed: " + e.getMessage());
        }
    }

    protected WebDriver newProxyDriver() {
        return this.newDriverInstance();
    }

    private WebDriver newDriverInstance() {
        try {
            if (StepEventBus.getEventBus().isDryRun()) {
                return new WebDriverStub();
            }
            this.webDriverFactory.setupFixtureServices();
            return this.webDriverFactory.newWebdriverInstance(this.driverClass);
        }
        catch (UnsupportedDriverException e) {
            LOGGER.error("FAILED TO CREATE NEW WEBDRIVER_DRIVER INSTANCE " + this.driverClass + ": " + e.getMessage(), (Throwable)e);
            throw new UnsupportedDriverException("Could not instantiate " + this.driverClass, e);
        }
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        if (this.proxyInstanciated() && this.driverCanTakeScreenshots()) {
            try {
                return (X)((TakesScreenshot)this.getProxiedDriver()).getScreenshotAs(target);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                LOGGER.error("Failed to take screenshot - out of memory", (Throwable)outOfMemoryError);
            }
            catch (RuntimeException e) {
                LOGGER.warn("Failed to take screenshot (" + e.getMessage() + ")");
            }
        }
        return null;
    }

    private boolean driverCanTakeScreenshots() {
        return TakesScreenshot.class.isAssignableFrom(this.getProxiedDriver().getClass());
    }

    public void get(String url) {
        if (!this.isEnabled()) {
            return;
        }
        this.openIgnoringHtmlUnitScriptErrors(url);
    }

    private void openIgnoringHtmlUnitScriptErrors(String url) {
        block2: {
            try {
                this.ignoreUndefinedErrorsIfTheUrlIsCorrectFor(this.getProxiedDriver(), url);
                this.setTimeouts();
            }
            catch (WebDriverException e) {
                if (this.htmlunitScriptError(e)) break block2;
                throw e;
            }
        }
    }

    private void ignoreUndefinedErrorsIfTheUrlIsCorrectFor(WebDriver driver, String url) {
        block2: {
            try {
                driver.get(url);
            }
            catch (WebDriverException potentiallyIgnorableError) {
                if (this.currentUrlFor(driver).equals(this.urlDeclaredIn(url))) break block2;
                throw potentiallyIgnorableError;
            }
        }
    }

    private URL urlDeclaredIn(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private URL currentUrlFor(WebDriver driver) {
        try {
            return new URL(driver.getCurrentUrl());
        }
        catch (MalformedURLException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private void setTimeouts() {
        this.webDriverFactory.setTimeouts(this.getProxiedDriver(), this.implicitTimeout);
    }

    private boolean htmlunitScriptError(WebDriverException e) {
        if (e.getCause() != null && e.getCause() instanceof ScriptException) {
            LOGGER.warn("Ignoring HTMLUnit script error: " + e.getMessage());
            return true;
        }
        return false;
    }

    public String getCurrentUrl() {
        if (!this.isEnabled()) {
            return "";
        }
        return this.getProxiedDriver().getCurrentUrl();
    }

    public String getTitle() {
        if (!this.isEnabled()) {
            return "";
        }
        return this.getProxiedDriver().getTitle();
    }

    public List<WebElement> findElements(By by) {
        List elements;
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        try {
            this.webDriverFactory.setTimeouts(this.getProxiedDriver(), this.getCurrentImplicitTimeout());
            elements = this.getProxiedDriver().findElements(by);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.webDriverFactory.resetTimeouts(this.getProxiedDriver());
        }
        return elements;
    }

    public WebElement findElement(By by) {
        WebElement element;
        if (!this.isEnabled()) {
            return new WebElementFacadeStub();
        }
        try {
            this.webDriverFactory.setTimeouts(this.getProxiedDriver(), this.getCurrentImplicitTimeout());
            element = this.getProxiedDriver().findElement(by);
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            this.webDriverFactory.resetTimeouts(this.getProxiedDriver());
        }
        return element;
    }

    public String getPageSource() {
        if (!this.isEnabled()) {
            return "";
        }
        try {
            return this.getProxiedDriver().getPageSource();
        }
        catch (WebDriverException pageSourceNotSupported) {
            return "";
        }
        catch (RuntimeException pageSourceFailedForSomeReason) {
            LOGGER.warn("Failed to get the page source code (" + pageSourceFailedForSomeReason.getMessage() + ")");
            return "";
        }
    }

    @Override
    public void setImplicitTimeout(Duration implicitTimeout) {
        this.webDriverFactory.setTimeouts(this.getProxiedDriver(), implicitTimeout);
    }

    @Override
    public Duration getCurrentImplicitTimeout() {
        return this.webDriverFactory.currentTimeoutFor(this.getProxiedDriver());
    }

    @Override
    public Duration resetTimeouts() {
        return this.webDriverFactory.resetTimeouts(this.getProxiedDriver());
    }

    protected WebDriver getDriverInstance() {
        return this.proxiedWebDriver;
    }

    public void close() {
        if (this.proxyInstanciated()) {
            if (this.areWindowHandlesAllowed(this.getDriverInstance()) && this.getDriverInstance().getWindowHandles() != null && this.getDriverInstance().getWindowHandles().size() == 1) {
                this.quit();
            } else {
                this.getDriverInstance().close();
            }
            this.webDriverFactory.shutdownFixtureServices();
        }
    }

    private boolean areWindowHandlesAllowed(WebDriver driver) {
        return !(driver instanceof AndroidDriver);
    }

    public void quit() {
        if (this.proxyInstanciated()) {
            try {
                this.getDriverInstance().quit();
                this.webDriverFactory.releaseTimoutFor(this.getDriverInstance());
            }
            catch (WebDriverException e) {
                LOGGER.warn("Error while quitting the driver (" + e.getMessage() + ")");
            }
            this.proxiedWebDriver = null;
        }
    }

    protected boolean proxyInstanciated() {
        return this.getDriverInstance() != null;
    }

    public Set<String> getWindowHandles() {
        if (!this.isEnabled()) {
            return new HashSet<String>();
        }
        return this.getProxiedDriver().getWindowHandles();
    }

    public String getWindowHandle() {
        if (!this.isEnabled()) {
            return "";
        }
        return this.getProxiedDriver().getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        if (!this.isEnabled()) {
            return new TargetLocatorStub(this);
        }
        return this.getProxiedDriver().switchTo();
    }

    public WebDriver.Navigation navigate() {
        if (!this.isEnabled()) {
            return new NavigationStub();
        }
        return this.getProxiedDriver().navigate();
    }

    public WebDriver.Options manage() {
        if (!this.isEnabled()) {
            return new OptionsStub();
        }
        return new OptionsFacade(this.getProxiedDriver().manage(), this);
    }

    public boolean canTakeScreenshots() {
        if (this.driverClass != null) {
            if (this.driverClass == ProvidedDriver.class) {
                return TakesScreenshot.class.isAssignableFrom(this.getProxiedDriver().getClass()) || this.getProxiedDriver().getClass() == RemoteWebDriver.class;
            }
            return TakesScreenshot.class.isAssignableFrom(this.driverClass) || this.driverClass == RemoteWebDriver.class;
        }
        return false;
    }

    public boolean isInstantiated() {
        return this.driverClass != null && this.proxiedWebDriver != null;
    }

    public Keyboard getKeyboard() {
        if (!this.isEnabled()) {
            return new KeyboardStub();
        }
        return ((HasInputDevices)this.getProxiedDriver()).getKeyboard();
    }

    public Mouse getMouse() {
        if (!this.isEnabled()) {
            return new MouseStub();
        }
        return ((HasInputDevices)this.getProxiedDriver()).getMouse();
    }

    public Object executeScript(String script, Object ... parameters) {
        if (!this.isEnabled()) {
            return null;
        }
        return ((JavascriptExecutor)this.getProxiedDriver()).executeScript(script, parameters);
    }

    public Object executeAsyncScript(String script, Object ... parameters) {
        if (!this.isEnabled()) {
            return null;
        }
        return ((JavascriptExecutor)this.getProxiedDriver()).executeAsyncScript(script, parameters);
    }

    public Capabilities getCapabilities() {
        if (!this.isEnabled()) {
            return new CapabilitiesStub();
        }
        return ((HasCapabilities)this.getProxiedDriver()).getCapabilities();
    }

    public String getDriverName() {
        return SupportedWebDriver.forClass(this.driverClass).name().toLowerCase();
    }

    public String toString() {
        return "WebDriverFacade for " + this.getDriverName();
    }
}

