/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.serenitybdd.core.photography.PhotoFilter;
import net.serenitybdd.core.photography.ScreenshotNegative;
import net.serenitybdd.core.photography.ScreenshotReceipt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DarkroomProcessingLine
implements Runnable {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    boolean openForBusiness;
    private final List<? extends PhotoFilter> processors;
    private final List<ScreenshotNegative> queue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this.openForBusiness = false;
        List<ScreenshotNegative> list = this.queue;
        synchronized (list) {
            this.queue.notifyAll();
        }
    }

    DarkroomProcessingLine(List<? extends PhotoFilter> processors) {
        this.processors = processors;
        this.queue = Collections.synchronizedList(new LinkedList());
        this.openForBusiness = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenshotReceipt addToProcessingQueue(ScreenshotNegative negative) {
        this.queue.add(negative);
        List<ScreenshotNegative> list = this.queue;
        synchronized (list) {
            this.queue.notifyAll();
        }
        return this.recieptFor(negative);
    }

    private ScreenshotReceipt recieptFor(ScreenshotNegative negative) {
        return new ScreenshotReceipt(this.screenshotPathFor(negative));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.LOGGER.debug("Darkroom processing line starting up");
        while (this.openForBusiness) {
            List<ScreenshotNegative> list = this.queue;
            synchronized (list) {
                this.processNegative();
                try {
                    if (this.openForBusiness) {
                        this.queue.wait();
                    } else {
                        this.finishProcessingNegatives();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.LOGGER.debug("Darkroom processing line shutting down");
    }

    private void finishProcessingNegatives() {
        this.processNegative();
    }

    private void processNegative() {
        while (!this.queue.isEmpty()) {
            ScreenshotNegative negative = this.queue.remove(0);
            if (negative == null) continue;
            this.process(negative);
        }
    }

    public void process(ScreenshotNegative negative) {
        this.ensureThatTheDarkroomIsStillOpen();
        Path screenshotPath = this.screenshotPathFor(negative);
        if (!Files.exists(screenshotPath, new LinkOption[0])) {
            this.saveProcessedScreenshot(negative);
        }
        this.deleteTemporaryScreenshotFrom(negative);
    }

    private void deleteTemporaryScreenshotFrom(ScreenshotNegative negative) {
        try {
            Files.deleteIfExists(negative.getTemporaryPath());
        }
        catch (IOException e) {
            this.LOGGER.warn("Failed to delete temporary screenshot", (Throwable)e);
        }
    }

    private void saveProcessedScreenshot(ScreenshotNegative negative) {
        this.LOGGER.debug("Processing screenshot image in {}", (Object)negative.getTemporaryPath());
        for (PhotoFilter photoFilter : this.processors) {
            negative = photoFilter.process(negative);
        }
        try {
            this.LOGGER.debug("Saving screenshot to " + negative.getScreenshotPath());
            if (!Files.exists(negative.getScreenshotPath(), new LinkOption[0])) {
                this.ensureParentDirectoryExistsFor(negative.getScreenshotPath());
                Files.copy(negative.getTemporaryPath(), negative.getScreenshotPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            this.LOGGER.warn("Failed to save screenshot", (Throwable)e);
        }
    }

    private void ensureParentDirectoryExistsFor(Path screenshotPath) throws IOException {
        if (screenshotPath.getParent() != null) {
            Files.createDirectories(screenshotPath.getParent(), new FileAttribute[0]);
        }
    }

    private Path screenshotPathFor(ScreenshotNegative negative) {
        ScreenshotNegative amendedNegative = negative;
        for (PhotoFilter photoFilter : this.processors) {
            amendedNegative = amendedNegative.withScreenshotPath(photoFilter.amendedScreenshotPath(amendedNegative));
        }
        return amendedNegative.getScreenshotPath();
    }

    private void ensureThatTheDarkroomIsStillOpen() {
        Preconditions.checkArgument((boolean)this.openForBusiness, (Object)"The darkroom is closed and cannot accept any more negatives");
    }
}

