/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.servicepools;

import java.io.File;
import net.serenitybdd.core.webdriver.servicepools.DriverPathConfiguration;
import net.serenitybdd.core.webdriver.servicepools.DriverServiceExecutable;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.StopServiceHook;
import net.thucydides.core.ThucydidesSystemProperty;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.service.DriverService;

public class PhantomJSServicePool
extends DriverServicePool<PhantomJSDriverService> {
    @Override
    protected PhantomJSDriverService newDriverService() {
        PhantomJSDriverService newService = new PhantomJSDriverService.Builder().usingAnyFreePort().usingPhantomJSExecutable(this.phantomJSBinary()).build();
        DriverPathConfiguration.updateSystemProperty(ThucydidesSystemProperty.PHANTOMJS_BINARY_PATH.getPropertyName()).withExecutablePath(this.phantomJSBinary());
        Runtime.getRuntime().addShutdownHook(new StopServiceHook((DriverService)newService));
        return newService;
    }

    private File phantomJSBinary() {
        return DriverServiceExecutable.called("phantomjs").usingEnvironmentVariables(this.environmentVariables).withSystemProperty(ThucydidesSystemProperty.PHANTOMJS_BINARY_PATH.getPropertyName()).reportMissingBinary().downloadableFrom("http://phantomjs.org/").asAFile();
    }

    @Override
    protected String serviceName() {
        return "phantomjs";
    }

    @Override
    protected WebDriver newDriverInstance(Capabilities capabilities) {
        return new PhantomJSDriver(capabilities);
    }
}

