/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver;

import java.util.HashMap;
import java.util.Map;

public class OverrideDriverCapabilities {
    private static ThreadLocal<Map<String, Object>> OVERRIDDEN_DRIVER_CAPABILITIES = ThreadLocal.withInitial(HashMap::new);
    private static ThreadLocal<Boolean> OVERRIDE_DEFAULTS = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private String prefix;

    public OverrideDriverCapabilities(String prefix) {
        this.prefix = prefix;
    }

    public static OverrideSetter withProperty(String propertyName) {
        return new OverrideDriverCapabilitiesBuilder(propertyName);
    }

    public static void clear() {
        OVERRIDDEN_DRIVER_CAPABILITIES.get().clear();
        OVERRIDE_DEFAULTS.set(Boolean.FALSE);
    }

    public static Map<String, Object> getProperties() {
        return new HashMap<String, Object>(OVERRIDDEN_DRIVER_CAPABILITIES.get());
    }

    public static boolean shouldOverrideDefaults() {
        return OVERRIDE_DEFAULTS.get();
    }

    public static class OverrideDriverCapabilitiesBuilder
    implements OverrideSetter,
    CapabilityBuilderChain {
        private String propertyName;

        OverrideDriverCapabilitiesBuilder(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public CapabilityBuilderChain setTo(Object value) {
            ((Map)OVERRIDDEN_DRIVER_CAPABILITIES.get()).put(this.propertyName, value);
            return this;
        }

        @Override
        public CapabilityBuilderChain andOverrideDefaults() {
            OVERRIDE_DEFAULTS.set(Boolean.TRUE);
            return this;
        }

        @Override
        public OverrideSetter andProperty(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }
    }

    public static interface CapabilityBuilderChain {
        public OverrideSetter andProperty(String var1);

        public CapabilityBuilderChain andOverrideDefaults();
    }

    public static interface OverrideSetter {
        public CapabilityBuilderChain setTo(Object var1);
    }
}

