/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;

public class SanitisedBrowserPreferenceValue {
    public static Object of(Object value) {
        if (value instanceof String && SanitisedBrowserPreferenceValue.isMalformedPath(value.toString())) {
            return SanitisedBrowserPreferenceValue.normalisedPathOf(value.toString());
        }
        return value;
    }

    private static String normalisedPathOf(String value) {
        try {
            Paths.get(value, new String[0]).toRealPath(new LinkOption[0]);
        }
        catch (NoSuchFileException invalidPath) {
            String normalisedPath = value.replace("\\\\", "/").replace("\\", "/");
            try {
                Paths.get(normalisedPath, new String[0]).toRealPath(new LinkOption[0]);
                return normalisedPath;
            }
            catch (IOException notAWindowsPath) {
                return value;
            }
        }
        catch (IOException otherIOError) {
            return value;
        }
        return value;
    }

    private static boolean isMalformedPath(String value) {
        try {
            Paths.get(value, new String[0]).toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }
}

