/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.suiteslicing;

import com.google.common.collect.FluentIterable;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.feature.Options;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDocumentBuilder;
import io.cucumber.core.gherkin.messages.internal.gherkin.Parser;
import io.cucumber.core.gherkin.messages.internal.gherkin.TokenMatcher;
import io.cucumber.core.runtime.FeaturePathFeatureSupplier;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Tag;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.serenitybdd.cucumber.suiteslicing.TestStatistics;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenario;
import net.serenitybdd.cucumber.suiteslicing.WeightedCucumberScenarios;
import net.serenitybdd.cucumber.util.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberScenarioLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberScenarioLoader.class);
    private final Supplier<ClassLoader> classLoader = CucumberScenarioLoader.class::getClassLoader;
    private final FeatureParser parser = new FeatureParser(UUID::randomUUID);
    private final List<URI> featurePaths;
    private final TestStatistics statistics;
    private Map<io.cucumber.messages.types.Feature, URI> mapsForFeatures = new HashMap<io.cucumber.messages.types.Feature, URI>();

    public CucumberScenarioLoader(List<URI> featurePaths, TestStatistics statistics) {
        this.featurePaths = featurePaths;
        this.statistics = statistics;
    }

    public WeightedCucumberScenarios load() {
        LOGGER.debug("Feature paths are {}", this.featurePaths);
        Options featureOptions = () -> this.featurePaths;
        Parser gherkinParser = new Parser((Parser.Builder)new GherkinDocumentBuilder((IdGenerator)new IdGenerator.UUID()));
        TokenMatcher matcher = new TokenMatcher();
        FeaturePathFeatureSupplier supplier = new FeaturePathFeatureSupplier(this.classLoader, featureOptions, this.parser);
        IntStream.range(0, supplier.get().size()).forEach(i -> this.mapsForFeatures.put(((GherkinDocument)gherkinParser.parse(((Feature)supplier.get().get(i)).getSource(), (Parser.ITokenMatcher)matcher)).getFeature(), ((Feature)supplier.get().get(i)).getUri()));
        List<WeightedCucumberScenario> weightedCucumberScenarios = this.mapsForFeatures.keySet().stream().map(this.getScenarios()).flatMap(Collection::stream).collect(Collectors.toList());
        return new WeightedCucumberScenarios(weightedCucumberScenarios);
    }

    private Function<io.cucumber.messages.types.Feature, List<WeightedCucumberScenario>> getScenarios() {
        return cucumberFeature -> {
            try {
                return cucumberFeature == null ? Collections.emptyList() : cucumberFeature.getChildren().stream().filter(child -> child.getScenario() != null).map(FeatureChild::getScenario).map(scenarioDefinition -> new WeightedCucumberScenario(PathUtils.getAsFile(this.mapsForFeatures.get(cucumberFeature)).getName(), cucumberFeature.getName(), scenarioDefinition.getName(), this.scenarioWeightFor((io.cucumber.messages.types.Feature)cucumberFeature, (Scenario)scenarioDefinition), this.tagsFor((io.cucumber.messages.types.Feature)cucumberFeature, (Scenario)scenarioDefinition), this.scenarioCountFor((Scenario)scenarioDefinition))).collect(Collectors.toList());
            }
            catch (Exception e) {
                throw new IllegalStateException(String.format("Could not extract scenarios from %s", this.mapsForFeatures.get(cucumberFeature)), e);
            }
        };
    }

    private int scenarioCountFor(Scenario scenarioDefinition) {
        if (scenarioDefinition.getExamples().size() > 0) {
            return scenarioDefinition.getExamples().stream().map(examples -> examples.getTableBody().size()).mapToInt(Integer::intValue).sum();
        }
        return 1;
    }

    private Set<String> tagsFor(io.cucumber.messages.types.Feature feature, Scenario scenarioDefinition) {
        return FluentIterable.concat((Iterable)feature.getTags(), this.scenarioTags(scenarioDefinition)).stream().map(Tag::getName).collect(Collectors.toSet());
    }

    private List<Tag> scenarioTags(Scenario scenario) {
        if (scenario.getExamples().isEmpty()) {
            return scenario.getTags();
        }
        return Stream.of(scenario.getTags(), scenario.getExamples().stream().flatMap(e -> e.getTags().stream()).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private BigDecimal scenarioWeightFor(io.cucumber.messages.types.Feature feature, Scenario scenarioDefinition) {
        return this.statistics.scenarioWeightFor(feature.getName(), scenarioDefinition.getName());
    }
}

