/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.email;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.serenitybdd.reports.email.CSSFormatter;
import net.serenitybdd.reports.email.Formatted;
import net.serenitybdd.reports.email.SerenityEmailReport;
import net.serenitybdd.reports.email.templates.ThymeleafTemplateEngine;
import net.serenitybdd.reports.io.ReportIOKt;
import net.serenitybdd.reports.model.CustomReportFields;
import net.serenitybdd.reports.model.DurationsKt;
import net.serenitybdd.reports.model.FailuresByFeature;
import net.serenitybdd.reports.model.FrequentFailures;
import net.serenitybdd.reports.model.ReportInfo;
import net.serenitybdd.reports.model.ResultsCountKt;
import net.serenitybdd.reports.model.TagCoverage;
import net.serenitybdd.reports.model.TestResultSummary;
import net.serenitybdd.reports.model.TestResultsByFeature;
import net.serenitybdd.reports.model.UnstableFeatures;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.reports.ExtendedReport;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.util.EnvironmentVariables;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000eJ$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J$\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lnet/serenitybdd/reports/email/EmailReporter;", "Lnet/thucydides/core/reports/ExtendedReport;", "()V", "environmentVariables", "Lnet/thucydides/core/util/EnvironmentVariables;", "(Lnet/thucydides/core/util/EnvironmentVariables;)V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getEnvironmentVariables", "()Lnet/thucydides/core/util/EnvironmentVariables;", "generateReportFrom", "Ljava/io/File;", "sourceDirectory", "Ljava/nio/file/Path;", "getName", "", "newOutputFileIn", "outputDirectory", "outputFileIn", "templateFields", "", "", "testOutcomes", "Lnet/thucydides/core/reports/TestOutcomes;", "writeHtmlReportTo", "fields", "Companion", "serenity-emailer"})
public final class EmailReporter
implements ExtendedReport {
    private final Logger LOGGER;
    @NotNull
    private final EnvironmentVariables environmentVariables;
    @NotNull
    private static final List<TestResult> DISPLAYED_TEST_RESULTS;
    public static final Companion Companion;

    @NotNull
    public String getName() {
        return "email";
    }

    @NotNull
    public File generateReportFrom(@NotNull Path sourceDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)sourceDirectory, (String)"sourceDirectory");
        TestOutcomes testOutcomes = ReportIOKt.testOutcomesIn((Path)sourceDirectory).filteredByEnvironmentTags();
        Path outputDirectory = SerenityEmailReport.Companion.outputDirectory().configuredIn(this.environmentVariables);
        TestOutcomes testOutcomes2 = testOutcomes;
        Intrinsics.checkExpressionValueIsNotNull((Object)testOutcomes2, (String)"testOutcomes");
        Map<String, Object> fields = this.templateFields(this.environmentVariables, testOutcomes2);
        this.LOGGER.info("GENERATING EMAIL REPORT in " + outputDirectory);
        return this.writeHtmlReportTo(outputDirectory, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File writeHtmlReportTo(Path outputDirectory, Map<String, ? extends Object> fields) {
        File outputFile = this.newOutputFileIn(outputDirectory);
        Object object = outputFile;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileOutputStream((File)object3);
        bl3 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl2 = false;
        BufferedWriter writer = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        object = writer;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl5 = false;
            String template = SerenityEmailReport.Companion.template().configuredIn(this.environmentVariables);
            new ThymeleafTemplateEngine().merge(template, fields, writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return outputFile;
    }

    private final Map<String, Object> templateFields(EnvironmentVariables environmentVariables, TestOutcomes testOutcomes) {
        String reportTitle = SerenityEmailReport.Companion.reportTitle().configuredIn(environmentVariables);
        String reportLink = SerenityEmailReport.Companion.reportLink().configuredIn(environmentVariables);
        int scoreboardSize = ((Number)SerenityEmailReport.Companion.scoreboardSize().configuredIn(environmentVariables)).intValue();
        CustomReportFields customReportFields = new CustomReportFields(environmentVariables);
        List<String> tagTypes = SerenityEmailReport.Companion.tagTypes().configuredIn(environmentVariables);
        String tagCategoryTitle = SerenityEmailReport.Companion.tagCategoryTitle().configuredIn(environmentVariables);
        boolean showFullTestResults = SerenityEmailReport.Companion.showFullTestResults().configuredIn(environmentVariables);
        Pair[] pairArray = new Pair[13];
        pairArray[0] = TuplesKt.to((Object)"testOutcomes", (Object)testOutcomes);
        pairArray[1] = TuplesKt.to((Object)"showFullTestResults", (Object)showFullTestResults);
        String string = environmentVariables.getProperty("project.version", "");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"environmentVariables.get\u2026ty(\"project.version\", \"\")");
        LocalDateTime localDateTime = testOutcomes.getStartTime().orElse(ZonedDateTime.now()).toLocalDateTime();
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"testOutcomes.startTime.o\u2026.now()).toLocalDateTime()");
        pairArray[2] = TuplesKt.to((Object)"report", (Object)new ReportInfo(reportTitle, reportLink, tagCategoryTitle, string, localDateTime));
        int n = testOutcomes.getTotal();
        Map map = ResultsCountKt.countByResultLabelFrom((TestOutcomes)testOutcomes);
        Map map2 = ResultsCountKt.percentageByResultLabelFrom((TestOutcomes)testOutcomes);
        Long l = testOutcomes.getDuration();
        Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"testOutcomes.duration");
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMillis(testOutcomes.duration)");
        String string2 = DurationsKt.formattedDuration((Duration)duration);
        List list = testOutcomes.getOutcomes();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"testOutcomes.outcomes");
        String string3 = DurationsKt.formattedDuration((Duration)DurationsKt.clockDurationOf((List)list));
        List list2 = testOutcomes.getOutcomes();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"testOutcomes.outcomes");
        String string4 = DurationsKt.formattedDuration((Duration)DurationsKt.averageDurationOf((List)list2));
        List list3 = testOutcomes.getOutcomes();
        Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"testOutcomes.outcomes");
        String string5 = DurationsKt.formattedDuration((Duration)DurationsKt.maxDurationOf((List)list3));
        List list4 = testOutcomes.getOutcomes();
        Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"testOutcomes.outcomes");
        pairArray[3] = TuplesKt.to((Object)"results", (Object)new TestResultSummary(n, map, map2, string2, string3, string4, string5, DurationsKt.formattedDuration((Duration)DurationsKt.minDurationOf((List)list4))));
        pairArray[4] = TuplesKt.to((Object)"failuresByFeature", (Object)FailuresByFeature.Companion.from(testOutcomes));
        pairArray[5] = TuplesKt.to((Object)"resultsByFeature", (Object)TestResultsByFeature.Companion.from(testOutcomes));
        pairArray[6] = TuplesKt.to((Object)"frequentFailures", (Object)FrequentFailures.Companion.from(testOutcomes).withMaxOf(scoreboardSize));
        pairArray[7] = TuplesKt.to((Object)"unstableFeatures", (Object)UnstableFeatures.Companion.from(testOutcomes).withMaxOf(scoreboardSize));
        pairArray[8] = TuplesKt.to((Object)"coverage", (Object)TagCoverage.Companion.from(testOutcomes).forTagTypes(tagTypes));
        pairArray[9] = TuplesKt.to((Object)"customFields", (Object)customReportFields.getFieldNames());
        pairArray[10] = TuplesKt.to((Object)"customFieldValues", (Object)customReportFields.getValues());
        pairArray[11] = TuplesKt.to((Object)"formatted", (Object)new Formatted());
        pairArray[12] = TuplesKt.to((Object)"css", (Object)new CSSFormatter());
        HashMap fields = MapsKt.hashMapOf((Pair[])pairArray);
        return fields;
    }

    @NotNull
    public final File outputFileIn(@NotNull Path outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        File file = outputDirectory.resolve("serenity-summary.html").toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDirectory.resolve(\u2026y-summary.html\").toFile()");
        return file;
    }

    @NotNull
    public final File newOutputFileIn(@NotNull Path outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        outputDirectory.toFile().mkdirs();
        File outputFile = this.outputFileIn(outputDirectory);
        outputFile.createNewFile();
        return outputFile;
    }

    @NotNull
    public final EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public EmailReporter(@NotNull EnvironmentVariables environmentVariables) {
        Intrinsics.checkParameterIsNotNull((Object)environmentVariables, (String)"environmentVariables");
        this.environmentVariables = environmentVariables;
        this.LOGGER = LoggerFactory.getLogger(SerenityEmailReport.class);
    }

    public EmailReporter() {
        Object object = Injectors.getInjector().getProvider(EnvironmentVariables.class).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Injectors.getInjector().\u2026iables::class.java).get()");
        this((EnvironmentVariables)object);
    }

    static {
        Companion = new Companion(null);
        DISPLAYED_TEST_RESULTS = CollectionsKt.listOf((Object[])new TestResult[]{TestResult.SUCCESS, TestResult.PENDING, TestResult.IGNORED, TestResult.FAILURE, TestResult.ERROR, TestResult.COMPROMISED});
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/serenitybdd/reports/email/EmailReporter$Companion;", "", "()V", "DISPLAYED_TEST_RESULTS", "", "Lnet/thucydides/core/model/TestResult;", "getDISPLAYED_TEST_RESULTS", "()Ljava/util/List;", "serenity-emailer"})
    public static final class Companion {
        @NotNull
        public final List<TestResult> getDISPLAYED_TEST_RESULTS() {
            return DISPLAYED_TEST_RESULTS;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

