/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.adaptors.lettuce;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.reports.adaptors.common.FilebasedOutcomeAdaptor;
import net.thucydides.core.reports.adaptors.xunit.BasicXUnitLoader;
import net.thucydides.core.reports.adaptors.xunit.io.XUnitFiles;
import net.thucydides.core.reports.adaptors.xunit.model.TestCase;
import net.thucydides.core.reports.adaptors.xunit.model.TestSuite;

public class LettuceXUnitAdaptor
extends FilebasedOutcomeAdaptor {
    BasicXUnitLoader loader = new BasicXUnitLoader();

    @Override
    public List<TestOutcome> loadOutcomesFrom(File source) throws IOException {
        ArrayList<? extends TestOutcome> loadedOutcomes = new ArrayList<TestOutcome>();
        for (File xunitFile : XUnitFiles.in(source)) {
            loadedOutcomes.addAll(this.testOutcomesIn(xunitFile));
        }
        return NewList.copyOf(loadedOutcomes);
    }

    private Collection<? extends TestOutcome> testOutcomesIn(File xunitFile) throws IOException {
        List<TestSuite> rawTestSuites = this.loader.loadFrom(xunitFile);
        return NewList.copyOf(this.groupTestCasesByClassname(rawTestSuites));
    }

    private List<TestOutcome> groupTestCasesByClassname(List<TestSuite> testSuites) {
        ArrayList<TestOutcome> groupedOutcomes = new ArrayList<TestOutcome>();
        for (TestSuite suite : testSuites) {
            groupedOutcomes.addAll(this.testOutcomesWithGroupedTestCases(suite));
        }
        return groupedOutcomes;
    }

    private List<TestOutcome> testOutcomesWithGroupedTestCases(TestSuite testSuite) {
        List<TestCase> rawTestCases = testSuite.getTestCases();
        ArrayList<TestOutcome> groupedTestOutcomes = new ArrayList<TestOutcome>();
        HashMap<String, TestOutcome> testOutcomesIndex = new HashMap<String, TestOutcome>();
        for (TestCase testCase : rawTestCases) {
            TestOutcome testOutcome = this.testOutcomeForTestClass(testOutcomesIndex, testCase.getClassname());
            this.addIfNotPresent(groupedTestOutcomes, testOutcome);
            TestStep nextStep = TestStep.forStepCalled(testCase.getName()).withResult(this.resultOf(testCase));
            Optional<Throwable> testFailure = this.testFailureFrom(testCase);
            if (testFailure.isPresent()) {
                nextStep.failedWith(testFailure.get());
            }
            testOutcome.recordStep(nextStep);
        }
        return NewList.copyOf(groupedTestOutcomes);
    }

    private void addIfNotPresent(List<TestOutcome> groupedTestOutcomes, TestOutcome testOutcome) {
        if (!groupedTestOutcomes.contains(testOutcome)) {
            groupedTestOutcomes.add(testOutcome);
        }
    }

    private Optional<Throwable> testFailureFrom(TestCase testCase) {
        Throwable testFailure = null;
        if (testCase.getFailure().isPresent()) {
            testFailure = testCase.getFailure().get().asAssertionFailure();
        } else if (testCase.getSkipped().isPresent()) {
            testFailure = new PendingStepException(testCase.getSkipped().get().getType());
        } else if (testCase.getError().isPresent()) {
            testFailure = testCase.getError().get().asException();
        }
        return Optional.ofNullable(testFailure);
    }

    private TestResult resultOf(TestCase testCase) {
        if (testCase.getError().isPresent()) {
            return TestResult.ERROR;
        }
        if (testCase.getFailure().isPresent()) {
            return TestResult.FAILURE;
        }
        if (testCase.getSkipped().isPresent()) {
            return TestResult.SKIPPED;
        }
        return TestResult.SUCCESS;
    }

    private TestOutcome testOutcomeForTestClass(Map<String, TestOutcome> groupedTestOutcomes, String testClassName) {
        if (groupedTestOutcomes.containsKey(testClassName)) {
            return groupedTestOutcomes.get(testClassName);
        }
        TestOutcome newTestOutcome = TestOutcome.forTestInStory(testClassName, Story.called(testClassName));
        groupedTestOutcomes.put(testClassName, newTestOutcome);
        return newTestOutcome;
    }
}

