/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RenderMarkdown {
    private final String originalText;
    private final List<String> lines;
    private static final Pattern DATA_TABLE_LINE = Pattern.compile("\\s*(\\[|\uff3b)?(\\|.*\\|)(\\]|\uff3d?)\\s*");
    private static final Pattern SEPARATOR_LINE = Pattern.compile("\\|(-|\\s|\\|)+\\|");

    private RenderMarkdown(String text) {
        this.originalText = text;
        this.lines = Arrays.asList(text.split("\\r?\\n"));
    }

    public static String convertEmbeddedTablesIn(String text) {
        return new RenderMarkdown(text).convertTables();
    }

    public static String preprocessMarkdownTables(String text) {
        return new RenderMarkdown(text).injectNewLineBeforeTables();
    }

    private String injectNewLineBeforeTables() {
        List<NarrativeBlock> blocks = this.convertToBlocks(this.lines);
        ArrayList<String> spacedLines = new ArrayList<String>();
        for (NarrativeBlock block : blocks) {
            if (block.isTable()) {
                spacedLines.add(System.lineSeparator());
                spacedLines.addAll(block.lines);
                continue;
            }
            spacedLines.addAll(block.lines);
        }
        return spacedLines.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    private String convertTables() {
        if (this.noTablularLinesIn(this.lines)) {
            return this.originalText;
        }
        if (this.isRenderedMarkdownTableIn(this.tabularLinesIn(this.lines))) {
            return this.originalText;
        }
        return this.renderMarkdownTable();
    }

    private String renderMarkdownTable() {
        List<NarrativeBlock> blocks = this.convertToBlocks(this.lines);
        ArrayList markdownTable = new ArrayList();
        blocks.forEach(block -> markdownTable.addAll(block.asMarkdown()));
        return markdownTable.stream().collect(Collectors.joining(System.lineSeparator())) + System.lineSeparator();
    }

    private List<NarrativeBlock> convertToBlocks(List<String> lines) {
        ArrayList<NarrativeBlock> blocks = new ArrayList<NarrativeBlock>();
        boolean inTable = false;
        NarrativeBlock currentBlock = NarrativeBlock.forNormalText();
        for (String line : lines) {
            if (this.switchingToATableSection(inTable, line)) {
                inTable = true;
                blocks.add(currentBlock);
                currentBlock = NarrativeBlock.forATable();
            } else if (this.switchingToATextSection(inTable, line)) {
                inTable = false;
                blocks.add(currentBlock);
                currentBlock = NarrativeBlock.forNormalText();
            }
            currentBlock.add(this.trimSquareBracketsFrom(line));
        }
        blocks.add(currentBlock);
        return blocks;
    }

    private boolean switchingToATableSection(boolean inTable, String line) {
        return !inTable && this.isDataTableLine(line);
    }

    private boolean switchingToATextSection(boolean inTable, String line) {
        return inTable && !this.isDataTableLine(line);
    }

    private String headingFrom(List<String> tableLines) {
        return System.lineSeparator() + System.lineSeparator() + tableLines.get(0);
    }

    private List<String> bodyFrom(List<String> tableLines) {
        return tableLines.subList(1, tableLines.size());
    }

    static int numberOfColumnsIn(List<String> tableLines) {
        return Splitter.on((String)"|").omitEmptyStrings().splitToList((CharSequence)tableLines.get(0)).size();
    }

    private List<String> tabularLinesIn(List<String> lines) {
        ArrayList<String> tableLines = new ArrayList<String>();
        int row = lines.size() - 1;
        String line = lines.get(row);
        while (this.isDataTableLine(line) && row >= 0) {
            tableLines.add(this.trimSquareBracketsFrom(line));
            line = lines.get(--row);
        }
        Collections.reverse(tableLines);
        return tableLines;
    }

    private String trimSquareBracketsFrom(String line) {
        Matcher tableLine = DATA_TABLE_LINE.matcher(line);
        if (tableLine.matches()) {
            return tableLine.group(2);
        }
        return line;
    }

    private boolean isRenderedMarkdownTableIn(List<String> lines) {
        return lines.stream().anyMatch(this::isSeparatorLine);
    }

    private boolean noTablularLinesIn(List<String> lines) {
        return lines.stream().noneMatch(this::isDataTableLine);
    }

    private boolean isDataTableLine(String line) {
        return DATA_TABLE_LINE.matcher(line).matches();
    }

    private boolean isSeparatorLine(String line) {
        return SEPARATOR_LINE.matcher(line).matches();
    }

    private static class NarrativeBlock {
        private final boolean isTable;
        private List<String> lines = new ArrayList<String>();

        public static NarrativeBlock forNormalText() {
            return new NarrativeBlock(false);
        }

        public static NarrativeBlock forATable() {
            return new NarrativeBlock(true);
        }

        private NarrativeBlock(boolean isTable) {
            this.isTable = isTable;
        }

        public void add(String line) {
            this.lines.add(line);
        }

        public List<String> getLines() {
            return this.lines;
        }

        public boolean isTable() {
            return this.isTable;
        }

        public List<String> asMarkdown() {
            if (!this.isTable) {
                return this.lines;
            }
            return this.markdownTable();
        }

        private List<String> markdownTable() {
            int columnCount = RenderMarkdown.numberOfColumnsIn(this.lines);
            String separatorLine = "|" + StringUtils.repeat((String)"---|", (int)columnCount);
            ArrayList<String> markdownTable = new ArrayList<String>();
            markdownTable.add(System.lineSeparator());
            markdownTable.add(this.lines.get(0));
            markdownTable.add(separatorLine);
            for (int row = 1; row < this.lines.size(); ++row) {
                markdownTable.add(this.lines.get(row));
            }
            return markdownTable;
        }
    }
}

