/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.RequirementsMerger;
import net.thucydides.core.requirements.RequirementsProvided;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementTree;
import net.thucydides.core.requirements.reports.RequirementsOutcomeFactory;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleSourceRequirmentsOutcomeFactory
implements RequirementsOutcomeFactory {
    private final List<RequirementsTagProvider> requirementsTagProviders;
    private final IssueTracking issueTracking;
    private final EnvironmentVariables environmentVariables;
    private final ReportNameProvider reportNameProvider;
    private static final Logger LOGGER = LoggerFactory.getLogger(MultipleSourceRequirmentsOutcomeFactory.class);

    public MultipleSourceRequirmentsOutcomeFactory(List<RequirementsTagProvider> requirementsTagProviders, IssueTracking issueTracking, ReportNameProvider reportNameProvider) {
        this(requirementsTagProviders, issueTracking, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), reportNameProvider);
    }

    public MultipleSourceRequirmentsOutcomeFactory(List<RequirementsTagProvider> requirementsTagProviders, IssueTracking issueTracking, EnvironmentVariables environmentVariables, ReportNameProvider reportNameProvider) {
        this.requirementsTagProviders = NewList.copyOf(requirementsTagProviders);
        this.issueTracking = issueTracking;
        this.environmentVariables = environmentVariables;
        this.reportNameProvider = reportNameProvider;
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(TestOutcomes testOutcomes) {
        List<Requirement> allRequirements = new ArrayList<Requirement>();
        LOGGER.info("Loading requirements from tag providers :" + this.requirementsTagProviders);
        for (RequirementsTagProvider tagProvider : this.requirementsTagProviders) {
            allRequirements = new RequirementsMerger().merge(allRequirements, RequirementsProvided.by(tagProvider));
        }
        Optional<String> overview = this.requirementsTagProviders.stream().map(RequirementsTagProvider::getOverview).filter(Optional::isPresent).map(overviewText -> (String)overviewText.get()).findFirst();
        LOGGER.debug("Merged requirements set:{}{}", (Object)System.lineSeparator(), (Object)RequirementTree.withRequirements(allRequirements));
        return new RequirementsOutcomes(allRequirements, testOutcomes, this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider, overview.orElse(""));
    }

    @Override
    public RequirementsOutcomes buildRequirementsOutcomesFrom(Requirement parentRequirement, TestOutcomes testOutcomes) {
        List<Requirement> childRequirements = parentRequirement.getChildren();
        return new RequirementsOutcomes(parentRequirement, childRequirements, testOutcomes, this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider, "");
    }
}

