/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.formatters;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IssueExtractor {
    private static final String ISSUE_NUMBER_REGEXP = "#([A-Z][A-Z0-9-_]*)?-?\\d+";
    private static final String FULL_ISSUE_NUMBER_REGEXP = "([A-Z][A-Z0-9-_]*)-\\d+";
    private String workingCopy;
    private static final Pattern shortIssueNumberPattern = Pattern.compile("#([A-Z][A-Z0-9-_]*)?-?\\d+");
    private static final Pattern fullIssueNumberPattern = Pattern.compile("([A-Z][A-Z0-9-_]*)-\\d+");

    public IssueExtractor(String initialValue) {
        this.workingCopy = initialValue;
    }

    public List<String> getShortenedIssues() {
        Matcher matcher = shortIssueNumberPattern.matcher(this.workingCopy);
        ArrayList<String> issues = new ArrayList<String>();
        while (matcher.find()) {
            String issue = matcher.group();
            issues.add(issue);
            this.workingCopy = this.workingCopy.replaceFirst(issue, "");
        }
        return issues;
    }

    public List<String> getFullIssues() {
        Matcher unhashedMatcher = fullIssueNumberPattern.matcher(this.workingCopy);
        ArrayList<String> issues = new ArrayList<String>();
        while (unhashedMatcher.find()) {
            String issue = unhashedMatcher.group();
            issues.add(issue);
            this.workingCopy = this.workingCopy.replaceFirst(issue, "");
        }
        return issues;
    }
}

