/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.text.StrSubstitutor;

public class PropertiesUtil {
    public static Properties copyOf(Properties sourceProperties) {
        Properties copiedProperties = new Properties();
        for (String propertyName : sourceProperties.stringPropertyNames()) {
            if (sourceProperties.getProperty(propertyName) == null) continue;
            copiedProperties.setProperty(propertyName, sourceProperties.getProperty(propertyName));
        }
        return copiedProperties;
    }

    public static void expandPropertyAndEnvironmentReferences(Map<String, String> runnerEnvironmentVariables, Properties properties) {
        Set<String> names = properties.stringPropertyNames();
        for (String name : names) {
            String value = properties.getProperty(name);
            String expandedValue = StrSubstitutor.replaceSystemProperties((Object)value);
            expandedValue = StrSubstitutor.replace((Object)expandedValue, runnerEnvironmentVariables);
            properties.setProperty(name, expandedValue);
        }
    }
}

