/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.inject.Inject;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.collect.NewSet;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.OutcomeCounter;
import net.thucydides.core.model.ScenarioOutcomeCounter;
import net.thucydides.core.model.TestDuration;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestResultList;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.TestType;
import net.thucydides.core.model.flags.Flag;
import net.thucydides.core.model.flags.FlagCounts;
import net.thucydides.core.model.formatters.TestCoverageFormatter;
import net.thucydides.core.reports.TestOutcomeCounter;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.RequirementsTree;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.tags.OutcomeTagFilter;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class TestOutcomes {
    private final List<? extends TestOutcome> outcomes;
    private final Optional<TestOutcomes> rootOutcomes;
    private final double estimatedAverageStepCount;
    private final EnvironmentVariables environmentVariables;
    private final RequirementsService requirementsService;
    private final String label;
    private final TestTag testTag;
    private final TestResult resultFilter;
    private static final Integer DEFAULT_ESTIMATED_TOTAL_STEPS = 3;
    static int outcomeCount = 0;
    private static List<TestOutcome> NO_OUTCOMES = new ArrayList<TestOutcome>();
    private Map<? extends Flag, Integer> flagCount = null;
    private final Set<String> SECOND_CLASS_TAG_TYPES = NewSet.of("version", "feature", "story");

    @Inject
    protected TestOutcomes(Collection<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label, TestTag testTag, TestResult resultFilter, TestOutcomes rootOutcomes, EnvironmentVariables environmentVariables) {
        outcomeCount += outcomes.size();
        this.outcomes = Collections.unmodifiableList(this.sorted(outcomes));
        this.estimatedAverageStepCount = estimatedAverageStepCount;
        this.label = label;
        this.testTag = testTag;
        this.resultFilter = resultFilter;
        this.rootOutcomes = Optional.ofNullable(rootOutcomes);
        this.environmentVariables = environmentVariables;
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
    }

    protected TestOutcomes(Collection<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label, TestOutcomes rootOutcomes, EnvironmentVariables environmentVariables) {
        outcomeCount += outcomes.size();
        this.outcomes = Collections.unmodifiableList(this.sorted(outcomes));
        this.estimatedAverageStepCount = estimatedAverageStepCount;
        this.label = label;
        this.testTag = null;
        this.resultFilter = null;
        this.rootOutcomes = Optional.ofNullable(rootOutcomes);
        this.environmentVariables = environmentVariables;
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
    }

    private List<TestOutcome> sorted(Collection<? extends TestOutcome> outcomes) {
        return outcomes.stream().sorted(Comparator.comparing(TestOutcome::getPath, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(TestOutcome::getStartTime, Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toList());
    }

    protected TestOutcomes(Collection<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label) {
        this(outcomes, estimatedAverageStepCount, label, null, null, null, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label, TestTag tag) {
        this(outcomes, estimatedAverageStepCount, label, tag, null, null, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    protected TestOutcomes(List<? extends TestOutcome> outcomes, double estimatedAverageStepCount, String label, TestResult resultFilter) {
        this(outcomes, estimatedAverageStepCount, label, null, resultFilter, null, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    protected TestOutcomes(Collection<? extends TestOutcome> outcomes, double estimatedAverageStepCount) {
        this(outcomes, estimatedAverageStepCount, "");
    }

    public TestOutcomes withLabel(String label) {
        return new TestOutcomes(this.outcomes, this.estimatedAverageStepCount, label);
    }

    public TestOutcomes withResultFilter(TestResult testResult) {
        return new TestOutcomes(this.outcomes, this.estimatedAverageStepCount, this.label, testResult);
    }

    public TestOutcomes filteredByEnvironmentTags() {
        OutcomeTagFilter outcomeFilter = new OutcomeTagFilter(this.environmentVariables);
        List<? extends TestOutcome> filteredOutcomes = outcomeFilter.outcomesFilteredByTagIn(this.getOutcomes());
        return TestOutcomes.of(filteredOutcomes).withLabel(this.label);
    }

    public EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public TestOutcomes havingResult(String result) {
        return this.havingResult(TestResult.valueOf(result.toUpperCase()));
    }

    private List<TestOutcome> outcomesFilteredByResult(TestResult ... results) {
        if (this.onlyPassing(results)) {
            return this.outcomesExclusivelyWithResults(results);
        }
        return this.outcomesWithAtLeastOneResultOf(results);
    }

    private boolean onlyPassing(TestResult[] results) {
        return Arrays.stream(results).allMatch(result -> result == TestResult.SUCCESS);
    }

    private List<TestOutcome> outcomesExclusivelyWithResults(TestResult ... results) {
        List<TestResult> eligableResults = NewList.of(results);
        return this.outcomes.stream().filter(outcome -> eligableResults.contains((Object)outcome.getResult())).collect(Collectors.toList());
    }

    private List<TestOutcome> outcomesWithAtLeastOneResultOf(TestResult ... results) {
        return this.outcomes.stream().filter(outcome -> this.outcomeHasResultFrom((TestOutcome)outcome, results)).collect(Collectors.toList());
    }

    private boolean outcomeHasResultFrom(TestOutcome outcome, TestResult ... results) {
        List<TestResult> eligableResults = NewList.of(results);
        if (!outcome.isDataDriven()) {
            return eligableResults.contains((Object)outcome.getResult());
        }
        return outcome.getDataTable().getRows().stream().anyMatch(row -> eligableResults.contains((Object)row.getResult()));
    }

    public TestOutcomes havingResult(TestResult result) {
        return TestOutcomes.of(this.outcomesFilteredByResult(result)).withLabel(this.labelForTestsWithStatus(result.name())).withResultFilter(result).withRootOutcomes(this.getRootOutcomes());
    }

    public static TestOutcomes of(Collection<? extends TestOutcome> outcomes) {
        return new TestOutcomes(outcomes, ConfiguredEnvironment.getConfiguration().getEstimatedAverageStepCount());
    }

    public static TestOutcomes withNoResults() {
        return new TestOutcomes(NO_OUTCOMES, ConfiguredEnvironment.getConfiguration().getEstimatedAverageStepCount());
    }

    public Map<? extends Flag, Integer> getFlagCounts() {
        if (this.flagCount != null) {
            return this.flagCount;
        }
        this.flagCount = FlagCounts.in(this.getOutcomes()).asAMap();
        return this.flagCount;
    }

    public boolean haveFlags() {
        return !this.getFlags().isEmpty();
    }

    public Set<? extends Flag> getFlags() {
        return this.getFlagCounts().keySet();
    }

    public Integer flagCountFor(Flag flag) {
        return this.getFlagCounts().get(flag);
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getTagTypes() {
        return this.outcomes.stream().flatMap(this::tagTypesIn).distinct().sorted().collect(Collectors.toList());
    }

    public List<String> getFirstClassTagTypes() {
        return this.getTagTypes().stream().filter(tagType -> !this.SECOND_CLASS_TAG_TYPES.contains(tagType)).filter(tagType -> !this.getRequirementTagTypes().contains(tagType)).collect(Collectors.toList());
    }

    public List<String> getRequirementTagTypes() {
        return this.requirementsService.getRequirementTypes().stream().filter(tagType -> this.getTagTypes().contains(tagType)).collect(Collectors.toList());
    }

    public List<String> getTagNames() {
        return this.outcomes.stream().flatMap(this::tagNamesIn).distinct().sorted().collect(Collectors.toList());
    }

    private Stream<String> tagTypesIn(TestOutcome outcome) {
        return outcome.getTags().stream().map(tag -> tag.getType().toLowerCase());
    }

    private Stream<String> tagNamesIn(TestOutcome outcome) {
        return outcome.getTags().stream().map(tag -> tag.getName().toLowerCase());
    }

    public List<TestTag> getTags() {
        return this.outcomes.stream().flatMap(outcome -> outcome.getAllTags().stream()).distinct().collect(Collectors.toList());
    }

    public List<TestTag> getTagsOfType(String tagType) {
        return this.outcomes.stream().flatMap(outcome -> this.tagsOfType(tagType).from((TestOutcome)outcome)).distinct().sorted().collect(Collectors.toList());
    }

    public List<TestTag> getMostSpecificTagsOfType(String tagType) {
        return this.outcomes.stream().flatMap(outcome -> this.removeGeneralTagsFrom(this.tagsOfType(tagType).in((TestOutcome)outcome))).sorted().collect(Collectors.toList());
    }

    private Stream<TestTag> removeGeneralTagsFrom(List<TestTag> tags) {
        return tags.stream().filter(tag -> !this.moreSpecificTagExists((TestTag)tag, tags));
    }

    private boolean moreSpecificTagExists(TestTag generalTag, List<TestTag> tags) {
        return tags.stream().anyMatch(tag -> tag.getName().endsWith("/" + generalTag.getName()));
    }

    public List<TestTag> getTagsOfTypeExcluding(String tagType, String excludedTag) {
        Predicate<TestTag> withExcludedTags = tag -> !tag.getName().equalsIgnoreCase(excludedTag);
        List allTags = this.outcomes.stream().flatMap(outcome -> this.tagsOfType(tagType).from((TestOutcome)outcome)).collect(Collectors.toList());
        return allTags.stream().filter(tag -> !this.moreSpecificTagExists((TestTag)tag, allTags)).filter(withExcludedTags).distinct().sorted().collect(Collectors.toList());
    }

    private TagFinder tagsOfType(String tagType) {
        return new TagFinder(tagType);
    }

    public TestOutcomes getRootOutcomes() {
        return this.rootOutcomes.orElse(this);
    }

    private List<? extends TestOutcome> outcomesWithMatchingTagFor(Requirement childRequirement) {
        return this.withTag(childRequirement.asTag()).getOutcomes();
    }

    private List<? extends TestOutcome> outcomesWithMatchingCardNumberFor(Requirement childRequirement) {
        if (childRequirement.getCardNumber() != null) {
            return this.withCardNumber(childRequirement.getCardNumber()).getOutcomes();
        }
        return Collections.emptyList();
    }

    private Stream<? extends TestOutcome> outcomesMatching(Requirement requirement) {
        return Stream.concat(this.outcomesWithMatchingTagFor(requirement).stream(), this.outcomesWithMatchingCardNumberFor(requirement).stream());
    }

    public TestOutcomes forRequirement(Requirement requirement) {
        HashSet<TestOutcome> testOutcomesForThisRequirement = new HashSet<TestOutcome>();
        for (Requirement childRequirement : RequirementsTree.forRequirement(requirement).asFlattenedList()) {
            testOutcomesForThisRequirement.addAll(this.withTag(childRequirement.asTag()).getOutcomes());
            if (childRequirement.getCardNumber() == null) continue;
            testOutcomesForThisRequirement.addAll(this.withCardNumber(childRequirement.getCardNumber()).getOutcomes());
        }
        return TestOutcomes.of(testOutcomesForThisRequirement).withLabel(requirement.getDisplayName()).withTestTag(requirement.asTag()).withRootOutcomes(this.getRootOutcomes());
    }

    public TestTag getTestTag() {
        return this.testTag;
    }

    public boolean containsTag(TestTag testTag) {
        return this.getTags().contains(testTag);
    }

    public boolean containsTagMatching(TestTag containedTag) {
        return this.getTags().stream().anyMatch(tag -> tag.isAsOrMoreSpecificThan(containedTag) || containedTag.isAsOrMoreSpecificThan((TestTag)tag));
    }

    public Optional<ZonedDateTime> getStartTime() {
        return this.outcomes.stream().filter(outcome -> outcome.getStartTime() != null).map(TestOutcome::getStartTime).sorted().findFirst();
    }

    public TestOutcomes ofType(TestType testType) {
        List filteredOutcomes = this.outcomes.stream().filter(outcome -> outcome.typeCompatibleWith(testType)).collect(Collectors.toList());
        return TestOutcomes.of(filteredOutcomes);
    }

    private boolean failedWith(TestOutcome outcome, String testFailureErrorType) {
        if (!outcome.isDataDriven()) {
            return outcome.getTestFailureErrorType().equals(testFailureErrorType) && outcome.getResult().isAtLeast(TestResult.FAILURE);
        }
        return outcome.getTestSteps().stream().anyMatch(step -> step.getResult().isAtLeast(TestResult.FAILURE) && step.getException() != null && step.getException().getErrorType().equals(testFailureErrorType));
    }

    public Integer scenarioCountWithResult(TestResult result) {
        return this.outcomes.stream().mapToInt(outcome -> this.countScenariosWithResult(result, (TestOutcome)outcome)).sum();
    }

    private int countScenariosWithResult(TestResult result, TestOutcome outcome) {
        if (result == TestResult.UNSUCCESSFUL) {
            return this.countScenariosWithResults(outcome, TestResult.FAILURE, TestResult.ERROR, TestResult.COMPROMISED);
        }
        return this.countScenariosWithResults(outcome, result);
    }

    private int countScenariosWithResults(TestOutcome outcome, TestResult ... results) {
        List<TestResult> expectedResults = Arrays.asList(results);
        if (!outcome.isDataDriven()) {
            return expectedResults.contains((Object)outcome.getResult()) ? 1 : 0;
        }
        if (outcome.isManual()) {
            return (int)this.stepsWithResultIn(outcome.getTestSteps(), expectedResults);
        }
        if (this.dataTableRowResultsAreUndefinedIn(outcome.getDataTable()) && outcome.getTestSteps().size() == outcome.getDataTable().getSize()) {
            return (int)this.stepsWithResultIn(outcome.getTestSteps(), expectedResults);
        }
        return (int)outcome.getDataTable().getRows().stream().filter(row -> expectedResults.contains((Object)row.getResult())).count();
    }

    private long stepsWithResultIn(List<TestStep> steps, List<TestResult> expectedResults) {
        return steps.stream().filter(step -> expectedResults.contains((Object)step.getResult())).count();
    }

    private boolean dataTableRowResultsAreUndefinedIn(DataTable dataTable) {
        return dataTable.getRows().stream().allMatch(row -> row.getResult() == TestResult.UNDEFINED);
    }

    public TestOutcomes withErrorType(String testFailureErrorType) {
        List filteredOutcomes = this.outcomes.stream().filter(outcome -> this.failedWith((TestOutcome)outcome, testFailureErrorType)).collect(Collectors.toList());
        return TestOutcomes.of(filteredOutcomes).withLabel("");
    }

    public TestOutcomes withResult(TestResult result) {
        List filteredOutcomes = this.outcomes.stream().filter(outcome -> this.countScenariosWithResult(result, (TestOutcome)outcome) > 0).collect(Collectors.toList());
        return TestOutcomes.of(filteredOutcomes);
    }

    public TestOutcomes withRequirementsTags() {
        for (TestOutcome testOutcome : this.outcomes) {
            ArrayList<TestTag> outcomeTags = new ArrayList<TestTag>(testOutcome.getAllTags());
            List<Requirement> parentRequirements = this.requirementsService.getAncestorRequirementsFor(testOutcome);
            for (Requirement requirement : parentRequirements) {
                outcomeTags.add(requirement.asTag());
            }
            testOutcome.addTags(outcomeTags);
        }
        return this;
    }

    public Optional<? extends TestOutcome> testOutcomeWithName(String name) {
        return this.outcomes.stream().filter(outcome -> outcome.getName().equalsIgnoreCase(name)).findFirst();
    }

    public List<TestOutcome> testOutcomesWithName(String name) {
        return this.outcomes.stream().filter(outcome -> outcome.getName().equalsIgnoreCase(name)).collect(Collectors.toList());
    }

    public long getFastestTestDuration() {
        return this.outcomes.stream().filter(outcome -> outcome.getDuration() > 0L).mapToLong(this::minDurationOf).min().orElse(0L);
    }

    public long getSlowestTestDuration() {
        return this.outcomes.stream().filter(outcome -> outcome.getDuration() > 0L).mapToLong(this::maxDurationOf).max().orElse(0L);
    }

    private Long maxDurationOf(TestOutcome outcome) {
        if (outcome.isDataDriven()) {
            return outcome.getTestSteps().stream().mapToLong(TestStep::getDuration).max().orElse(0L);
        }
        return outcome.getDuration();
    }

    private Long minDurationOf(TestOutcome outcome) {
        if (outcome.isDataDriven()) {
            return outcome.getTestSteps().stream().mapToLong(TestStep::getDuration).min().orElse(0L);
        }
        return outcome.getDuration();
    }

    public TestOutcomes withTagType(String tagType) {
        List testOutcomesWithTags = this.outcomes.stream().filter(outcome -> outcome.hasTagWithType(tagType)).collect(Collectors.toList());
        return TestOutcomes.of(testOutcomesWithTags).withLabel(tagType).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes withTagTypes(List<String> tagTypes) {
        List testOutcomesWithTags = this.outcomes.stream().filter(outcome -> outcome.hasTagWithTypes(tagTypes)).collect(Collectors.toList());
        return TestOutcomes.of(testOutcomesWithTags).withLabel(Joiner.on(",").join(tagTypes)).withRootOutcomes(this.getRootOutcomes());
    }

    private TestOutcomes withRootOutcomes(TestOutcomes rootOutcomes) {
        return new TestOutcomes(this.outcomes, this.estimatedAverageStepCount, this.label, this.testTag, this.resultFilter, rootOutcomes, this.environmentVariables);
    }

    public TestOutcomes withTag(String tagName) {
        List testOutcomesWithTags = this.outcomes.stream().filter(outcome -> outcome.hasTagWithName(tagName)).collect(Collectors.toList());
        return TestOutcomes.of(testOutcomesWithTags).withLabel(tagName).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes withTag(TestTag tag) {
        List<? extends TestOutcome> outcomesWithMatchingTag = this.matchingOutcomes(this.outcomes, tag);
        return TestOutcomes.of(outcomesWithMatchingTag).withLabel(tag.getShortName()).withTestTag(tag).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes withCardNumber(String issueCardNumber) {
        List<? extends TestOutcome> outcomesWithMatchingTag = this.matchingOutcomes(this.outcomes, TestTag.withName(issueCardNumber).andType("issue"));
        return TestOutcomes.of(outcomesWithMatchingTag).withTestTag(TestTag.withName(issueCardNumber).andType("issue")).withRootOutcomes(this.getRootOutcomes());
    }

    private TestOutcomes withTestTag(TestTag tag) {
        return new TestOutcomes(this.outcomes, this.estimatedAverageStepCount, this.label, tag);
    }

    public TestOutcomes withTags(Collection<TestTag> tags) {
        HashSet<? extends TestOutcome> filteredOutcomes = new HashSet<TestOutcome>();
        for (TestTag tag : tags) {
            filteredOutcomes.addAll(this.matchingOutcomes(this.outcomes, tag));
        }
        return TestOutcomes.of(filteredOutcomes);
    }

    private List<? extends TestOutcome> matchingOutcomes(List<? extends TestOutcome> outcomes, TestTag tag) {
        return outcomes.stream().filter(outcome -> this.hasMatchingTag((TestOutcome)outcome, tag)).map(outcome -> outcome.withDataRowsfilteredbyTag(tag)).collect(Collectors.toList());
    }

    private List<? extends TestOutcome> matchingOutcomesWithTagsFrom(List<? extends TestOutcome> outcomes, Collection<TestTag> tags) {
        return outcomes.stream().filter(outcome -> this.hasMatchingTagsFrom((TestOutcome)outcome, tags)).map(outcome -> outcome.withDataRowsfilteredbyTagsFrom(tags)).collect(Collectors.toList());
    }

    private boolean hasMatchingTagsFrom(TestOutcome outcome, Collection<TestTag> tags) {
        return tags.stream().anyMatch(tag -> this.hasMatchingTag(outcome, (TestTag)tag));
    }

    private boolean hasMatchingTag(TestOutcome outcome, TestTag tag) {
        if (this.isAnIssue(tag)) {
            return outcome.hasIssue(tag.getName());
        }
        return outcome.hasTag(tag) || outcome.hasAMoreGeneralFormOfTag(tag);
    }

    private boolean isAnIssue(TestTag tag) {
        return tag.getType().equalsIgnoreCase("issue");
    }

    public String getResultFilterName() {
        return this.resultFilter.name();
    }

    public TestOutcomes getUnsuccessfulTests() {
        return TestOutcomes.of(this.outcomesFilteredByResult(TestResult.ERROR, TestResult.FAILURE, TestResult.COMPROMISED)).withLabel(this.labelForTestsWithStatus("unsuccessful tests")).withResultFilter(TestResult.UNSUCCESSFUL).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes getFailingTests() {
        return TestOutcomes.of(this.outcomesFilteredByResult(TestResult.FAILURE)).withLabel(this.labelForTestsWithStatus("failing tests")).withResultFilter(TestResult.FAILURE).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes getErrorTests() {
        return TestOutcomes.of(this.outcomesFilteredByResult(TestResult.ERROR)).withLabel(this.labelForTestsWithStatus("tests with errors")).withResultFilter(TestResult.ERROR).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes getCompromisedTests() {
        return TestOutcomes.of(this.outcomesFilteredByResult(TestResult.COMPROMISED)).withLabel(this.labelForTestsWithStatus("compromised tests")).withResultFilter(TestResult.COMPROMISED).withRootOutcomes(this.getRootOutcomes());
    }

    private String labelForTestsWithStatus(String status) {
        if (StringUtils.isEmpty((CharSequence)this.label)) {
            return status;
        }
        return this.label + " (" + status + ")";
    }

    public TestOutcomes getPassingTests() {
        return TestOutcomes.of(this.outcomesFilteredByResult(TestResult.SUCCESS)).withLabel(this.labelForTestsWithStatus("passing tests")).withResultFilter(TestResult.SUCCESS).withRootOutcomes(this.getRootOutcomes());
    }

    public TestOutcomes getPendingTests() {
        List<TestOutcome> pendingOutcomes = this.outcomesWithResults(this.outcomes, TestResult.PENDING);
        return TestOutcomes.of(pendingOutcomes).withLabel(this.labelForTestsWithStatus("pending tests")).withResultFilter(TestResult.PENDING).withRootOutcomes(this.getRootOutcomes());
    }

    private List<TestOutcome> outcomesWithResults(List<? extends TestOutcome> outcomes, TestResult ... possibleResults) {
        ArrayList<TestOutcome> validOutcomes = new ArrayList<TestOutcome>();
        List<TestResult> possibleResultsList = Arrays.asList(possibleResults);
        for (TestOutcome testOutcome : outcomes) {
            if (!possibleResultsList.contains((Object)testOutcome.getResult())) continue;
            validOutcomes.add(testOutcome);
        }
        return validOutcomes;
    }

    public List<? extends TestOutcome> getTests() {
        return this.outcomes;
    }

    public Long getDuration() {
        return this.outcomes.stream().mapToLong(TestOutcome::getDuration).sum();
    }

    public double getDurationInSeconds() {
        return TestDuration.of(this.getDuration()).inSeconds();
    }

    public String getResultTypeLabel() {
        String resultTypeAdjective = this.resultFilter != null ? this.resultFilter.getAdjective().toLowerCase() + " " : "";
        return resultTypeAdjective + Inflector.inflection().of(this.getTotalMatchingScenarios()).times("test").inPluralForm().toString();
    }

    public int getTotal() {
        return this.outcomes.stream().mapToInt(TestOutcome::getTestCount).sum();
    }

    public int getTotalMatchingScenarios() {
        if (this.resultFilter == null) {
            return this.getTotal();
        }
        return this.scenarioCountWithResult(this.resultFilter);
    }

    public int getTotalTestScenarios() {
        return this.outcomes.size();
    }

    public List<? extends TestOutcome> getOutcomes() {
        return this.outcomes;
    }

    public TestResult getResult() {
        return TestResultList.overallResultFrom(this.getCurrentTestResults());
    }

    private List<TestResult> getCurrentTestResults() {
        return this.outcomes.stream().map(TestOutcome::getResult).collect(Collectors.toList());
    }

    public int getStepCount() {
        return this.outcomes.stream().mapToInt(TestOutcome::getNestedStepCount).sum();
    }

    public int successCount(String testType) {
        TestType expectedTestType = TestType.valueOf(testType.toUpperCase());
        return this.outcomes.stream().mapToInt(outcome -> outcome.countResults(TestResult.SUCCESS, expectedTestType)).sum();
    }

    public OutcomeCounter getTotalTests() {
        return this.count(TestType.ANY);
    }

    public ScenarioOutcomeCounter getTotalScenarios() {
        return new ScenarioOutcomeCounter(TestType.ANY, this);
    }

    public OutcomeCounter count(String testType) {
        return this.count(TestType.valueOf(testType.toUpperCase()));
    }

    public OutcomeCounter count(TestType testType) {
        return new OutcomeCounter(testType, this);
    }

    public OutcomeProportionCounter getProportion() {
        return this.proportionOf(TestType.ANY);
    }

    public OutcomeProportionCounter proportionOf(String testType) {
        return this.proportionOf(TestType.valueOf(testType.toUpperCase()));
    }

    public OutcomeProportionCounter proportionOf(TestType testType) {
        return new OutcomeProportionCounter(testType);
    }

    public OutcomeProportionStepCounter getPercentSteps() {
        return this.proportionalStepsOf(TestType.ANY);
    }

    public OutcomeProportionStepCounter proportionalStepsOf(String testType) {
        return this.proportionalStepsOf(TestType.valueOf(testType.toUpperCase()));
    }

    public OutcomeProportionStepCounter proportionalStepsOf(TestType testType) {
        return new OutcomeProportionStepCounter(testType);
    }

    public OutcomeProportionStepCounter decimalPercentageSteps(String testType) {
        return new OutcomeProportionStepCounter(TestType.valueOf(testType.toUpperCase()));
    }

    public TestCoverageFormatter.FormattedPercentageStepCoverage getFormattedPercentageSteps() {
        return new TestCoverageFormatter(this).getPercentSteps();
    }

    public TestCoverageFormatter.FormattedPercentageCoverage getFormattedPercentage() {
        return new TestCoverageFormatter(this).getPercentTests();
    }

    public TestCoverageFormatter.FormattedPercentageCoverage getFormattedPercentage(String testType) {
        this.getFormattedPercentage().withIndeterminateResult();
        return new TestCoverageFormatter(this).percentTests(testType);
    }

    public TestCoverageFormatter.FormattedPercentageCoverage getFormattedPercentage(TestType testType) {
        return new TestCoverageFormatter(this).percentTests(testType);
    }

    public TestCoverageFormatter getFormatted() {
        return new TestCoverageFormatter(this);
    }

    private int countStepsWithResult(TestResult expectedResult, TestType testType) {
        int stepCount = this.outcomes.stream().mapToInt(outcome -> outcome.countNestedStepsWithResult(expectedResult, testType)).sum();
        if (stepCount == 0 && this.aMatchingTestExists(expectedResult, testType)) {
            return (int)Math.round(this.getAverageTestSize());
        }
        return stepCount;
    }

    private boolean aMatchingTestExists(TestResult expectedResult, TestType testType) {
        return this.countTestsWithResult(expectedResult, testType) > 0;
    }

    protected int countTestsWithResult(TestResult expectedResult, TestType testType) {
        return this.outcomes.stream().mapToInt(outcome -> outcome.countResults(expectedResult, testType)).sum();
    }

    private Integer getEstimatedTotalStepCount() {
        int estimatedTotalSteps = this.getStepCount() + this.estimatedUnimplementedStepCount();
        return estimatedTotalSteps == 0 ? DEFAULT_ESTIMATED_TOTAL_STEPS : estimatedTotalSteps;
    }

    private Integer estimatedUnimplementedStepCount() {
        return (int)Math.round(this.getAverageTestSize() * (double)this.totalUnimplementedTests());
    }

    public double getAverageTestSize() {
        if (this.totalImplementedTests() > 0) {
            return (double)this.getStepCount() / (double)this.totalImplementedTests();
        }
        return this.estimatedAverageStepCount;
    }

    private int totalUnimplementedTests() {
        return this.getTotal() - this.totalImplementedTests();
    }

    public int getTestCount() {
        return this.outcomes.stream().mapToInt(TestOutcome::getTestCount).sum();
    }

    private int totalImplementedTests() {
        return this.outcomes.stream().mapToInt(TestOutcome::getImplementedTestCount).sum();
    }

    public boolean hasDataDrivenTests() {
        return this.outcomes.stream().anyMatch(TestOutcome::isDataDriven);
    }

    public int getTotalDataRows() {
        return this.outcomes.stream().mapToInt(TestOutcome::getDataTableRowCount).sum();
    }

    public TestOutcomeMatcher findMatchingTags() {
        return new TestOutcomeMatcher(this);
    }

    public static final class TestOutcomeMatcher {
        private final TestOutcomes outcomes;
        private List<Matcher<String>> nameMatcher = null;
        private Matcher<String> typeMatcher = null;

        public TestOutcomeMatcher(TestOutcomes outcomes) {
            this.outcomes = outcomes;
        }

        public TestOutcomeMatcher withName(Matcher<String> nameMatcher) {
            this.nameMatcher = NewList.of(nameMatcher);
            return this;
        }

        public TestOutcomeMatcher withNameIn(List<Matcher<String>> nameMatchers) {
            this.nameMatcher = new ArrayList<Matcher<String>>(nameMatchers);
            return this;
        }

        public TestOutcomeMatcher withName(String name) {
            return this.withName((Matcher<String>)Matchers.is((Object)name));
        }

        public TestOutcomeMatcher withType(Matcher<String> typeMatcher) {
            this.typeMatcher = typeMatcher;
            return this;
        }

        public TestOutcomeMatcher withType(String type) {
            return this.withType((Matcher<String>)Matchers.is((Object)type));
        }

        public List<TestTag> list() {
            return this.outcomes.getTags().stream().filter(this::compatibleTag).sorted().collect(Collectors.toList());
        }

        private boolean compatibleTag(TestTag tag) {
            if (this.nameMatcher != null && !this.matches(tag.getName(), this.nameMatcher)) {
                return false;
            }
            return this.typeMatcher == null || this.typeMatcher.matches((Object)tag.getType());
        }

        private boolean matches(String name, List<Matcher<String>> matchers) {
            return matchers.stream().anyMatch(match -> match.matches((Object)name));
        }
    }

    public class OutcomeProportionStepCounter
    extends TestOutcomeCounter {
        public OutcomeProportionStepCounter(TestType testType) {
            super(testType);
        }

        public Double withResult(String expectedResult) {
            return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
        }

        public Double withResult(TestResult expectedResult) {
            int matchingStepCount = TestOutcomes.this.countStepsWithResult(expectedResult, this.testType);
            return (double)matchingStepCount / (double)TestOutcomes.this.getEstimatedTotalStepCount().intValue();
        }

        public Double withIndeterminateResult() {
            int pendingCount = TestOutcomes.this.countStepsWithResult(TestResult.PENDING, this.testType);
            int ignoredCount = TestOutcomes.this.countStepsWithResult(TestResult.IGNORED, this.testType);
            int skippedCount = TestOutcomes.this.countStepsWithResult(TestResult.SKIPPED, this.testType);
            return (double)(pendingCount + skippedCount + ignoredCount) / (double)TestOutcomes.this.getEstimatedTotalStepCount().intValue();
        }
    }

    public class OutcomeProportionCounter
    extends TestOutcomeCounter {
        public OutcomeProportionCounter(TestType testType) {
            super(testType);
        }

        public Double withResult(String expectedResult) {
            if (!TestResult.existsWithName(expectedResult.toUpperCase())) {
                return 0.0;
            }
            return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
        }

        public Double withResult(TestResult testResult) {
            int matchingTestCount = TestOutcomes.this.countTestsWithResult(testResult, this.testType);
            return TestOutcomes.this.getTotal() == 0 ? 0.0 : (double)matchingTestCount / (double)TestOutcomes.this.getTotal();
        }

        public Double withIndeterminateResult() {
            int pendingCount = TestOutcomes.this.countTestsWithResult(TestResult.PENDING, this.testType);
            int ignoredCount = TestOutcomes.this.countTestsWithResult(TestResult.IGNORED, this.testType);
            int skippedCount = TestOutcomes.this.countTestsWithResult(TestResult.SKIPPED, this.testType);
            return TestOutcomes.this.getTotal() == 0 ? 0.0 : (double)(pendingCount + skippedCount + ignoredCount) / (double)TestOutcomes.this.getTotal();
        }

        public Double withFailureOrError() {
            return this.withResult(TestResult.FAILURE) + this.withResult(TestResult.ERROR) + this.withResult(TestResult.COMPROMISED);
        }
    }

    private static class TagFinder {
        private final String tagType;

        private TagFinder(String tagType) {
            this.tagType = tagType.toLowerCase();
        }

        Stream<TestTag> from(TestOutcome outcome) {
            return outcome.getAllTags().stream().filter(tag -> tag.normalisedType().equals(this.tagType));
        }

        List<TestTag> in(TestOutcome testOutcome) {
            return testOutcome.getAllTags().stream().filter(tag -> tag.normalisedType().equals(this.tagType)).collect(Collectors.toList());
        }
    }
}

