/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.annotations;

import com.google.common.reflect.ClassPath;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thucydides.core.util.JUnitAdapter;

public class ClassInfoAnnotations {
    private final ClassPath.ClassInfo classInfo;

    public ClassInfoAnnotations(ClassPath.ClassInfo classInfo) {
        this.classInfo = classInfo;
    }

    public static ClassInfoAnnotations theClassDefinedIn(ClassPath.ClassInfo classInfo) {
        return new ClassInfoAnnotations(classInfo);
    }

    public boolean hasAnAnnotation(Class<? extends Annotation> ... annotationClasses) {
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            if (this.classInfo.load().getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasAPackageAnnotation(Class<? extends Annotation> ... annotationClasses) {
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            if (this.classInfo.load().getPackage().getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }

    public boolean containsTests() {
        return this.allMethods().stream().anyMatch(JUnitAdapter::isTestMethod);
    }

    private Set<Method> allMethods() {
        HashSet<Method> allMethods = new HashSet<Method>();
        allMethods.addAll(Arrays.asList(this.classInfo.load().getMethods()));
        allMethods.addAll(Arrays.asList(this.classInfo.load().getDeclaredMethods()));
        return allMethods;
    }
}

