/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.resources;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.resources.ResourceCopyingError;

public class ResourceList {
    private static final List<String> UNREQUIRED_FILES = NewList.of("pom.xml");
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");
    final Pattern pattern;
    final String resourceDirectory;
    private static final long TO_GIVE_THE_OTHER_PROCESS_TIME_TO_RELEASE_THE_ZIP = 500L;

    protected ResourceList(String resourceDirectory, Pattern pattern) {
        this.pattern = pattern;
        this.resourceDirectory = resourceDirectory;
    }

    public static ResourceList forResources(String resourceDirectory, Pattern pattern) {
        return new ResourceList(resourceDirectory, pattern);
    }

    public Collection<String> list() {
        ArrayList<String> resources = new ArrayList<String>();
        resources.addAll(this.systemPropertiesClasspathElements());
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            this.addResourcesFromUrlClassLoader(resources, (URLClassLoader)classLoader);
        }
        return resources;
    }

    private void addResourcesFromUrlClassLoader(ArrayList<String> resources, URLClassLoader classLoader) {
        URL[] classPathElements;
        for (URL classPathElement : classPathElements = classLoader.getURLs()) {
            if (!this.isASerenityResourceJarFile(classPathElement.getFile())) continue;
            resources.addAll(this.getResources(classPathElement.getFile(), this.pattern));
        }
    }

    private boolean isASerenityResourceJarFile(String file) {
        return file.contains("serenity-core") || file.contains("serenity-report-resources");
    }

    private Collection<String> systemPropertiesClasspathElements() {
        String[] classPathElements;
        ArrayList<String> resources = new ArrayList<String>();
        String classPath = System.getProperty("java.class.path", ".");
        for (String element : classPathElements = classPath.split(PATH_SEPARATOR)) {
            resources.addAll(this.getResources(element, this.pattern));
        }
        return resources;
    }

    private Collection<String> getResources(String element, Pattern pattern) {
        ArrayList<String> resources = new ArrayList<String>();
        File file = new File(element);
        if (this.isAJarFile(file)) {
            resources.addAll(this.getResourcesFromJarFile(file, pattern));
        } else {
            resources.addAll(this.getResourcesFromDirectory(file, pattern));
        }
        return this.removeUnnecessaryFilesFrom(resources);
    }

    private Collection<String> removeUnnecessaryFilesFrom(Collection<String> resources) {
        ArrayList<String> cleanedResources = new ArrayList<String>();
        for (String filepath : resources) {
            String filename = new File(filepath).getName();
            if (UNREQUIRED_FILES.contains(filename)) continue;
            cleanedResources.add(filepath);
        }
        return cleanedResources;
    }

    private boolean isAJarFile(File file) {
        return !file.isDirectory() && file.getName().endsWith(".jar");
    }

    protected ZipFile zipFileFor(File file) throws IOException {
        return this.loadZipFileWithMaxRetries(file, 3);
    }

    private ZipFile loadZipFileWithMaxRetries(File file, int maxRetries) throws IOException {
        try {
            return new ZipFile(file);
        }
        catch (ZipException resourceFileLockedOrSomething) {
            if (maxRetries == 0) {
                throw resourceFileLockedOrSomething;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException shouldNeverHappen) {
                throw new RuntimeException(shouldNeverHappen);
            }
            return this.loadZipFileWithMaxRetries(file, maxRetries - 1);
        }
    }

    private Collection<String> getResourcesFromJarFile(File file, Pattern pattern) {
        ArrayList<String> matchingResources;
        block15: {
            matchingResources = new ArrayList<String>();
            try {
                if (!file.exists()) break block15;
                try (ZipFile zf = this.zipFileFor(file);){
                    Enumeration<? extends ZipEntry> e = zf.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        String fileName = entry.getName();
                        if (!this.resourceDirectory.isEmpty() && !fileName.contains(this.resourceDirectory) || !pattern.matcher(fileName).matches()) continue;
                        matchingResources.add(fileName);
                    }
                }
            }
            catch (IOException e) {
                throw new ResourceCopyingError("Couldn't close the zip file " + file, e);
            }
        }
        return matchingResources;
    }

    private Collection<String> getResourcesFromDirectory(File directory, Pattern pattern) {
        ArrayList<String> retval = new ArrayList<String>();
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory() && file.exists()) {
                    retval.addAll(this.getResourcesFromDirectory(file, pattern));
                    continue;
                }
                String fileName = "";
                if (!file.exists()) continue;
                try {
                    fileName = file.getCanonicalPath();
                    boolean accept = pattern.matcher(fileName).matches();
                    if (!accept) continue;
                    retval.add(fileName);
                }
                catch (IOException e) {
                    throw new ResourceCopyingError("Could not read from the JAR file " + fileName, e);
                }
            }
        }
        return retval;
    }
}

