/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewMap;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.PropertiesUtil;
import net.thucydides.core.util.SystemEnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class MockEnvironmentVariables
implements EnvironmentVariables {
    private Properties properties = new Properties();
    private Map<String, String> values = new HashMap<String, String>();

    public MockEnvironmentVariables() {
        this.properties.setProperty("user.home", System.getProperty("user.home"));
        this.properties.setProperty("feature.file.encoding", "UTF-8");
        if (this.localEnvironment().getProperty("phantomjs.binary.path") != null) {
            this.properties.setProperty("phantomjs.binary.path", this.localEnvironment().getProperty("phantomjs.binary.path"));
        }
        if (this.localEnvironment().getProperty("webdriver.chrome.driver") != null) {
            this.properties.setProperty("webdriver.chrome.driver", this.localEnvironment().getProperty("webdriver.chrome.driver"));
        }
    }

    private EnvironmentVariables localEnvironment() {
        return ConfiguredEnvironment.getEnvironmentVariables();
    }

    protected MockEnvironmentVariables(Properties properties) {
        this.properties = PropertiesUtil.copyOf(properties);
    }

    protected MockEnvironmentVariables(Properties properties, Map<String, String> values) {
        this.properties = PropertiesUtil.copyOf(properties);
        this.values = NewMap.copyOf(values);
    }

    public static EnvironmentVariables fromSystemEnvironment() {
        return new MockEnvironmentVariables(SystemEnvironmentVariables.createEnvironmentVariables().getProperties());
    }

    public boolean propertySetIsEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public String getValue(String name) {
        return this.values.get(name);
    }

    @Override
    public String getValue(Enum<?> property) {
        return this.getValue(property.toString());
    }

    @Override
    public String getValue(String name, String defaultValue) {
        return this.values.get(name) == null ? defaultValue : this.values.get(name);
    }

    @Override
    public String getValue(Enum<?> property, String defaultValue) {
        return this.getValue(property.toString(), defaultValue);
    }

    @Override
    public Integer getPropertyAsInteger(String name, Integer defaultValue) {
        String value = (String)this.properties.get(name);
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(this.properties.getProperty(name));
        }
        return defaultValue;
    }

    @Override
    public Integer getPropertyAsInteger(Enum<?> property, Integer defaultValue) {
        return this.getPropertyAsInteger(property.toString(), defaultValue);
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (this.properties.getProperty(name) == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(this.properties.getProperty(name, "false"));
    }

    @Override
    public Boolean getPropertyAsBoolean(Enum<?> property, boolean defaultValue) {
        return this.getPropertyAsBoolean(property.toString(), defaultValue);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    @Override
    public Optional<String> optionalProperty(String name) {
        return Optional.ofNullable(this.getProperty(name));
    }

    @Override
    public String getProperty(Enum<?> property) {
        return this.getProperty(property.toString());
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    @Override
    public String getProperty(Enum<?> property, String defaultValue) {
        return this.getProperty(property.toString(), defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    @Override
    public void setProperties(Map<String, String> newProperties) {
        this.properties.putAll(newProperties);
    }

    @Override
    public void clearProperty(String name) {
        this.properties.remove(name);
    }

    @Override
    public EnvironmentVariables copy() {
        return new MockEnvironmentVariables(this.properties, this.values);
    }

    @Override
    public List<String> getKeys() {
        return this.properties.keySet().stream().map(Object::toString).collect(Collectors.toList());
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    @Override
    public Properties getPropertiesWithPrefix(String prefix) {
        return new SystemEnvironmentVariables(this.properties, this.values).getPropertiesWithPrefix(prefix);
    }

    @Override
    public boolean aValueIsDefinedFor(Enum<?> property) {
        return this.properties.contains(property.toString());
    }

    @Override
    public boolean aValueIsDefinedFor(String property) {
        return this.properties.contains(property);
    }

    @Override
    public String injectSystemPropertiesInto(String value) {
        return value;
    }

    @Override
    public Map<String, String> asMap() {
        HashMap<String, String> environmentValues = new HashMap<String, String>();
        this.values.keySet().forEach(key -> environmentValues.put((String)key, this.values.get(key)));
        this.properties.stringPropertyNames().forEach(key -> environmentValues.put((String)key, this.properties.getProperty((String)key)));
        return environmentValues;
    }

    public void setValue(String name, String value) {
        this.values.put(name, value);
    }
}

