/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.io.File;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class FilePathParser {
    private final EnvironmentVariables environmentVariables;

    public FilePathParser(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public String getInstanciatedPath(String path) {
        if (path == null) {
            return path;
        }
        String localizedPath = this.operatingSystemLocalized(path);
        localizedPath = this.injectVariable(localizedPath, "HOME", this.valueDefinedIn(this.environmentVariables, "user.home"));
        localizedPath = this.injectVariable(localizedPath, "user.home", this.valueDefinedIn(this.environmentVariables, "user.home"));
        localizedPath = this.injectVariable(localizedPath, "USERDIR", this.valueDefinedIn(this.environmentVariables, "user.dir"));
        localizedPath = this.injectVariable(localizedPath, "USERPROFILE", this.valueDefinedIn(this.environmentVariables, "user.home"));
        localizedPath = this.injectVariable(localizedPath, "user.dir", this.valueDefinedIn(this.environmentVariables, "user.dir"));
        localizedPath = this.injectVariable(localizedPath, "APPDATA", this.valueDefinedIn(this.environmentVariables, "APPDATA"));
        localizedPath = this.injectVariable(localizedPath, "DATADIR", this.valueDefinedIn(this.environmentVariables, "serenity.data.dir"));
        return localizedPath;
    }

    private String valueDefinedIn(EnvironmentVariables environmentVariables, String propertyName) {
        return EnvironmentSpecificConfiguration.from(environmentVariables).getOptionalProperty(propertyName).orElse(environmentVariables.getValue(propertyName));
    }

    private String operatingSystemLocalized(String testDataSource) {
        return StringUtils.replace((String)testDataSource, (String)this.getFileSeparatorToReplace(), (String)this.getFileSeparator());
    }

    private String injectVariable(String path, String variable, String directory) {
        if (StringUtils.isNotEmpty((CharSequence)directory)) {
            path = StringUtils.replace((String)path, (String)("$" + variable), (String)directory);
            path = StringUtils.replace((String)path, (String)("%" + variable + "%"), (String)directory);
            return StringUtils.replace((String)path, (String)("${" + variable + "}"), (String)directory);
        }
        return path;
    }

    protected String getFileSeparator() {
        return File.separator;
    }

    protected String getFileSeparatorToReplace() {
        return this.getFileSeparator().equals("/") ? "\\" : "/";
    }
}

