/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import com.google.common.base.Splitter;
import cucumber.runtime.io.MultiLoader;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import gherkin.ParserException;
import gherkin.ast.Feature;
import gherkin.ast.GherkinDocument;
import gherkin.ast.Scenario;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Tag;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.html.CucumberTagConverter;
import net.thucydides.core.requirements.model.Narrative;
import net.thucydides.core.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.core.requirements.model.cucumber.DescriptionWithScenarioReferences;
import net.thucydides.core.requirements.model.cucumber.NarrativeFromCucumberComments;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberParser {
    private final String locale;
    private final String encoding;
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberParser.class);
    private static final String CUCUMBER_4_FEATURE_LOADER = "cucumber.runtime.model.FeatureLoader";
    private static final String CUCUMBER_2_FEATURE_LOADER = "cucumber.runtime.model.CucumberFeature";

    public CucumberParser() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public CucumberParser(EnvironmentVariables environmentVariables) {
        this(ThucydidesSystemProperty.FEATURE_FILE_LANGUAGE.from(environmentVariables, "en"), environmentVariables);
    }

    public CucumberParser(String locale, EnvironmentVariables environmentVariables) {
        this.locale = locale;
        this.encoding = ThucydidesSystemProperty.FEATURE_FILE_ENCODING.from(environmentVariables, Charset.defaultCharset().name());
    }

    public Optional<AnnotatedFeature> loadFeature(File narrativeFile) {
        if (narrativeFile == null) {
            return Optional.empty();
        }
        if (!narrativeFile.exists()) {
            return Optional.empty();
        }
        ArrayList<String> listOfFiles = new ArrayList<String>();
        listOfFiles.add(narrativeFile.getAbsolutePath());
        MultiLoader multiLoader = new MultiLoader(CucumberParser.class.getClassLoader());
        List<CucumberFeature> cucumberFeatures = this.loadCucumberFeatures(multiLoader, listOfFiles);
        try {
            if (cucumberFeatures.size() == 0) {
                return Optional.empty();
            }
            CucumberFeature cucumberFeature = cucumberFeatures.get(0);
            List scenarios = cucumberFeature.getGherkinFeature().getFeature().getChildren();
            GherkinDocument gherkinDocument = cucumberFeature.getGherkinFeature();
            String descriptionInComments = NarrativeFromCucumberComments.in(gherkinDocument.getComments());
            if (this.featureFileCouldNotBeReadFor(gherkinDocument.getFeature())) {
                return Optional.empty();
            }
            return Optional.of(new AnnotatedFeature(gherkinDocument.getFeature(), gherkinDocument.getFeature().getChildren(), descriptionInComments));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    private List<CucumberFeature> loadCucumberFeatures(MultiLoader multiLoader, List<String> listOfFiles) {
        try {
            Class<?> featureLoaderClass = CucumberParser.class.getClassLoader().loadClass(CUCUMBER_4_FEATURE_LOADER);
            Method load = featureLoaderClass.getMethod("load", List.class);
            Object featureLoader = featureLoaderClass.getConstructor(ResourceLoader.class).newInstance(multiLoader);
            List uriList = listOfFiles.stream().map(filePath -> new File((String)filePath).toURI()).collect(Collectors.toList());
            return (List)load.invoke(featureLoader, uriList);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cucumber426Exception) {
            LOGGER.debug("Found no Cucumber 4.2.6 class cucumber.runtime.model.FeatureLoader try Cucumber 4.2.0 ");
            try {
                Class<?> featureLoaderClass = CucumberParser.class.getClassLoader().loadClass(CUCUMBER_4_FEATURE_LOADER);
                Method load = featureLoaderClass.getMethod("load", List.class);
                Object featureLoader = featureLoaderClass.getConstructor(ResourceLoader.class).newInstance(multiLoader);
                return (List)load.invoke(featureLoader, listOfFiles);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cucumber420Exception) {
                LOGGER.debug("Found no Cucumber 4.2.0 class cucumber.runtime.model.FeatureLoader try Cucumber 2.x.x ");
                try {
                    Class<?> featureLoaderClass = CucumberParser.class.getClassLoader().loadClass(CUCUMBER_2_FEATURE_LOADER);
                    Method load = featureLoaderClass.getMethod("load", ResourceLoader.class, List.class);
                    return (List)load.invoke(null, multiLoader, listOfFiles);
                }
                catch (InvocationTargetException gherkinParserException) {
                    throw new SerenityManagedException(gherkinParserException.getTargetException());
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException cucumber2Exception) {
                    LOGGER.error("Found no Cucumber 2.x.x class cucumber.runtime.model.CucumberFeature failed loading CucumberFeatures ", (Throwable)cucumber2Exception);
                    LOGGER.error("Found neither Cucumber 2.x.x nor Cucumber 4.x runtime in classpath");
                    throw new RuntimeException("Found neither Cucumber 2.x.x nor Cucumber 4.x runtime in classpath", cucumber2Exception);
                }
            }
        }
        catch (ParserException gherkinParsingException) {
            LOGGER.error("Syntax error in feature file from " + listOfFiles, (Throwable)gherkinParsingException);
            throw new RuntimeException("Syntax error in feature file from " + listOfFiles, gherkinParsingException);
        }
    }

    public Optional<Narrative> loadFeatureNarrative(File narrativeFile) {
        Optional<AnnotatedFeature> loadedFeature = this.loadFeature(narrativeFile);
        if (!loadedFeature.isPresent()) {
            return Optional.empty();
        }
        Feature feature = loadedFeature.get().getFeature();
        String cardNumber = this.findCardNumberInTags(this.tagsDefinedIn(feature));
        List<String> versionNumbers = this.findVersionNumberInTags(this.tagsDefinedIn(feature));
        String title = feature.getName();
        String text = this.descriptionWithScenarioReferencesFrom(feature);
        String id = this.getIdFromName(title);
        Set requirementTags = feature.getTags().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
        requirementTags.add(TestTag.withName(title).andType("feature"));
        HashMap<String, Collection<TestTag>> scenarioTags = new HashMap<String, Collection<TestTag>>();
        feature.getChildren().forEach(scenarioDefinition -> {
            if (scenarioDefinition instanceof ScenarioOutline) {
                scenarioTags.put(scenarioDefinition.getName(), CucumberTagConverter.toSerenityTags(((ScenarioOutline)scenarioDefinition).getTags()));
                ((ScenarioOutline)scenarioDefinition).getExamples().forEach(example -> scenarioTags.put(scenarioDefinition.getName() + example.getLocation(), CucumberTagConverter.toSerenityTags(example.getTags())));
            } else {
                scenarioTags.put(scenarioDefinition.getName(), this.tagsFrom((ScenarioDefinition)scenarioDefinition));
            }
        });
        List<String> scenarios = feature.getChildren().stream().map(ScenarioDefinition::getName).collect(Collectors.toList());
        return Optional.of(new Narrative(Optional.ofNullable(title), Optional.ofNullable(id), Optional.ofNullable(cardNumber), versionNumbers, "feature", text != null ? text : "", new ArrayList<TestTag>(requirementTags), scenarios, scenarioTags));
    }

    private Collection<TestTag> tagsFrom(ScenarioDefinition scenarioDefinition) {
        if (scenarioDefinition instanceof Scenario) {
            return this.asSerenityTags(((Scenario)scenarioDefinition).getTags());
        }
        if (scenarioDefinition instanceof ScenarioOutline) {
            HashSet<TestTag> outlineTags = new HashSet<TestTag>(this.asSerenityTags(((ScenarioOutline)scenarioDefinition).getTags()));
            ((ScenarioOutline)scenarioDefinition).getExamples().forEach(examples -> outlineTags.addAll(this.asSerenityTags(examples.getTags())));
            return outlineTags;
        }
        return new ArrayList<TestTag>();
    }

    private Set<TestTag> asSerenityTags(List<Tag> gherkinTags) {
        return gherkinTags.stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
    }

    private String descriptionWithScenarioReferencesFrom(Feature feature) {
        if (feature.getDescription() == null) {
            return "";
        }
        return Arrays.stream(feature.getDescription().split("\\r?\\n")).map(line -> DescriptionWithScenarioReferences.from(feature).forText((String)line)).collect(Collectors.joining(System.lineSeparator()));
    }

    private String getIdFromName(String name) {
        return name.replaceAll("[\\s_]", "-").toLowerCase();
    }

    private boolean featureFileCouldNotBeReadFor(Feature feature) {
        return feature == null;
    }

    private List<Tag> tagsDefinedIn(Feature feature) {
        return feature.getTags();
    }

    private String findCardNumberInTags(List<Tag> tags) {
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@issue:")) {
                return tag.getName().replaceAll("@issue:", "");
            }
            if (!tag.getName().toLowerCase().startsWith("@issues:")) continue;
            String issueNumberList = tag.getName().replaceAll("@issues:", "");
            List issueNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)issueNumberList);
            return (String)issueNumberTags.get(0);
        }
        return null;
    }

    private List<String> findVersionNumberInTags(List<Tag> tags) {
        ArrayList<String> versionNumbers = new ArrayList<String>();
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@version:")) {
                versionNumbers.add(tag.getName().replaceAll("@version:", ""));
                continue;
            }
            if (!tag.getName().toLowerCase().startsWith("@versions:")) continue;
            String versionNumberList = tag.getName().replaceAll("@versions:", "");
            List versionNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)versionNumberList);
            versionNumbers.addAll(versionNumberTags);
        }
        return versionNumbers;
    }
}

