/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class LastElement {
    static Map<LastElementStrategy, LastElementFinder> LAST_ELEMENT_FINDER = new HashMap<LastElementStrategy, LastElementFinder>();

    public static String of(String path) {
        return LAST_ELEMENT_FINDER.get((Object)LastElement.forPathType(path)).lastElementIn(path);
    }

    private static LastElementStrategy forPathType(String path) {
        if (path.toLowerCase().endsWith(".feature")) {
            return LastElementStrategy.forFeatureOrStoryFiles;
        }
        if (path.toLowerCase().endsWith(".story")) {
            return LastElementStrategy.forFeatureOrStoryFiles;
        }
        return LastElementStrategy.forTestCases;
    }

    private static List<String> elementsOf(String path) {
        return Splitter.on((Pattern)Pattern.compile("[\\.|/]")).splitToList((CharSequence)path);
    }

    private static String withoutFeatureFileSuffixes(String path) {
        if (path.endsWith(".feature")) {
            return path.substring(0, path.length() - 8);
        }
        if (path.endsWith(".story")) {
            return path.substring(0, path.length() - 6);
        }
        return path;
    }

    static {
        LAST_ELEMENT_FINDER.put(LastElementStrategy.forTestCases, new LastElementOfATestCase());
        LAST_ELEMENT_FINDER.put(LastElementStrategy.forFeatureOrStoryFiles, new LastElementOfAFeatureOrStoryFile());
    }

    private static class LastElementOfATestCase
    implements LastElementFinder {
        private LastElementOfATestCase() {
        }

        @Override
        public String lastElementIn(String path) {
            List pathElements = LastElement.elementsOf(path);
            return pathElements.isEmpty() ? "" : (String)pathElements.get(pathElements.size() - 1);
        }
    }

    private static class LastElementOfAFeatureOrStoryFile
    implements LastElementFinder {
        private LastElementOfAFeatureOrStoryFile() {
        }

        @Override
        public String lastElementIn(String path) {
            ArrayList pathElements = new ArrayList(LastElement.elementsOf(LastElement.withoutFeatureFileSuffixes(path)));
            if (pathElements.isEmpty()) {
                return "";
            }
            pathElements.remove(pathElements.size() - 1);
            return pathElements.isEmpty() ? "" : (String)pathElements.get(pathElements.size() - 1);
        }
    }

    static enum LastElementStrategy {
        forTestCases,
        forFeatureOrStoryFiles;

    }

    static interface LastElementFinder {
        public String lastElementIn(String var1);
    }
}

