/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.html.CucumberTagConverter;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class CucumberCompatibleFilter {
    protected final EnvironmentVariables environmentVariables;

    public CucumberCompatibleFilter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    protected Expression cucumberTagExpressionUsing(ThucydidesSystemProperty tagProperty) {
        String tagExpression = this.cucumberTagOptions().orElse(tagProperty.optionalFrom(this.environmentVariables).orElse("")).replace("@", "").replace("=", ":").toLowerCase();
        TagExpressionParser parser = new TagExpressionParser();
        return parser.parse(tagExpression);
    }

    protected Optional<String> cucumberTagOptions() {
        String cucumberFilterTags = this.environmentVariables.getProperty("cucumber.filter.tags");
        if (StringUtils.isNotEmpty((CharSequence)cucumberFilterTags)) {
            return Optional.of(StringUtils.strip((String)cucumberFilterTags, (String)"'"));
        }
        String cucumberOptions = this.environmentVariables.getProperty("cucumber.options");
        if (StringUtils.isNotEmpty((CharSequence)cucumberOptions) && cucumberOptions.contains("--tags ")) {
            return this.getTagsFromCucumberOptions(cucumberOptions);
        }
        return Optional.empty();
    }

    private Optional<String> getTagsFromCucumberOptions(String cucumberOptions) {
        int tagsFlag = cucumberOptions.indexOf("--tags ");
        int tagsOptionStart = tagsFlag + 7;
        int nextTagOptionStart = cucumberOptions.indexOf("--", tagsOptionStart);
        String tagOption = nextTagOptionStart > 0 ? cucumberOptions.substring(tagsOptionStart, nextTagOptionStart) : cucumberOptions.substring(tagsOptionStart);
        String tagOptionsWithoutAtSigns = StringUtils.strip((String)tagOption, (String)"'");
        return Optional.of(tagOptionsWithoutAtSigns);
    }

    public boolean matchesTags(List<TestTag> testTags) {
        Expression expectedTags = this.cucumberTagExpressionUsing(ThucydidesSystemProperty.TAGS);
        List<String> tagValues = CucumberTagConverter.toStrings(testTags);
        return expectedTags.evaluate(tagValues);
    }

    public boolean matches(List<String> testTags) {
        Expression expectedTags = this.cucumberTagExpressionUsing(ThucydidesSystemProperty.TAGS);
        return expectedTags.evaluate(testTags);
    }
}

