/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.matchers.dates;

import java.util.Collection;
import net.thucydides.core.matchers.dates.DateComparator;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;

public class DateTimeCollectionContainsSameDatesMatcher
extends TypeSafeMatcher<Collection<DateTime>> {
    private final Collection<DateTime> expectedDates;

    public DateTimeCollectionContainsSameDatesMatcher(Collection<DateTime> expectedDates) {
        this.expectedDates = expectedDates;
    }

    public boolean matchesSafely(Collection<DateTime> dates) {
        if (dates.size() != this.expectedDates.size()) {
            return false;
        }
        for (DateTime expectedDate : this.expectedDates) {
            if (this.hasIdenticalDate(expectedDate, dates)) continue;
            return false;
        }
        return true;
    }

    private boolean hasIdenticalDate(DateTime expectedDate, Collection<DateTime> dates) {
        for (DateTime date : dates) {
            if (!DateComparator.sameDate(date, expectedDate)) continue;
            return true;
        }
        return false;
    }

    public void describeTo(Description description) {
        description.appendText("a collection of dates containing ");
        description.appendValueList("[", ",", "]", this.expectedDates);
    }
}

