/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.releases;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseManager {
    private static final String DEFAULT_RELEASE_TYPES = "Release,Iteration:Sprint";
    private List<String> releaseTypes;
    private ReportNameProvider reportNameProvider;
    private RequirementsService requirementsService;
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTagProvider.class);
    List<Release> NO_PARENTS = new ArrayList<Release>();
    private ReportNameProvider defaultNameProvider;

    public ReleaseManager(EnvironmentVariables environmentVariables, ReportNameProvider reportNameProvider) {
        this(environmentVariables, reportNameProvider, (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    public ReleaseManager(EnvironmentVariables environmentVariables, ReportNameProvider reportNameProvider, RequirementsService requirementsService) {
        this.reportNameProvider = reportNameProvider;
        this.requirementsService = requirementsService;
        String typeValues = ThucydidesSystemProperty.THUCYDIDES_RELEASE_TYPES.from(environmentVariables, DEFAULT_RELEASE_TYPES);
        this.releaseTypes = Splitter.on((String)",").trimResults().splitToList((CharSequence)typeValues);
    }

    public String getJSONReleasesFrom(TestOutcomes testOutcomes) {
        List<Release> releases = this.getReleasesFrom(testOutcomes);
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        Gson gson = builder.create();
        return gson.toJson(releases);
    }

    public String getJSONReleasesFrom(Release release) {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        Gson gson = builder.create();
        return gson.toJson(NewList.of(release));
    }

    public List<Release> getFlattenedReleasesFrom(TestOutcomes testOutcomes) {
        return this.flattened(this.getReleasesFrom(testOutcomes));
    }

    private List<Release> flattened(List<Release> releases) {
        ArrayList<Release> flattenedReleases = new ArrayList<Release>();
        for (Release release : releases) {
            flattenedReleases.add(release);
            flattenedReleases.addAll(this.flattened(release.getChildren()));
        }
        return NewList.copyOf(flattenedReleases);
    }

    public List<Release> getReleasesFrom(TestOutcomes testOutcomes) {
        List<Release> releases = this.requirementsService.getReleasesFromRequirements();
        LOGGER.debug("Loaded Releases: " + releases);
        this.enrichOutcomesWithReleaseTags(testOutcomes.getOutcomes());
        if (releases.isEmpty()) {
            releases = this.extractReleasesFromTestOutcomeAnnotations(testOutcomes);
        }
        return NewList.copyOf(releases);
    }

    private List<Release> extractReleasesFromTestOutcomeAnnotations(TestOutcomes testOutcomes) {
        ArrayList<Release> releases = new ArrayList<Release>();
        List<TestTag> releaseTags = testOutcomes.findMatchingTags().withType("version").withNameIn(this.matchingNames(this.releaseTypes.get(0))).list();
        for (TestTag tag : releaseTags) {
            releases.add(this.extractReleaseFor(tag, testOutcomes.withTag(tag), 1, this.NO_PARENTS));
        }
        return releases;
    }

    private List<Matcher<String>> matchingNames(String possibleNames) {
        ArrayList<Matcher<String>> matchers = new ArrayList<Matcher<String>>();
        List nameCandidates = Splitter.on((String)":").trimResults().splitToList((CharSequence)possibleNames.toLowerCase());
        for (String nameCandidate : nameCandidates) {
            matchers.add((Matcher<String>)Matchers.containsString((String)nameCandidate));
            matchers.add((Matcher<String>)Matchers.containsString((String)StringUtils.capitalize((String)nameCandidate)));
            matchers.add((Matcher<String>)Matchers.containsString((String)StringUtils.lowerCase((String)nameCandidate)));
        }
        return matchers;
    }

    public List<RequirementOutcome> enrichRequirementsOutcomesWithReleaseTags(List<? extends RequirementOutcome> outcomes) {
        ArrayList<RequirementOutcome> requirementOutcomes = new ArrayList<RequirementOutcome>();
        for (RequirementOutcome requirementOutcome : outcomes) {
            List<TestOutcome> enrichedOutcomes = this.enrichOutcomesWithReleaseTags(requirementOutcome.getTestOutcomes().getOutcomes());
            requirementOutcomes.add(requirementOutcome.withTestOutcomes(TestOutcomes.of(enrichedOutcomes)));
        }
        return requirementOutcomes;
    }

    public List<TestOutcome> enrichOutcomesWithReleaseTags(List<? extends TestOutcome> outcomes) {
        ArrayList<TestOutcome> enrichedOutcomes = new ArrayList<TestOutcome>();
        for (TestOutcome testOutcome : outcomes) {
            List<String> releaseVersions = this.requirementsService.getReleaseVersionsFor(testOutcome);
            testOutcome.addTags(this.releaseTagsFrom(releaseVersions));
            testOutcome.addVersions(releaseVersions);
            enrichedOutcomes.add(testOutcome);
        }
        return enrichedOutcomes;
    }

    private List<TestTag> releaseTagsFrom(List<String> releaseVersions) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        for (String releaseVersion : releaseVersions) {
            tags.add(TestTag.withName(releaseVersion).andType("version"));
        }
        return tags;
    }

    private Release extractReleaseFor(TestTag releaseTag, TestOutcomes testOutcomes, int level, List<Release> parents) {
        Release release = new Release(releaseTag);
        String reportName = this.reportNameProvider.forRelease(release);
        release = release.withReport(reportName).withParents(parents);
        List<Release> ancestors = this.ancestorsFor(release);
        if (level < this.releaseTypes.size()) {
            String childReleaseType = this.releaseTypes.get(level);
            List<TestTag> childReleaseTags = testOutcomes.findMatchingTags().withType("version").withNameIn(this.matchingNames(childReleaseType)).list();
            ArrayList<Release> children = new ArrayList<Release>();
            for (TestTag tag : childReleaseTags) {
                children.add(this.extractReleaseFor(tag, testOutcomes.withTag(tag), level + 1, ancestors));
            }
            release = release.withChildren(children);
        }
        return release;
    }

    private List<Release> ancestorsFor(Release release) {
        ArrayList<Release> ancestors = new ArrayList<Release>(release.getParents());
        ancestors.add(release);
        return ancestors;
    }

    public List<Release> extractReleasesFrom(List<List<String>> releaseVersions) {
        return this.extractReleasesOfTypeLevel(releaseVersions);
    }

    private ReportNameProvider getReportNameProvider() {
        if (this.defaultNameProvider == null) {
            this.defaultNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService);
        }
        return this.defaultNameProvider;
    }

    private List<Release> extractReleasesOfTypeLevel(List<List<String>> releaseVersions) {
        ArrayList<Release> releases = new ArrayList<Release>();
        Set<String> distinctReleases = this.getDistinct(releaseVersions);
        for (String release : distinctReleases) {
            if (!this.releaseIsOfType(release, this.releaseTypes.get(0))) continue;
            List<Release> subReleases = this.extractSubReleasesOfLevel(releaseVersions, release, 1, Collections.EMPTY_LIST);
            String reportName = this.getReportNameProvider().forRelease(release);
            this.addUniqueRelease(releases, Release.ofVersion(release).withChildren(subReleases).withReport(reportName));
        }
        Collections.sort(releases);
        return releases;
    }

    private boolean releaseIsOfType(String release, String releaseTypes) {
        for (Matcher<String> matcher : this.matchingNames(releaseTypes)) {
            if (!matcher.matches((Object)release.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private void addUniqueRelease(List<Release> releases, Release release) {
        if (!this.containsReleaseWithName(releases, release.getName())) {
            releases.add(release);
        }
    }

    private boolean containsReleaseWithName(List<Release> releases, String name) {
        for (Release release : releases) {
            if (!release.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private List<Release> extractSubReleasesOfLevel(List<List<String>> releaseVersions, String release, int level, List<Release> parents) {
        ArrayList<Release> subReleases = new ArrayList<Release>();
        if (level < this.releaseTypes.size()) {
            for (List<String> releaseVersionSet : releaseVersions) {
                if (!releaseVersionSet.contains(release)) continue;
                for (String subRelease : this.releasesOfType(this.releaseTypes.get(level), releaseVersionSet)) {
                    ArrayList<Release> ancestors = new ArrayList<Release>();
                    ancestors.add(this.lightweightReleaseNamed(release));
                    List<Release> subSubReleases = this.extractSubReleasesOfLevel(releaseVersions, subRelease, level + 1, ancestors);
                    String reportName = this.getReportNameProvider().forRelease(subRelease);
                    this.addUniqueRelease(subReleases, Release.ofVersion(subRelease).withChildren(subSubReleases).withReport(reportName).withParents(ancestors));
                }
            }
        }
        Collections.sort(subReleases);
        return subReleases;
    }

    private Release lightweightReleaseNamed(String release) {
        return Release.ofVersion(release).withReport(this.reportNameProvider.forRelease(release));
    }

    private List<String> releasesOfType(String type, List<String> releaseVersionSet) {
        ArrayList<String> matchingReleases = new ArrayList<String>();
        for (String release : releaseVersionSet) {
            if (!this.releaseIsOfType(release, type)) continue;
            matchingReleases.add(release);
        }
        return matchingReleases;
    }

    private Set<String> getDistinct(List<List<String>> releaseVersions) {
        HashSet<String> distinctVersions = new HashSet<String>();
        for (List<String> releaseVersionSets : releaseVersions) {
            distinctVersions.addAll(releaseVersionSets);
        }
        return distinctVersions;
    }
}

