/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class TagFilter {
    private final EnvironmentVariables environmentVariables;
    private final RequirementsService requirementsService;
    private final List<String> ALWAYS_HIDDEN_TAGS = Arrays.asList("manual-result", "manual-test-evidence", "manual-last-tested");

    public TagFilter(EnvironmentVariables environmentVariables) {
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
        this.environmentVariables = environmentVariables;
    }

    public List<String> filteredTagTypes(List<String> tagTypes) {
        List<String> filteredTags = new ArrayList<String>(tagTypes);
        List<String> displayedTags = this.includedTagTypes();
        if (!displayedTags.isEmpty()) {
            filteredTags = this.onlyKeepAllowedTypes(filteredTags, displayedTags);
        }
        ArrayList<String> excludedTags = new ArrayList<String>(this.excludedTagTypes());
        excludedTags.addAll(this.ALWAYS_HIDDEN_TAGS);
        return this.removeUnwantedTags(filteredTags, excludedTags);
    }

    public boolean shouldDisplayTagWithType(String tagType) {
        return !this.filteredTagTypes(Collections.singletonList(tagType)).isEmpty();
    }

    public Set<TestTag> removeTagsOfType(Set<TestTag> tags, String ... redundantTagTypes) {
        HashSet<TestTag> filteredTags = new HashSet<TestTag>();
        List<String> maskedTagTypes = Arrays.asList(redundantTagTypes);
        for (TestTag tag : tags) {
            if (maskedTagTypes.contains(tag.getType())) continue;
            filteredTags.add(tag);
        }
        return filteredTags;
    }

    public Set<TestTag> removeTagsWithName(Set<TestTag> tags, String name) {
        HashSet<TestTag> filteredTags = new HashSet<TestTag>();
        for (TestTag tag : tags) {
            if (tag.getShortName().equalsIgnoreCase(name)) continue;
            filteredTags.add(tag);
        }
        return filteredTags;
    }

    private List<String> onlyKeepAllowedTypes(List<String> tags, List<String> displayedTags) {
        ArrayList<String> allowedTags = new ArrayList<String>();
        for (String tag : tags) {
            if (!displayedTags.contains(tag.toLowerCase())) continue;
            allowedTags.add(tag);
        }
        return allowedTags;
    }

    private List<String> removeUnwantedTags(List<String> tags, List<String> unwantedTags) {
        for (String tag : unwantedTags) {
            tags.remove(tag.toLowerCase());
            tags.remove(tag.toUpperCase());
        }
        return tags;
    }

    private List<String> includedTagTypes() {
        return this.asLowercaseList(ThucydidesSystemProperty.DASHBOARD_TAG_LIST.from(this.environmentVariables));
    }

    private List<String> excludedTagTypes() {
        return this.asLowercaseList(ThucydidesSystemProperty.DASHBOARD_EXCLUDED_TAG_LIST.from(this.environmentVariables));
    }

    private List<String> asLowercaseList(String displayTags) {
        if (StringUtils.isNotEmpty((CharSequence)displayTags)) {
            return Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)displayTags.toLowerCase());
        }
        return new ArrayList<String>();
    }

    public Set<TestTag> removeHiddenTagsFrom(Set<TestTag> filteredTags) {
        List<String> hiddenTypes = this.requirementsService.getRequirementTypes();
        hiddenTypes.addAll(this.ALWAYS_HIDDEN_TAGS);
        return filteredTags.stream().filter(tag -> !hiddenTypes.contains(tag.getType())).collect(Collectors.toSet());
    }

    public Set<String> rawTagTypes() {
        return new HashSet<String>(this.asLowercaseList(ThucydidesSystemProperty.REPORT_RAW_TAG_LIST.from(this.environmentVariables)));
    }
}

