/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.flags;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.serenitybdd.core.collect.NewMap;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.flags.Flag;

public class FlagCounts {
    private final List<? extends TestOutcome> testOutcomes;
    private final Map<Flag, Integer> flagMap = new HashMap<Flag, Integer>();

    public FlagCounts(List<? extends TestOutcome> testOutcomes) {
        this.testOutcomes = testOutcomes;
    }

    public static FlagCounts in(List<? extends TestOutcome> testOutcomes) {
        return new FlagCounts(testOutcomes);
    }

    public Map<Flag, Integer> asAMap() {
        for (TestOutcome testOutcome : this.testOutcomes) {
            this.addToMap(testOutcome.getFlags());
        }
        return NewMap.copyOf(this.flagMap);
    }

    private void addToMap(Set<? extends Flag> flags) {
        for (Flag flag : flags) {
            if (this.flagMap.containsKey(flag)) {
                this.flagMap.put(flag, this.flagMap.get(flag) + 1);
                continue;
            }
            this.flagMap.put(flag, 1);
        }
    }
}

