/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.AcceptanceTestLoader;
import net.thucydides.core.reports.json.JSONTestOutcomeReporter;

public class TestOutcomeStream
implements Iterable<TestOutcome>,
Closeable {
    private final DirectoryStream<Path> directoryStream;
    private final Iterator<Path> directoryStreamIterator;
    private final AcceptanceTestLoader loader;

    private TestOutcomeStream(Path sourceDirectory) throws IOException {
        this.directoryStream = Files.newDirectoryStream(sourceDirectory);
        this.directoryStreamIterator = Files.newDirectoryStream(sourceDirectory).iterator();
        this.loader = new JSONTestOutcomeReporter();
    }

    public static TestOutcomeStream testOutcomesInDirectory(Path sourceDirectory) throws IOException {
        return new TestOutcomeStream(sourceDirectory);
    }

    @Override
    public Iterator<TestOutcome> iterator() {
        return new Iterator<TestOutcome>(){
            Optional<TestOutcome> nextOutcome;
            NextItemIs nextItemIs = NextItemIs.Unknown;

            @Override
            public boolean hasNext() {
                this.fetchNext();
                return this.nextOutcome.isPresent();
            }

            private void fetchNext() {
                this.nextOutcome = this.findNextValidTestOutcomeIn(TestOutcomeStream.this.directoryStreamIterator);
                this.nextItemIs = NextItemIs.ReadyToRetrieve;
            }

            private Optional<TestOutcome> findNextValidTestOutcomeIn(Iterator<Path> directoryStream) {
                while (directoryStream.hasNext()) {
                    Optional<TestOutcome> nextOutcomeFromStream = TestOutcomeStream.this.loader.loadReportFrom(directoryStream.next());
                    if (!nextOutcomeFromStream.isPresent()) continue;
                    return nextOutcomeFromStream;
                }
                return Optional.empty();
            }

            @Override
            public TestOutcome next() {
                if (this.nextItemIs == NextItemIs.Unknown) {
                    this.fetchNext();
                }
                this.nextItemIs = NextItemIs.Retrieved;
                return this.nextOutcome.orElseThrow(NoSuchElementException::new);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.directoryStream.close();
    }

    static enum NextItemIs {
        Unknown,
        ReadyToRetrieve,
        Retrieved;

    }
}

