/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.remoteTesting;

import com.google.inject.Inject;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.remoteTesting.ASaucelabsConfiguration;
import net.thucydides.core.reports.remoteTesting.LinkGenerator;
import net.thucydides.core.reports.remoteTesting.SaucelabsLinkGenerator;
import net.thucydides.core.util.EnvironmentVariables;

public class RemoteTestingLinkManager
implements LinkGenerator {
    private EnvironmentVariables environmentVariables;

    public RemoteTestingLinkManager() {
    }

    @Inject
    public RemoteTestingLinkManager(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String linkFor(TestOutcome testOutcome) {
        if (this.noSessionIdIsFoundFor(testOutcome)) {
            return null;
        }
        if (this.browserStackIsConfigured() && testOutcome.getExternalLink() != null) {
            return testOutcome.getExternalLink().getUrl();
        }
        if (ASaucelabsConfiguration.isDefinedIn(this.environmentVariables)) {
            SaucelabsLinkGenerator saucelabsLinkGenerator = new SaucelabsLinkGenerator(this.environmentVariables);
            return saucelabsLinkGenerator.linkFor(testOutcome);
        }
        return null;
    }

    private boolean noSessionIdIsFoundFor(TestOutcome testOutcome) {
        return testOutcome.getSessionId() == null;
    }

    private boolean browserStackIsConfigured() {
        return ThucydidesSystemProperty.BROWSERSTACK_USER.from(this.environmentVariables) != null;
    }

    private boolean sauceLabsIsConfigured() {
        return ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables) != null;
    }
}

