/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.annotations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.core.adapters.TestFramework;
import net.thucydides.core.annotations.Issue;
import net.thucydides.core.annotations.Issues;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.Title;
import net.thucydides.core.annotations.Version;
import net.thucydides.core.annotations.WithTag;
import net.thucydides.core.annotations.WithTagValuesOf;
import net.thucydides.core.annotations.WithTags;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.formatters.ReportFormatter;
import net.thucydides.core.reflection.MethodFinder;
import net.thucydides.core.tags.TagConverters;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;

public class TestAnnotations {
    private final Class<?> testClass;
    private final List<TestTag> NO_TAGS = new ArrayList<TestTag>();

    private TestAnnotations(Class<?> testClass) {
        this.testClass = testClass;
    }

    public static TestAnnotations forClass(Class<?> testClass) {
        return new TestAnnotations(testClass);
    }

    public Optional<String> getAnnotatedTitleForMethod(String methodName) {
        if (this.testClass != null && this.testClassHasMethodCalled(methodName)) {
            return this.getAnnotatedTitle(methodName);
        }
        return Optional.empty();
    }

    public boolean isPending(String methodName) {
        Optional<Method> method = this.getMethodByNameIgnoringNumberOfParameters(methodName);
        return method.isPresent() && TestAnnotations.isPending(method.get());
    }

    public static boolean isPending(Method method) {
        return method != null && method.getAnnotation(Pending.class) != null;
    }

    public static boolean isIgnored(Method method) {
        return TestFramework.support().isIgnored(method);
    }

    public static boolean shouldSkipNested(Method method) {
        if (method != null) {
            Step stepAnnotation = method.getAnnotation(Step.class);
            return stepAnnotation != null && !stepAnnotation.callNestedMethods();
        }
        return false;
    }

    public static boolean isAnExampleStep(Method method) {
        if (method != null) {
            Step stepAnnotation = method.getAnnotation(Step.class);
            return stepAnnotation != null && stepAnnotation.exampleRow();
        }
        return false;
    }

    public boolean isIgnored(String methodName) {
        Optional<Method> method = this.getMethodByNameIgnoringNumberOfParameters(methodName);
        return method.isPresent() && TestAnnotations.isIgnored(method.get());
    }

    private Optional<String> getAnnotatedTitle(String methodName) {
        Title titleAnnotation;
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && (titleAnnotation = testMethod.get().getAnnotation(Title.class)) != null) {
            return Optional.of(titleAnnotation.value());
        }
        return Optional.empty();
    }

    private boolean testClassHasMethodCalled(String methodName) {
        return this.getMethodCalled(methodName).isPresent();
    }

    private Optional<Method> getMethodCalled(String methodName) {
        if (this.testClass == null) {
            return Optional.empty();
        }
        String baseMethodName = NameConverter.withNoArguments(methodName);
        if (baseMethodName == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(MethodFinder.inClass(this.testClass).getMethodNamed(baseMethodName));
    }

    private Optional<Method> getMethodByNameIgnoringNumberOfParameters(String methodName) {
        if (this.testClass == null) {
            return Optional.empty();
        }
        String baseMethodName = NameConverter.withNoArguments(methodName);
        if (baseMethodName == null) {
            return Optional.empty();
        }
        return this.getFirstMethodWithName(methodName);
    }

    private Optional<Method> getFirstMethodWithName(String methodName) {
        return Arrays.stream(this.testClass.getMethods()).filter(method -> method.getName().equals(methodName)).findFirst();
    }

    List<String> getAnnotatedIssuesForMethodTitle(String methodName) {
        Optional<String> title = this.getAnnotatedTitleForMethod(methodName);
        return title.map(ReportFormatter::issuesIn).orElseGet(() -> ReportFormatter.issuesIn(methodName));
    }

    private Optional<String> getAnnotatedIssue(String methodName) {
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && testMethod.get().getAnnotation(Issue.class) != null) {
            return Optional.of(testMethod.get().getAnnotation(Issue.class).value());
        }
        return Optional.empty();
    }

    private Optional<String> getAnnotatedVersion(String methodName) {
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && testMethod.get().getAnnotation(Version.class) != null) {
            return Optional.of(testMethod.get().getAnnotation(Version.class).value());
        }
        return Optional.empty();
    }

    private String[] getAnnotatedIssues(String methodName) {
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent() && testMethod.get().getAnnotation(Issues.class) != null) {
            return testMethod.get().getAnnotation(Issues.class).value();
        }
        return new String[0];
    }

    public Optional<String> getAnnotatedIssueForMethod(String methodName) {
        return this.getAnnotatedIssue(methodName);
    }

    public Optional<String> getAnnotatedVersionForMethod(String methodName) {
        return this.getAnnotatedVersion(methodName);
    }

    public String[] getAnnotatedIssuesForMethod(String methodName) {
        return this.getAnnotatedIssues(methodName);
    }

    public String getAnnotatedIssueForTestCase(Class<?> testCase) {
        Issue issueAnnotation = testCase.getAnnotation(Issue.class);
        if (issueAnnotation != null) {
            return issueAnnotation.value();
        }
        return null;
    }

    public String getAnnotatedVersionForTestCase(Class<?> testCase) {
        Version versionAnnotation = testCase.getAnnotation(Version.class);
        if (versionAnnotation != null) {
            return versionAnnotation.value();
        }
        return null;
    }

    public String[] getAnnotatedIssuesForTestCase(Class<?> testCase) {
        Issues issueAnnotation = testCase.getAnnotation(Issues.class);
        if (issueAnnotation != null) {
            return issueAnnotation.value();
        }
        return null;
    }

    List<String> getIssuesForMethod(String methodName) {
        ArrayList<String> issues = new ArrayList<String>();
        if (this.testClass != null) {
            this.addIssuesFromMethod(methodName, issues);
        } else {
            this.addIssuesFromTestScenarioName(methodName, issues);
        }
        return issues;
    }

    private void addIssuesFromTestScenarioName(String methodName, List<String> issues) {
        issues.addAll(this.getAnnotatedIssuesForMethodTitle(methodName));
    }

    private void addIssuesFromMethod(String methodName, List<String> issues) {
        if (this.getAnnotatedIssues(methodName) != null) {
            issues.addAll(Arrays.asList(this.getAnnotatedIssues(methodName)));
        }
        if (this.getAnnotatedIssue(methodName).isPresent()) {
            issues.add(this.getAnnotatedIssue(methodName).get());
        }
        if (this.getAnnotatedTitle(methodName) != null) {
            this.addIssuesFromTestScenarioName(methodName, issues);
        }
    }

    public List<TestTag> getTagsForMethod(String methodName) {
        ArrayList<TestTag> allTags = new ArrayList<TestTag>(this.getClassTags());
        allTags.addAll(this.getTagsFor(methodName));
        return new ArrayList<TestTag>(allTags);
    }

    public List<TestTag> getClassTags() {
        return this.getClassTags(this.testClass);
    }

    public List<TestTag> getAllTags() {
        HashSet<TestTag> classTags = new HashSet<TestTag>(this.getClassTags(this.testClass));
        classTags.addAll(Arrays.stream(this.testClass.getMethods()).filter(method -> method.getDeclaredAnnotation(WithTag.class) != null).map(method -> method.getDeclaredAnnotation(WithTag.class).value()).map(TestTag::withValue).collect(Collectors.toSet()));
        classTags.addAll(Arrays.stream(this.testClass.getDeclaredMethods()).filter(method -> method.getDeclaredAnnotation(WithTag.class) != null).map(method -> method.getDeclaredAnnotation(WithTag.class).value()).map(TestTag::withValue).collect(Collectors.toSet()));
        return new ArrayList<TestTag>(classTags);
    }

    private List<TestTag> getClassTags(Class<?> testClass) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        if (testClass == null) {
            return this.NO_TAGS;
        }
        TestAnnotations.addTagValues(tags, testClass.getAnnotation(WithTagValuesOf.class));
        TestAnnotations.addTags(tags, testClass.getAnnotation(WithTags.class));
        TestAnnotations.addTag(tags, testClass.getAnnotation(WithTag.class));
        if (testClass.getSuperclass() != Object.class) {
            tags.addAll(this.getClassTags(testClass.getSuperclass()));
        }
        return tags;
    }

    public static void addTag(List<TestTag> tags, WithTag tagAnnotation) {
        if (tagAnnotation != null) {
            tags.add(TestAnnotations.convertToTestTag(tagAnnotation));
        }
    }

    public static void addTags(List<TestTag> tags, WithTags tagSet) {
        if (tagSet != null) {
            Set newTags = Arrays.stream(tagSet.value()).map(TagConverters::convertToTestTag).collect(Collectors.toSet());
            tags.addAll(newTags);
        }
    }

    public static void addTagValues(List<TestTag> tags, WithTagValuesOf tagSet) {
        if (tagSet != null) {
            Set newTags = Arrays.stream(tagSet.value()).map(TestTag::withValue).collect(Collectors.toSet());
            tags.addAll(newTags);
        }
    }

    private List<TestTag> getTagsFor(String methodName) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        Optional<Method> testMethod = this.getMethodCalled(methodName);
        if (testMethod.isPresent()) {
            return TestFramework.support().getTagsFor(testMethod.get());
        }
        return tags;
    }

    public static TestTag convertToTestTag(WithTag withTag) {
        if (StringUtils.isEmpty((CharSequence)withTag.value())) {
            return TestTag.withName(withTag.name()).andType(withTag.type());
        }
        return TestTag.withValue(withTag.value());
    }

    public List<String> getTestMethodNames() {
        return Arrays.stream(this.testClass.getDeclaredMethods()).filter(method -> this.hasAnnotationNamed((Method)method, "Test")).map(Method::getName).collect(Collectors.toList());
    }

    private boolean hasAnnotationNamed(Method method, String annotationName) {
        return Arrays.stream(method.getAnnotations()).anyMatch(annotation -> annotation.toString().contains("." + annotationName + "("));
    }
}

