/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.formatters;

import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestType;
import net.thucydides.core.reports.TestOutcomeCounter;
import net.thucydides.core.reports.TestOutcomes;

public class TestCoverageFormatter {
    private final TestOutcomes outcomes;
    private final NumericalFormatter formatter;

    public TestCoverageFormatter(TestOutcomes outcomes) {
        this.outcomes = outcomes;
        this.formatter = new NumericalFormatter();
    }

    public FormattedPercentageCoverage percentTests(String testType) {
        return this.percentTests(TestType.valueOf(testType.toUpperCase()));
    }

    public FormattedPercentageCoverage percentTests(TestType testType) {
        return new FormattedPercentageCoverage(testType);
    }

    public FormattedPercentageCoverage percentTests() {
        return new FormattedPercentageCoverage(TestType.ANY);
    }

    public FormattedPercentageCoverage getPercentTests() {
        return this.percentTests();
    }

    public FormattedPercentageStepCoverage getPercentSteps() {
        return this.percentSteps();
    }

    public FormattedPercentageStepCoverage percentSteps() {
        return this.percentSteps(TestType.ANY);
    }

    public FormattedPercentageStepCoverage percentSteps(String testType) {
        return this.percentSteps(TestType.valueOf(testType.toUpperCase()));
    }

    public FormattedPercentageStepCoverage percentSteps(TestType testType) {
        return new FormattedPercentageStepCoverage(testType);
    }

    public class FormattedPercentageCoverage
    extends FormattedCoverage {
        public FormattedPercentageCoverage(TestType testType) {
            super(testType);
        }

        @Override
        protected double percentageDeterminedResult() {
            return TestCoverageFormatter.this.outcomes.proportionOf(this.testType).withResult(TestResult.ERROR) + TestCoverageFormatter.this.outcomes.proportionOf(this.testType).withResult(TestResult.FAILURE) + TestCoverageFormatter.this.outcomes.proportionOf(this.testType).withResult(TestResult.COMPROMISED) + TestCoverageFormatter.this.outcomes.proportionOf(this.testType).withResult(TestResult.SUCCESS);
        }

        @Override
        protected double percentageWithResult(TestResult expectedResult) {
            return TestCoverageFormatter.this.outcomes.proportionOf(this.testType).withResult(expectedResult);
        }

        protected double percentageWithResult(String expectedResult) {
            return this.percentageWithResult(TestResult.valueOf(expectedResult.toUpperCase()));
        }
    }

    public class FormattedPercentageStepCoverage
    extends FormattedCoverage {
        public FormattedPercentageStepCoverage(TestType testType) {
            super(testType);
        }

        @Override
        protected double percentageDeterminedResult() {
            return TestCoverageFormatter.this.outcomes.proportionalStepsOf(this.testType).withResult(TestResult.ERROR) + TestCoverageFormatter.this.outcomes.proportionalStepsOf(this.testType).withResult(TestResult.FAILURE) + TestCoverageFormatter.this.outcomes.proportionalStepsOf(this.testType).withResult(TestResult.COMPROMISED) + TestCoverageFormatter.this.outcomes.proportionalStepsOf(this.testType).withResult(TestResult.SUCCESS);
        }

        @Override
        protected double percentageWithResult(TestResult expectedResult) {
            return TestCoverageFormatter.this.outcomes.proportionalStepsOf(this.testType).withResult(expectedResult);
        }
    }

    public abstract class FormattedCoverage
    extends TestOutcomeCounter {
        int precision;

        public FormattedCoverage(TestType testType) {
            super(testType);
            this.precision = 1;
        }

        public FormattedCoverage withPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public String withResult(String expectedResult) {
            return this.withResult(TestResult.valueOf(expectedResult.toUpperCase()));
        }

        protected abstract double percentageDeterminedResult();

        protected abstract double percentageWithResult(TestResult var1);

        public String withResult(TestResult expectedResult) {
            return this.withResult(expectedResult, this.precision);
        }

        public String withResult(TestResult expectedResult, int precision) {
            return TestCoverageFormatter.this.formatter.percentage(this.percentageWithResult(expectedResult), precision);
        }

        public String withIndeterminateResult() {
            return TestCoverageFormatter.this.formatter.percentage(1.0 - this.percentageDeterminedResult(), this.precision);
        }

        public String withFailureOrError() {
            return TestCoverageFormatter.this.formatter.percentage(this.percentageWithResult(TestResult.FAILURE) + this.percentageWithResult(TestResult.ERROR) + this.percentageWithResult(TestResult.ABORTED) + this.percentageWithResult(TestResult.COMPROMISED), this.precision);
        }

        public String withSkippedOrIgnored() {
            return TestCoverageFormatter.this.formatter.percentage(this.percentageWithResult(TestResult.SKIPPED) + this.percentageWithResult(TestResult.IGNORED), this.precision);
        }
    }
}

