/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.configuration;

import com.google.inject.Inject;
import java.io.File;
import java.util.Optional;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.configuration.FilePathParser;
import net.thucydides.core.configuration.MavenOrGradleBuildPath;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import org.apache.commons.lang3.StringUtils;

public class SystemPropertiesConfiguration
implements Configuration {
    public static final int DEFAULT_ELEMENT_TIMEOUT_SECONDS = 5;
    public static final Integer DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT = 5;
    public static final String PROJECT_BUILD_DIRECTORY = "project.build.directory";
    public static final String REFUSE_UNTRUSTED_CERTIFICATES = ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.getPropertyName();
    protected File outputDirectory;
    private File historyDirectory;
    protected String defaultBaseUrl;
    protected EnvironmentVariables environmentVariables;
    private final FilePathParser filePathParser;

    @Inject
    public SystemPropertiesConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.filePathParser = new FilePathParser(environmentVariables);
    }

    public SystemPropertiesConfiguration withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    @Override
    public EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public File loadOutputDirectoryFromSystemProperties() {
        String systemDefinedDirectory = MavenOrGradleBuildPath.specifiedIn(this.environmentVariables).getBuildDirectory();
        systemDefinedDirectory = this.filePathParser.getInstanciatedPath(systemDefinedDirectory);
        File newOutputDirectory = new File(systemDefinedDirectory);
        newOutputDirectory.mkdirs();
        return newOutputDirectory;
    }

    public File loadHistoryDirectoryFromSystemProperties() {
        String systemDefinedDirectory = MavenOrGradleBuildPath.specifiedIn(this.environmentVariables).getHistoryDirectory();
        systemDefinedDirectory = this.filePathParser.getInstanciatedPath(systemDefinedDirectory);
        File newOutputDirectory = new File(systemDefinedDirectory);
        newOutputDirectory.mkdirs();
        return newOutputDirectory;
    }

    public void reloadOutputDirectory() {
        this.setOutputDirectory(this.loadOutputDirectoryFromSystemProperties());
    }

    @Override
    public int getStepDelay() {
        int stepDelay = 0;
        String stepDelayValue = this.propertyNamed(ThucydidesSystemProperty.SERENITY_STEP_DELAY);
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            stepDelay = Integer.parseInt(stepDelayValue);
        }
        return stepDelay;
    }

    @Override
    public int getElementTimeoutInSeconds() {
        Optional<Integer> serenityDefinedTimeoutInSeconds = this.integerPropertyNamed(ThucydidesSystemProperty.SERENITY_TIMEOUT);
        Optional<Integer> implicitTimeoutInMilliseconds = this.integerPropertyNamed(ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT);
        if (serenityDefinedTimeoutInSeconds.isPresent()) {
            return serenityDefinedTimeoutInSeconds.get();
        }
        return implicitTimeoutInMilliseconds.map(integer -> integer / 1000).orElse(5);
    }

    private Optional<Integer> integerValueOf(String value) {
        if (value != null && !value.isEmpty()) {
            return Optional.of(Integer.parseInt(value));
        }
        return Optional.empty();
    }

    @Override
    @Deprecated
    public boolean getUseUniqueBrowser() {
        return this.shouldUseAUniqueBrowser();
    }

    @Override
    @Deprecated
    public boolean shouldUseAUniqueBrowser() {
        return ThucydidesSystemProperty.THUCYDIDES_USE_UNIQUE_BROWSER.booleanFrom(this.getEnvironmentVariables());
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public File getOutputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.loadOutputDirectoryFromSystemProperties();
        }
        return this.outputDirectory;
    }

    @Override
    public File getHistoryDirectory() {
        if (this.historyDirectory == null) {
            this.historyDirectory = this.loadHistoryDirectoryFromSystemProperties();
        }
        return this.historyDirectory;
    }

    @Override
    public double getEstimatedAverageStepCount() {
        return this.integerPropertyNamed(ThucydidesSystemProperty.SERENITY_ESTIMATED_AVERAGE_STEP_COUNT, DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT).intValue();
    }

    @Override
    public boolean onlySaveFailingScreenshots() {
        return Boolean.parseBoolean(this.propertyNamed(ThucydidesSystemProperty.THUCYDIDES_ONLY_SAVE_FAILING_SCREENSHOTS, "false"));
    }

    @Override
    public boolean takeVerboseScreenshots() {
        return Boolean.parseBoolean(this.propertyNamed(ThucydidesSystemProperty.THUCYDIDES_VERBOSE_SCREENSHOTS, "false"));
    }

    @Override
    public Optional<TakeScreenshots> getScreenshotLevel() {
        String takeScreenshotsLevel = this.propertyNamed(ThucydidesSystemProperty.SERENITY_TAKE_SCREENSHOTS);
        if (StringUtils.isNotEmpty((CharSequence)takeScreenshotsLevel)) {
            return Optional.of(TakeScreenshots.valueOf(takeScreenshotsLevel.toUpperCase()));
        }
        return Optional.empty();
    }

    @Override
    public void setIfUndefined(String property, String value) {
        if (this.getEnvironmentVariables().getProperty(property) == null) {
            this.getEnvironmentVariables().setProperty(property, value);
        }
    }

    @Override
    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    @Override
    public int getRestartFrequency() {
        return ThucydidesSystemProperty.SERENITY_RESTART_BROWSER_FREQUENCY.integerFrom(this.environmentVariables);
    }

    @Override
    public int getCurrentTestCount() {
        return 0;
    }

    @Override
    public String getBaseUrl() {
        return this.propertyNamed(ThucydidesSystemProperty.WEBDRIVER_BASE_URL, this.defaultBaseUrl);
    }

    private String propertyNamed(ThucydidesSystemProperty property, String defaultValue) {
        return EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalProperty(property.getPropertyName(), property.getLegacyPropertyName()).orElse(defaultValue);
    }

    private Optional<Integer> integerPropertyNamed(ThucydidesSystemProperty property) {
        return EnvironmentSpecificConfiguration.from(this.environmentVariables).getOptionalInteger(property.getPropertyName(), property.getLegacyPropertyName());
    }

    private Integer integerPropertyNamed(ThucydidesSystemProperty property, int defaultValue) {
        return this.integerPropertyNamed(property).orElse(defaultValue);
    }

    private String propertyNamed(ThucydidesSystemProperty propertyName) {
        return this.propertyNamed(propertyName, null);
    }
}

