/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.csv.CSVReporter;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.Merger;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseReportingTask
implements ReportingTask {
    final FreemarkerContext freemarker;
    final EnvironmentVariables environmentVariables;
    final File outputDirectory;
    protected static final Logger LOGGER = LoggerFactory.getLogger(ReportingTask.class);

    public BaseReportingTask(FreemarkerContext freemarker, EnvironmentVariables environmentVariables, File outputDirectory) {
        this.freemarker = freemarker;
        this.environmentVariables = environmentVariables;
        this.outputDirectory = outputDirectory;
    }

    @Override
    public abstract void generateReports() throws IOException;

    protected void generateReportPage(Map<String, Object> context, String template, String outputFile) throws IOException {
        Path outputPath = this.outputDirectory.toPath().resolve(outputFile);
        long start = System.currentTimeMillis();
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.mergeTemplate(template).withContext(context).to(writer);
        }
    }

    protected Merger mergeTemplate(String templateFile) {
        return new Merger(templateFile);
    }

    protected Optional<String> generateCSVReportFor(TestOutcomes testOutcomes, String reportName) throws IOException {
        if (this.csvReportsAreActivated()) {
            CSVReporter csvReporter = new CSVReporter(this.outputDirectory, this.environmentVariables);
            csvReporter.generateReportFor(testOutcomes, reportName);
            return Optional.of(reportName);
        }
        return Optional.empty();
    }

    private boolean csvReportsAreActivated() {
        return ThucydidesSystemProperty.SERENITY_GENERATE_CSV_REPORTS.booleanFrom(this.environmentVariables, Boolean.valueOf(true));
    }
}

